/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResolverConfigsResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<ListResolverConfigsResponse.Builder, ListResolverConfigsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResolverConfigsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ResolverConfig>> RESOLVER_CONFIGS_FIELD = SdkField
            .<List<ResolverConfig>> builder(MarshallingType.LIST)
            .memberName("ResolverConfigs")
            .getter(getter(ListResolverConfigsResponse::resolverConfigs))
            .setter(setter(Builder::resolverConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResolverConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResolverConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RESOLVER_CONFIGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ResolverConfig> resolverConfigs;

    private ListResolverConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.resolverConfigs = builder.resolverConfigs;
    }

    /**
     * <p>
     * If a response includes the last of the Resolver configurations that are associated with the current Amazon Web
     * Services account, <code>NextToken</code> doesn't appear in the response.
     * </p>
     * <p>
     * If a response doesn't include the last of the configurations, you can get more configurations by submitting
     * another <code>ListResolverConfigs</code> request. Get the value of <code>NextToken</code> that Amazon Route 53
     * returned in the previous response and include it in <code>NextToken</code> in the next request.
     * </p>
     * 
     * @return If a response includes the last of the Resolver configurations that are associated with the current
     *         Amazon Web Services account, <code>NextToken</code> doesn't appear in the response.</p>
     *         <p>
     *         If a response doesn't include the last of the configurations, you can get more configurations by
     *         submitting another <code>ListResolverConfigs</code> request. Get the value of <code>NextToken</code> that
     *         Amazon Route 53 returned in the previous response and include it in <code>NextToken</code> in the next
     *         request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResolverConfigs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResolverConfigs() {
        return resolverConfigs != null && !(resolverConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains one <code>ResolverConfigs</code> element for each Resolver configuration that is
     * associated with the current Amazon Web Services account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResolverConfigs} method.
     * </p>
     * 
     * @return An array that contains one <code>ResolverConfigs</code> element for each Resolver configuration that is
     *         associated with the current Amazon Web Services account.
     */
    public final List<ResolverConfig> resolverConfigs() {
        return resolverConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasResolverConfigs() ? resolverConfigs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResolverConfigsResponse)) {
            return false;
        }
        ListResolverConfigsResponse other = (ListResolverConfigsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasResolverConfigs() == other.hasResolverConfigs()
                && Objects.equals(resolverConfigs(), other.resolverConfigs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResolverConfigsResponse").add("NextToken", nextToken())
                .add("ResolverConfigs", hasResolverConfigs() ? resolverConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ResolverConfigs":
            return Optional.ofNullable(clazz.cast(resolverConfigs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ResolverConfigs", RESOLVER_CONFIGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResolverConfigsResponse, T> g) {
        return obj -> g.apply((ListResolverConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResolverConfigsResponse> {
        /**
         * <p>
         * If a response includes the last of the Resolver configurations that are associated with the current Amazon
         * Web Services account, <code>NextToken</code> doesn't appear in the response.
         * </p>
         * <p>
         * If a response doesn't include the last of the configurations, you can get more configurations by submitting
         * another <code>ListResolverConfigs</code> request. Get the value of <code>NextToken</code> that Amazon
         * Route 53 returned in the previous response and include it in <code>NextToken</code> in the next request.
         * </p>
         * 
         * @param nextToken
         *        If a response includes the last of the Resolver configurations that are associated with the current
         *        Amazon Web Services account, <code>NextToken</code> doesn't appear in the response.</p>
         *        <p>
         *        If a response doesn't include the last of the configurations, you can get more configurations by
         *        submitting another <code>ListResolverConfigs</code> request. Get the value of <code>NextToken</code>
         *        that Amazon Route 53 returned in the previous response and include it in <code>NextToken</code> in the
         *        next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array that contains one <code>ResolverConfigs</code> element for each Resolver configuration that is
         * associated with the current Amazon Web Services account.
         * </p>
         * 
         * @param resolverConfigs
         *        An array that contains one <code>ResolverConfigs</code> element for each Resolver configuration that
         *        is associated with the current Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverConfigs(Collection<ResolverConfig> resolverConfigs);

        /**
         * <p>
         * An array that contains one <code>ResolverConfigs</code> element for each Resolver configuration that is
         * associated with the current Amazon Web Services account.
         * </p>
         * 
         * @param resolverConfigs
         *        An array that contains one <code>ResolverConfigs</code> element for each Resolver configuration that
         *        is associated with the current Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverConfigs(ResolverConfig... resolverConfigs);

        /**
         * <p>
         * An array that contains one <code>ResolverConfigs</code> element for each Resolver configuration that is
         * associated with the current Amazon Web Services account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53resolver.model.ResolverConfig.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.route53resolver.model.ResolverConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53resolver.model.ResolverConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #resolverConfigs(List<ResolverConfig>)}.
         * 
         * @param resolverConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53resolver.model.ResolverConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolverConfigs(java.util.Collection<ResolverConfig>)
         */
        Builder resolverConfigs(Consumer<ResolverConfig.Builder>... resolverConfigs);
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ResolverConfig> resolverConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListResolverConfigsResponse model) {
            super(model);
            nextToken(model.nextToken);
            resolverConfigs(model.resolverConfigs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ResolverConfig.Builder> getResolverConfigs() {
            List<ResolverConfig.Builder> result = ResolverConfigListCopier.copyToBuilder(this.resolverConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResolverConfigs(Collection<ResolverConfig.BuilderImpl> resolverConfigs) {
            this.resolverConfigs = ResolverConfigListCopier.copyFromBuilder(resolverConfigs);
        }

        @Override
        public final Builder resolverConfigs(Collection<ResolverConfig> resolverConfigs) {
            this.resolverConfigs = ResolverConfigListCopier.copy(resolverConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolverConfigs(ResolverConfig... resolverConfigs) {
            resolverConfigs(Arrays.asList(resolverConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolverConfigs(Consumer<ResolverConfig.Builder>... resolverConfigs) {
            resolverConfigs(Stream.of(resolverConfigs).map(c -> ResolverConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListResolverConfigsResponse build() {
            return new ListResolverConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
