/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutResolverQueryLogConfigPolicyRequest extends Route53ResolverRequest implements
        ToCopyableBuilder<PutResolverQueryLogConfigPolicyRequest.Builder, PutResolverQueryLogConfigPolicyRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(PutResolverQueryLogConfigPolicyRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> RESOLVER_QUERY_LOG_CONFIG_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResolverQueryLogConfigPolicy")
            .getter(getter(PutResolverQueryLogConfigPolicyRequest::resolverQueryLogConfigPolicy))
            .setter(setter(Builder::resolverQueryLogConfigPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverQueryLogConfigPolicy")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            RESOLVER_QUERY_LOG_CONFIG_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String resolverQueryLogConfigPolicy;

    private PutResolverQueryLogConfigPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.resolverQueryLogConfigPolicy = builder.resolverQueryLogConfigPolicy;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the account that you want to share rules with.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the account that you want to share rules with.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * An Identity and Access Management policy statement that lists the query logging configurations that you want to
     * share with another Amazon Web Services account and the operations that you want the account to be able to
     * perform. You can specify the following operations in the <code>Actions</code> section of the statement:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>route53resolver:AssociateResolverQueryLogConfig</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route53resolver:DisassociateResolverQueryLogConfig</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route53resolver:ListResolverQueryLogConfigs</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * In the <code>Resource</code> section of the statement, you specify the ARNs for the query logging configurations
     * that you want to share with the account that you specified in <code>Arn</code>.
     * </p>
     * 
     * @return An Identity and Access Management policy statement that lists the query logging configurations that you
     *         want to share with another Amazon Web Services account and the operations that you want the account to be
     *         able to perform. You can specify the following operations in the <code>Actions</code> section of the
     *         statement:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>route53resolver:AssociateResolverQueryLogConfig</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route53resolver:DisassociateResolverQueryLogConfig</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route53resolver:ListResolverQueryLogConfigs</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         In the <code>Resource</code> section of the statement, you specify the ARNs for the query logging
     *         configurations that you want to share with the account that you specified in <code>Arn</code>.
     */
    public final String resolverQueryLogConfigPolicy() {
        return resolverQueryLogConfigPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(resolverQueryLogConfigPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResolverQueryLogConfigPolicyRequest)) {
            return false;
        }
        PutResolverQueryLogConfigPolicyRequest other = (PutResolverQueryLogConfigPolicyRequest) obj;
        return Objects.equals(arn(), other.arn())
                && Objects.equals(resolverQueryLogConfigPolicy(), other.resolverQueryLogConfigPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutResolverQueryLogConfigPolicyRequest").add("Arn", arn())
                .add("ResolverQueryLogConfigPolicy", resolverQueryLogConfigPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ResolverQueryLogConfigPolicy":
            return Optional.ofNullable(clazz.cast(resolverQueryLogConfigPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("ResolverQueryLogConfigPolicy", RESOLVER_QUERY_LOG_CONFIG_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutResolverQueryLogConfigPolicyRequest, T> g) {
        return obj -> g.apply((PutResolverQueryLogConfigPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53ResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutResolverQueryLogConfigPolicyRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the account that you want to share rules with.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the account that you want to share rules with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * An Identity and Access Management policy statement that lists the query logging configurations that you want
         * to share with another Amazon Web Services account and the operations that you want the account to be able to
         * perform. You can specify the following operations in the <code>Actions</code> section of the statement:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>route53resolver:AssociateResolverQueryLogConfig</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route53resolver:DisassociateResolverQueryLogConfig</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route53resolver:ListResolverQueryLogConfigs</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * In the <code>Resource</code> section of the statement, you specify the ARNs for the query logging
         * configurations that you want to share with the account that you specified in <code>Arn</code>.
         * </p>
         * 
         * @param resolverQueryLogConfigPolicy
         *        An Identity and Access Management policy statement that lists the query logging configurations that
         *        you want to share with another Amazon Web Services account and the operations that you want the
         *        account to be able to perform. You can specify the following operations in the <code>Actions</code>
         *        section of the statement:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>route53resolver:AssociateResolverQueryLogConfig</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route53resolver:DisassociateResolverQueryLogConfig</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route53resolver:ListResolverQueryLogConfigs</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        In the <code>Resource</code> section of the statement, you specify the ARNs for the query logging
         *        configurations that you want to share with the account that you specified in <code>Arn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverQueryLogConfigPolicy(String resolverQueryLogConfigPolicy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ResolverRequest.BuilderImpl implements Builder {
        private String arn;

        private String resolverQueryLogConfigPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResolverQueryLogConfigPolicyRequest model) {
            super(model);
            arn(model.arn);
            resolverQueryLogConfigPolicy(model.resolverQueryLogConfigPolicy);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getResolverQueryLogConfigPolicy() {
            return resolverQueryLogConfigPolicy;
        }

        public final void setResolverQueryLogConfigPolicy(String resolverQueryLogConfigPolicy) {
            this.resolverQueryLogConfigPolicy = resolverQueryLogConfigPolicy;
        }

        @Override
        public final Builder resolverQueryLogConfigPolicy(String resolverQueryLogConfigPolicy) {
            this.resolverQueryLogConfigPolicy = resolverQueryLogConfigPolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutResolverQueryLogConfigPolicyRequest build() {
            return new PutResolverQueryLogConfigPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
