/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * In the response to an <a
 * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html"
 * >AssociateResolverRule</a>, <a
 * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html"
 * >DisassociateResolverRule</a>, or <a href=
 * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html"
 * >ListResolverRuleAssociations</a> request, provides information about an association between a Resolver rule and a
 * VPC. The association determines which DNS queries that originate in the VPC are forwarded to your network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResolverRuleAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<ResolverRuleAssociation.Builder, ResolverRuleAssociation> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ResolverRuleAssociation::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> RESOLVER_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResolverRuleId").getter(getter(ResolverRuleAssociation::resolverRuleId))
            .setter(setter(Builder::resolverRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverRuleId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ResolverRuleAssociation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VPCId")
            .getter(getter(ResolverRuleAssociation::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ResolverRuleAssociation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(ResolverRuleAssociation::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            RESOLVER_RULE_ID_FIELD, NAME_FIELD, VPC_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String resolverRuleId;

    private final String name;

    private final String vpcId;

    private final String status;

    private final String statusMessage;

    private ResolverRuleAssociation(BuilderImpl builder) {
        this.id = builder.id;
        this.resolverRuleId = builder.resolverRuleId;
        this.name = builder.name;
        this.vpcId = builder.vpcId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The ID of the association between a Resolver rule and a VPC. Resolver assigns this value when you submit an <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html">
     * AssociateResolverRule</a> request.
     * </p>
     * 
     * @return The ID of the association between a Resolver rule and a VPC. Resolver assigns this value when you submit
     *         an <a href=
     *         "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html"
     *         >AssociateResolverRule</a> request.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the Resolver rule that you associated with the VPC that is specified by <code>VPCId</code>.
     * </p>
     * 
     * @return The ID of the Resolver rule that you associated with the VPC that is specified by <code>VPCId</code>.
     */
    public final String resolverRuleId() {
        return resolverRuleId;
    }

    /**
     * <p>
     * The name of an association between a Resolver rule and a VPC.
     * </p>
     * 
     * @return The name of an association between a Resolver rule and a VPC.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the VPC that you associated the Resolver rule with.
     * </p>
     * 
     * @return The ID of the VPC that you associated the Resolver rule with.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * A code that specifies the current status of the association between a Resolver rule and a VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResolverRuleAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return A code that specifies the current status of the association between a Resolver rule and a VPC.
     * @see ResolverRuleAssociationStatus
     */
    public final ResolverRuleAssociationStatus status() {
        return ResolverRuleAssociationStatus.fromValue(status);
    }

    /**
     * <p>
     * A code that specifies the current status of the association between a Resolver rule and a VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResolverRuleAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return A code that specifies the current status of the association between a Resolver rule and a VPC.
     * @see ResolverRuleAssociationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A detailed description of the status of the association between a Resolver rule and a VPC.
     * </p>
     * 
     * @return A detailed description of the status of the association between a Resolver rule and a VPC.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(resolverRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolverRuleAssociation)) {
            return false;
        }
        ResolverRuleAssociation other = (ResolverRuleAssociation) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(resolverRuleId(), other.resolverRuleId())
                && Objects.equals(name(), other.name()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResolverRuleAssociation").add("Id", id()).add("ResolverRuleId", resolverRuleId())
                .add("Name", name()).add("VPCId", vpcId()).add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ResolverRuleId":
            return Optional.ofNullable(clazz.cast(resolverRuleId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "VPCId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("ResolverRuleId", RESOLVER_RULE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("VPCId", VPC_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResolverRuleAssociation, T> g) {
        return obj -> g.apply((ResolverRuleAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResolverRuleAssociation> {
        /**
         * <p>
         * The ID of the association between a Resolver rule and a VPC. Resolver assigns this value when you submit an
         * <a href=
         * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html"
         * >AssociateResolverRule</a> request.
         * </p>
         * 
         * @param id
         *        The ID of the association between a Resolver rule and a VPC. Resolver assigns this value when you
         *        submit an <a href=
         *        "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html"
         *        >AssociateResolverRule</a> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the Resolver rule that you associated with the VPC that is specified by <code>VPCId</code>.
         * </p>
         * 
         * @param resolverRuleId
         *        The ID of the Resolver rule that you associated with the VPC that is specified by <code>VPCId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverRuleId(String resolverRuleId);

        /**
         * <p>
         * The name of an association between a Resolver rule and a VPC.
         * </p>
         * 
         * @param name
         *        The name of an association between a Resolver rule and a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the VPC that you associated the Resolver rule with.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC that you associated the Resolver rule with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * A code that specifies the current status of the association between a Resolver rule and a VPC.
         * </p>
         * 
         * @param status
         *        A code that specifies the current status of the association between a Resolver rule and a VPC.
         * @see ResolverRuleAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverRuleAssociationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * A code that specifies the current status of the association between a Resolver rule and a VPC.
         * </p>
         * 
         * @param status
         *        A code that specifies the current status of the association between a Resolver rule and a VPC.
         * @see ResolverRuleAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverRuleAssociationStatus
         */
        Builder status(ResolverRuleAssociationStatus status);

        /**
         * <p>
         * A detailed description of the status of the association between a Resolver rule and a VPC.
         * </p>
         * 
         * @param statusMessage
         *        A detailed description of the status of the association between a Resolver rule and a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String resolverRuleId;

        private String name;

        private String vpcId;

        private String status;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolverRuleAssociation model) {
            id(model.id);
            resolverRuleId(model.resolverRuleId);
            name(model.name);
            vpcId(model.vpcId);
            status(model.status);
            statusMessage(model.statusMessage);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getResolverRuleId() {
            return resolverRuleId;
        }

        public final void setResolverRuleId(String resolverRuleId) {
            this.resolverRuleId = resolverRuleId;
        }

        @Override
        public final Builder resolverRuleId(String resolverRuleId) {
            this.resolverRuleId = resolverRuleId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResolverRuleAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public ResolverRuleAssociation build() {
            return new ResolverRuleAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
