/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFirewallRuleGroupAssociationRequest extends Route53ResolverRequest implements
        ToCopyableBuilder<UpdateFirewallRuleGroupAssociationRequest.Builder, UpdateFirewallRuleGroupAssociationRequest> {
    private static final SdkField<String> FIREWALL_RULE_GROUP_ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FirewallRuleGroupAssociationId")
            .getter(getter(UpdateFirewallRuleGroupAssociationRequest::firewallRuleGroupAssociationId))
            .setter(setter(Builder::firewallRuleGroupAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallRuleGroupAssociationId")
                    .build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(UpdateFirewallRuleGroupAssociationRequest::priority))
            .setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<String> MUTATION_PROTECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MutationProtection")
            .getter(getter(UpdateFirewallRuleGroupAssociationRequest::mutationProtectionAsString))
            .setter(setter(Builder::mutationProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MutationProtection").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateFirewallRuleGroupAssociationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FIREWALL_RULE_GROUP_ASSOCIATION_ID_FIELD, PRIORITY_FIELD, MUTATION_PROTECTION_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String firewallRuleGroupAssociationId;

    private final Integer priority;

    private final String mutationProtection;

    private final String name;

    private UpdateFirewallRuleGroupAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.firewallRuleGroupAssociationId = builder.firewallRuleGroupAssociationId;
        this.priority = builder.priority;
        this.mutationProtection = builder.mutationProtection;
        this.name = builder.name;
    }

    /**
     * <p>
     * The identifier of the <a>FirewallRuleGroupAssociation</a>.
     * </p>
     * 
     * @return The identifier of the <a>FirewallRuleGroupAssociation</a>.
     */
    public final String firewallRuleGroupAssociationId() {
        return firewallRuleGroupAssociationId;
    }

    /**
     * <p>
     * The setting that determines the processing order of the rule group among the rule groups that you associate with
     * the specified VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority
     * setting.
     * </p>
     * <p>
     * You must specify a unique priority for each rule group that you associate with a single VPC. To make it easier to
     * insert rule groups later, leave space between the numbers, for example, use 100, 200, and so on. You can change
     * the priority setting for a rule group association after you create it.
     * </p>
     * 
     * @return The setting that determines the processing order of the rule group among the rule groups that you
     *         associate with the specified VPC. DNS Firewall filters VPC traffic starting from the rule group with the
     *         lowest numeric priority setting. </p>
     *         <p>
     *         You must specify a unique priority for each rule group that you associate with a single VPC. To make it
     *         easier to insert rule groups later, leave space between the numbers, for example, use 100, 200, and so
     *         on. You can change the priority setting for a rule group association after you create it.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * If enabled, this setting disallows modification or removal of the association, to help prevent against
     * accidentally altering DNS firewall protections.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mutationProtection} will return {@link MutationProtectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #mutationProtectionAsString}.
     * </p>
     * 
     * @return If enabled, this setting disallows modification or removal of the association, to help prevent against
     *         accidentally altering DNS firewall protections.
     * @see MutationProtectionStatus
     */
    public final MutationProtectionStatus mutationProtection() {
        return MutationProtectionStatus.fromValue(mutationProtection);
    }

    /**
     * <p>
     * If enabled, this setting disallows modification or removal of the association, to help prevent against
     * accidentally altering DNS firewall protections.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mutationProtection} will return {@link MutationProtectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #mutationProtectionAsString}.
     * </p>
     * 
     * @return If enabled, this setting disallows modification or removal of the association, to help prevent against
     *         accidentally altering DNS firewall protections.
     * @see MutationProtectionStatus
     */
    public final String mutationProtectionAsString() {
        return mutationProtection;
    }

    /**
     * <p>
     * The name of the rule group association.
     * </p>
     * 
     * @return The name of the rule group association.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(firewallRuleGroupAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(mutationProtectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFirewallRuleGroupAssociationRequest)) {
            return false;
        }
        UpdateFirewallRuleGroupAssociationRequest other = (UpdateFirewallRuleGroupAssociationRequest) obj;
        return Objects.equals(firewallRuleGroupAssociationId(), other.firewallRuleGroupAssociationId())
                && Objects.equals(priority(), other.priority())
                && Objects.equals(mutationProtectionAsString(), other.mutationProtectionAsString())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFirewallRuleGroupAssociationRequest")
                .add("FirewallRuleGroupAssociationId", firewallRuleGroupAssociationId()).add("Priority", priority())
                .add("MutationProtection", mutationProtectionAsString()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallRuleGroupAssociationId":
            return Optional.ofNullable(clazz.cast(firewallRuleGroupAssociationId()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "MutationProtection":
            return Optional.ofNullable(clazz.cast(mutationProtectionAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FirewallRuleGroupAssociationId", FIREWALL_RULE_GROUP_ASSOCIATION_ID_FIELD);
        map.put("Priority", PRIORITY_FIELD);
        map.put("MutationProtection", MUTATION_PROTECTION_FIELD);
        map.put("Name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFirewallRuleGroupAssociationRequest, T> g) {
        return obj -> g.apply((UpdateFirewallRuleGroupAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53ResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateFirewallRuleGroupAssociationRequest> {
        /**
         * <p>
         * The identifier of the <a>FirewallRuleGroupAssociation</a>.
         * </p>
         * 
         * @param firewallRuleGroupAssociationId
         *        The identifier of the <a>FirewallRuleGroupAssociation</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallRuleGroupAssociationId(String firewallRuleGroupAssociationId);

        /**
         * <p>
         * The setting that determines the processing order of the rule group among the rule groups that you associate
         * with the specified VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric
         * priority setting.
         * </p>
         * <p>
         * You must specify a unique priority for each rule group that you associate with a single VPC. To make it
         * easier to insert rule groups later, leave space between the numbers, for example, use 100, 200, and so on.
         * You can change the priority setting for a rule group association after you create it.
         * </p>
         * 
         * @param priority
         *        The setting that determines the processing order of the rule group among the rule groups that you
         *        associate with the specified VPC. DNS Firewall filters VPC traffic starting from the rule group with
         *        the lowest numeric priority setting. </p>
         *        <p>
         *        You must specify a unique priority for each rule group that you associate with a single VPC. To make
         *        it easier to insert rule groups later, leave space between the numbers, for example, use 100, 200, and
         *        so on. You can change the priority setting for a rule group association after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * If enabled, this setting disallows modification or removal of the association, to help prevent against
         * accidentally altering DNS firewall protections.
         * </p>
         * 
         * @param mutationProtection
         *        If enabled, this setting disallows modification or removal of the association, to help prevent against
         *        accidentally altering DNS firewall protections.
         * @see MutationProtectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MutationProtectionStatus
         */
        Builder mutationProtection(String mutationProtection);

        /**
         * <p>
         * If enabled, this setting disallows modification or removal of the association, to help prevent against
         * accidentally altering DNS firewall protections.
         * </p>
         * 
         * @param mutationProtection
         *        If enabled, this setting disallows modification or removal of the association, to help prevent against
         *        accidentally altering DNS firewall protections.
         * @see MutationProtectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MutationProtectionStatus
         */
        Builder mutationProtection(MutationProtectionStatus mutationProtection);

        /**
         * <p>
         * The name of the rule group association.
         * </p>
         * 
         * @param name
         *        The name of the rule group association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ResolverRequest.BuilderImpl implements Builder {
        private String firewallRuleGroupAssociationId;

        private Integer priority;

        private String mutationProtection;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFirewallRuleGroupAssociationRequest model) {
            super(model);
            firewallRuleGroupAssociationId(model.firewallRuleGroupAssociationId);
            priority(model.priority);
            mutationProtection(model.mutationProtection);
            name(model.name);
        }

        public final String getFirewallRuleGroupAssociationId() {
            return firewallRuleGroupAssociationId;
        }

        public final void setFirewallRuleGroupAssociationId(String firewallRuleGroupAssociationId) {
            this.firewallRuleGroupAssociationId = firewallRuleGroupAssociationId;
        }

        @Override
        public final Builder firewallRuleGroupAssociationId(String firewallRuleGroupAssociationId) {
            this.firewallRuleGroupAssociationId = firewallRuleGroupAssociationId;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getMutationProtection() {
            return mutationProtection;
        }

        public final void setMutationProtection(String mutationProtection) {
            this.mutationProtection = mutationProtection;
        }

        @Override
        public final Builder mutationProtection(String mutationProtection) {
            this.mutationProtection = mutationProtection;
            return this;
        }

        @Override
        public final Builder mutationProtection(MutationProtectionStatus mutationProtection) {
            this.mutationProtection(mutationProtection == null ? null : mutationProtection.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFirewallRuleGroupAssociationRequest build() {
            return new UpdateFirewallRuleGroupAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
