/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.rtbfabric.model.AcceptLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.AcceptLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.CreateInboundExternalLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.CreateInboundExternalLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.CreateLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.CreateLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.CreateOutboundExternalLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.CreateOutboundExternalLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.CreateRequesterGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.CreateRequesterGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.model.CreateResponderGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.CreateResponderGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.model.DeleteInboundExternalLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.DeleteInboundExternalLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.DeleteLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.DeleteLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.DeleteOutboundExternalLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.DeleteOutboundExternalLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.DeleteRequesterGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.DeleteRequesterGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.model.DeleteResponderGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.DeleteResponderGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetInboundExternalLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetInboundExternalLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetOutboundExternalLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetOutboundExternalLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetRequesterGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetRequesterGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetResponderGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetResponderGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.model.ListLinksRequest;
import software.amazon.awssdk.services.rtbfabric.model.ListLinksResponse;
import software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysRequest;
import software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysResponse;
import software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysRequest;
import software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysResponse;
import software.amazon.awssdk.services.rtbfabric.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.rtbfabric.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.rtbfabric.model.RejectLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.RejectLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.TagResourceRequest;
import software.amazon.awssdk.services.rtbfabric.model.TagResourceResponse;
import software.amazon.awssdk.services.rtbfabric.model.UntagResourceRequest;
import software.amazon.awssdk.services.rtbfabric.model.UntagResourceResponse;
import software.amazon.awssdk.services.rtbfabric.model.UpdateLinkModuleFlowRequest;
import software.amazon.awssdk.services.rtbfabric.model.UpdateLinkModuleFlowResponse;
import software.amazon.awssdk.services.rtbfabric.model.UpdateLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.UpdateLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.UpdateRequesterGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.UpdateRequesterGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.model.UpdateResponderGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.UpdateResponderGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.paginators.ListLinksPublisher;
import software.amazon.awssdk.services.rtbfabric.paginators.ListRequesterGatewaysPublisher;
import software.amazon.awssdk.services.rtbfabric.paginators.ListResponderGatewaysPublisher;
import software.amazon.awssdk.services.rtbfabric.waiters.RtbFabricAsyncWaiter;

/**
 * Service client for accessing RTBFabric asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * Amazon Web Services RTB Fabric provides secure, low-latency infrastructure for connecting real-time bidding (RTB)
 * applications. Rather than hosting applications directly, RTB Fabric acts as the connecting fabric that enables your
 * applications to communicate efficiently over private networks instead of the public internet. You maintain complete
 * control over your applications, data, and bidding decisions, while RTB Fabric provides the underlying infrastructure
 * for secure, reliable connectivity.
 * </p>
 * <p>
 * You can use these APIs to complete RTB Fabric tasks, such as setting up audit log ingestions or viewing user access.
 * For more information about RTB Fabric, including the required permissions to use the service, see the <a
 * href="https://docs.aws.amazon.com/rtb-fabric/latest/userguide/">Amazon Web Services RTB Fabric User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface RtbFabricAsyncClient extends AwsClient {
    String SERVICE_NAME = "rtbfabric";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "rtbfabric";

    /**
     * <p>
     * Accepts a link request between gateways.
     * </p>
     * <p>
     * When a requester gateway requests to link with a responder gateway, the responder can use this operation to
     * accept the link request and establish the connection.
     * </p>
     *
     * @param acceptLinkRequest
     * @return A Java Future containing the result of the AcceptLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.AcceptLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/AcceptLink" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AcceptLinkResponse> acceptLink(AcceptLinkRequest acceptLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a link request between gateways.
     * </p>
     * <p>
     * When a requester gateway requests to link with a responder gateway, the responder can use this operation to
     * accept the link request and establish the connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptLinkRequest.Builder} avoiding the need to
     * create one manually via {@link AcceptLinkRequest#builder()}
     * </p>
     *
     * @param acceptLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.AcceptLinkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AcceptLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.AcceptLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/AcceptLink" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AcceptLinkResponse> acceptLink(Consumer<AcceptLinkRequest.Builder> acceptLinkRequest) {
        return acceptLink(AcceptLinkRequest.builder().applyMutation(acceptLinkRequest).build());
    }

    /**
     * <p>
     * Creates an inbound external link.
     * </p>
     *
     * @param createInboundExternalLinkRequest
     * @return A Java Future containing the result of the CreateInboundExternalLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request could not be completed because you exceeded a service
     *         quota.</li>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.CreateInboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/CreateInboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInboundExternalLinkResponse> createInboundExternalLink(
            CreateInboundExternalLinkRequest createInboundExternalLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an inbound external link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInboundExternalLinkRequest.Builder} avoiding
     * the need to create one manually via {@link CreateInboundExternalLinkRequest#builder()}
     * </p>
     *
     * @param createInboundExternalLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.CreateInboundExternalLinkRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateInboundExternalLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request could not be completed because you exceeded a service
     *         quota.</li>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.CreateInboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/CreateInboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInboundExternalLinkResponse> createInboundExternalLink(
            Consumer<CreateInboundExternalLinkRequest.Builder> createInboundExternalLinkRequest) {
        return createInboundExternalLink(CreateInboundExternalLinkRequest.builder()
                .applyMutation(createInboundExternalLinkRequest).build());
    }

    /**
     * <p>
     * Creates a new link between gateways.
     * </p>
     * <p>
     * Establishes a connection that allows gateways to communicate and exchange bid requests and responses.
     * </p>
     *
     * @param createLinkRequest
     * @return A Java Future containing the result of the CreateLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request could not be completed because you exceeded a service
     *         quota.</li>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.CreateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/CreateLink" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLinkResponse> createLink(CreateLinkRequest createLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new link between gateways.
     * </p>
     * <p>
     * Establishes a connection that allows gateways to communicate and exchange bid requests and responses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLinkRequest.Builder} avoiding the need to
     * create one manually via {@link CreateLinkRequest#builder()}
     * </p>
     *
     * @param createLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.CreateLinkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request could not be completed because you exceeded a service
     *         quota.</li>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.CreateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/CreateLink" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLinkResponse> createLink(Consumer<CreateLinkRequest.Builder> createLinkRequest) {
        return createLink(CreateLinkRequest.builder().applyMutation(createLinkRequest).build());
    }

    /**
     * <p>
     * Creates an outbound external link.
     * </p>
     *
     * @param createOutboundExternalLinkRequest
     * @return A Java Future containing the result of the CreateOutboundExternalLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request could not be completed because you exceeded a service
     *         quota.</li>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.CreateOutboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/CreateOutboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOutboundExternalLinkResponse> createOutboundExternalLink(
            CreateOutboundExternalLinkRequest createOutboundExternalLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an outbound external link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOutboundExternalLinkRequest.Builder} avoiding
     * the need to create one manually via {@link CreateOutboundExternalLinkRequest#builder()}
     * </p>
     *
     * @param createOutboundExternalLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.CreateOutboundExternalLinkRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateOutboundExternalLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request could not be completed because you exceeded a service
     *         quota.</li>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.CreateOutboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/CreateOutboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOutboundExternalLinkResponse> createOutboundExternalLink(
            Consumer<CreateOutboundExternalLinkRequest.Builder> createOutboundExternalLinkRequest) {
        return createOutboundExternalLink(CreateOutboundExternalLinkRequest.builder()
                .applyMutation(createOutboundExternalLinkRequest).build());
    }

    /**
     * <p>
     * Creates a requester gateway.
     * </p>
     *
     * @param createRequesterGatewayRequest
     * @return A Java Future containing the result of the CreateRequesterGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request could not be completed because you exceeded a service
     *         quota.</li>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.CreateRequesterGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/CreateRequesterGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRequesterGatewayResponse> createRequesterGateway(
            CreateRequesterGatewayRequest createRequesterGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a requester gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRequesterGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRequesterGatewayRequest#builder()}
     * </p>
     *
     * @param createRequesterGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.CreateRequesterGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateRequesterGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request could not be completed because you exceeded a service
     *         quota.</li>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.CreateRequesterGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/CreateRequesterGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRequesterGatewayResponse> createRequesterGateway(
            Consumer<CreateRequesterGatewayRequest.Builder> createRequesterGatewayRequest) {
        return createRequesterGateway(CreateRequesterGatewayRequest.builder().applyMutation(createRequesterGatewayRequest)
                .build());
    }

    /**
     * <p>
     * Creates a responder gateway.
     * </p>
     * <important>
     * <p>
     * A domain name or managed endpoint is required.
     * </p>
     * </important>
     *
     * @param createResponderGatewayRequest
     * @return A Java Future containing the result of the CreateResponderGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request could not be completed because you exceeded a service
     *         quota.</li>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.CreateResponderGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/CreateResponderGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResponderGatewayResponse> createResponderGateway(
            CreateResponderGatewayRequest createResponderGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a responder gateway.
     * </p>
     * <important>
     * <p>
     * A domain name or managed endpoint is required.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResponderGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResponderGatewayRequest#builder()}
     * </p>
     *
     * @param createResponderGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.CreateResponderGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateResponderGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request could not be completed because you exceeded a service
     *         quota.</li>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.CreateResponderGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/CreateResponderGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResponderGatewayResponse> createResponderGateway(
            Consumer<CreateResponderGatewayRequest.Builder> createResponderGatewayRequest) {
        return createResponderGateway(CreateResponderGatewayRequest.builder().applyMutation(createResponderGatewayRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an inbound external link.
     * </p>
     *
     * @param deleteInboundExternalLinkRequest
     * @return A Java Future containing the result of the DeleteInboundExternalLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.DeleteInboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/DeleteInboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInboundExternalLinkResponse> deleteInboundExternalLink(
            DeleteInboundExternalLinkRequest deleteInboundExternalLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an inbound external link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInboundExternalLinkRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteInboundExternalLinkRequest#builder()}
     * </p>
     *
     * @param deleteInboundExternalLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.DeleteInboundExternalLinkRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteInboundExternalLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.DeleteInboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/DeleteInboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInboundExternalLinkResponse> deleteInboundExternalLink(
            Consumer<DeleteInboundExternalLinkRequest.Builder> deleteInboundExternalLinkRequest) {
        return deleteInboundExternalLink(DeleteInboundExternalLinkRequest.builder()
                .applyMutation(deleteInboundExternalLinkRequest).build());
    }

    /**
     * <p>
     * Deletes a link between gateways.
     * </p>
     * <p>
     * Permanently removes the connection between gateways. This action cannot be undone.
     * </p>
     *
     * @param deleteLinkRequest
     * @return A Java Future containing the result of the DeleteLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.DeleteLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/DeleteLink" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLinkResponse> deleteLink(DeleteLinkRequest deleteLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a link between gateways.
     * </p>
     * <p>
     * Permanently removes the connection between gateways. This action cannot be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLinkRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLinkRequest#builder()}
     * </p>
     *
     * @param deleteLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.DeleteLinkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.DeleteLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/DeleteLink" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLinkResponse> deleteLink(Consumer<DeleteLinkRequest.Builder> deleteLinkRequest) {
        return deleteLink(DeleteLinkRequest.builder().applyMutation(deleteLinkRequest).build());
    }

    /**
     * <p>
     * Deletes an outbound external link.
     * </p>
     *
     * @param deleteOutboundExternalLinkRequest
     * @return A Java Future containing the result of the DeleteOutboundExternalLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.DeleteOutboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/DeleteOutboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOutboundExternalLinkResponse> deleteOutboundExternalLink(
            DeleteOutboundExternalLinkRequest deleteOutboundExternalLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an outbound external link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOutboundExternalLinkRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteOutboundExternalLinkRequest#builder()}
     * </p>
     *
     * @param deleteOutboundExternalLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.DeleteOutboundExternalLinkRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteOutboundExternalLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.DeleteOutboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/DeleteOutboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOutboundExternalLinkResponse> deleteOutboundExternalLink(
            Consumer<DeleteOutboundExternalLinkRequest.Builder> deleteOutboundExternalLinkRequest) {
        return deleteOutboundExternalLink(DeleteOutboundExternalLinkRequest.builder()
                .applyMutation(deleteOutboundExternalLinkRequest).build());
    }

    /**
     * <p>
     * Deletes a requester gateway.
     * </p>
     *
     * @param deleteRequesterGatewayRequest
     * @return A Java Future containing the result of the DeleteRequesterGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.DeleteRequesterGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/DeleteRequesterGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRequesterGatewayResponse> deleteRequesterGateway(
            DeleteRequesterGatewayRequest deleteRequesterGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a requester gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRequesterGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRequesterGatewayRequest#builder()}
     * </p>
     *
     * @param deleteRequesterGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.DeleteRequesterGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRequesterGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.DeleteRequesterGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/DeleteRequesterGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRequesterGatewayResponse> deleteRequesterGateway(
            Consumer<DeleteRequesterGatewayRequest.Builder> deleteRequesterGatewayRequest) {
        return deleteRequesterGateway(DeleteRequesterGatewayRequest.builder().applyMutation(deleteRequesterGatewayRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a responder gateway.
     * </p>
     *
     * @param deleteResponderGatewayRequest
     * @return A Java Future containing the result of the DeleteResponderGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.DeleteResponderGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/DeleteResponderGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResponderGatewayResponse> deleteResponderGateway(
            DeleteResponderGatewayRequest deleteResponderGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a responder gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResponderGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResponderGatewayRequest#builder()}
     * </p>
     *
     * @param deleteResponderGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.DeleteResponderGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteResponderGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.DeleteResponderGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/DeleteResponderGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResponderGatewayResponse> deleteResponderGateway(
            Consumer<DeleteResponderGatewayRequest.Builder> deleteResponderGatewayRequest) {
        return deleteResponderGateway(DeleteResponderGatewayRequest.builder().applyMutation(deleteResponderGatewayRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about an inbound external link.
     * </p>
     *
     * @param getInboundExternalLinkRequest
     * @return A Java Future containing the result of the GetInboundExternalLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.GetInboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/GetInboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInboundExternalLinkResponse> getInboundExternalLink(
            GetInboundExternalLinkRequest getInboundExternalLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an inbound external link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInboundExternalLinkRequest.Builder} avoiding the
     * need to create one manually via {@link GetInboundExternalLinkRequest#builder()}
     * </p>
     *
     * @param getInboundExternalLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.GetInboundExternalLinkRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetInboundExternalLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.GetInboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/GetInboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInboundExternalLinkResponse> getInboundExternalLink(
            Consumer<GetInboundExternalLinkRequest.Builder> getInboundExternalLinkRequest) {
        return getInboundExternalLink(GetInboundExternalLinkRequest.builder().applyMutation(getInboundExternalLinkRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about a link between gateways.
     * </p>
     * <p>
     * Returns detailed information about the link configuration, status, and associated gateways.
     * </p>
     *
     * @param getLinkRequest
     * @return A Java Future containing the result of the GetLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.GetLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/GetLink" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLinkResponse> getLink(GetLinkRequest getLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a link between gateways.
     * </p>
     * <p>
     * Returns detailed information about the link configuration, status, and associated gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLinkRequest.Builder} avoiding the need to create
     * one manually via {@link GetLinkRequest#builder()}
     * </p>
     *
     * @param getLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.GetLinkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.GetLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/GetLink" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLinkResponse> getLink(Consumer<GetLinkRequest.Builder> getLinkRequest) {
        return getLink(GetLinkRequest.builder().applyMutation(getLinkRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an outbound external link.
     * </p>
     *
     * @param getOutboundExternalLinkRequest
     * @return A Java Future containing the result of the GetOutboundExternalLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.GetOutboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/GetOutboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOutboundExternalLinkResponse> getOutboundExternalLink(
            GetOutboundExternalLinkRequest getOutboundExternalLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an outbound external link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOutboundExternalLinkRequest.Builder} avoiding
     * the need to create one manually via {@link GetOutboundExternalLinkRequest#builder()}
     * </p>
     *
     * @param getOutboundExternalLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.GetOutboundExternalLinkRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetOutboundExternalLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.GetOutboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/GetOutboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOutboundExternalLinkResponse> getOutboundExternalLink(
            Consumer<GetOutboundExternalLinkRequest.Builder> getOutboundExternalLinkRequest) {
        return getOutboundExternalLink(GetOutboundExternalLinkRequest.builder().applyMutation(getOutboundExternalLinkRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about a requester gateway.
     * </p>
     *
     * @param getRequesterGatewayRequest
     * @return A Java Future containing the result of the GetRequesterGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.GetRequesterGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/GetRequesterGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetRequesterGatewayResponse> getRequesterGateway(
            GetRequesterGatewayRequest getRequesterGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a requester gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRequesterGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link GetRequesterGatewayRequest#builder()}
     * </p>
     *
     * @param getRequesterGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.GetRequesterGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRequesterGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.GetRequesterGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/GetRequesterGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetRequesterGatewayResponse> getRequesterGateway(
            Consumer<GetRequesterGatewayRequest.Builder> getRequesterGatewayRequest) {
        return getRequesterGateway(GetRequesterGatewayRequest.builder().applyMutation(getRequesterGatewayRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a responder gateway.
     * </p>
     *
     * @param getResponderGatewayRequest
     * @return A Java Future containing the result of the GetResponderGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.GetResponderGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/GetResponderGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetResponderGatewayResponse> getResponderGateway(
            GetResponderGatewayRequest getResponderGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a responder gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResponderGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link GetResponderGatewayRequest#builder()}
     * </p>
     *
     * @param getResponderGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.GetResponderGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetResponderGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.GetResponderGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/GetResponderGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetResponderGatewayResponse> getResponderGateway(
            Consumer<GetResponderGatewayRequest.Builder> getResponderGatewayRequest) {
        return getResponderGateway(GetResponderGatewayRequest.builder().applyMutation(getResponderGatewayRequest).build());
    }

    /**
     * <p>
     * Lists links associated with gateways.
     * </p>
     * <p>
     * Returns a list of all links for the specified gateways, including their status and configuration details.
     * </p>
     *
     * @param listLinksRequest
     * @return A Java Future containing the result of the ListLinks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.ListLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListLinks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLinksResponse> listLinks(ListLinksRequest listLinksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists links associated with gateways.
     * </p>
     * <p>
     * Returns a list of all links for the specified gateways, including their status and configuration details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLinksRequest.Builder} avoiding the need to
     * create one manually via {@link ListLinksRequest#builder()}
     * </p>
     *
     * @param listLinksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.ListLinksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListLinks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.ListLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListLinks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLinksResponse> listLinks(Consumer<ListLinksRequest.Builder> listLinksRequest) {
        return listLinks(ListLinksRequest.builder().applyMutation(listLinksRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listLinks(software.amazon.awssdk.services.rtbfabric.model.ListLinksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListLinksPublisher publisher = client.listLinksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListLinksPublisher publisher = client.listLinksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rtbfabric.model.ListLinksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rtbfabric.model.ListLinksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLinks(software.amazon.awssdk.services.rtbfabric.model.ListLinksRequest)} operation.</b>
     * </p>
     *
     * @param listLinksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.ListLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListLinks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLinksPublisher listLinksPaginator(ListLinksRequest listLinksRequest) {
        return new ListLinksPublisher(this, listLinksRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listLinks(software.amazon.awssdk.services.rtbfabric.model.ListLinksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListLinksPublisher publisher = client.listLinksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListLinksPublisher publisher = client.listLinksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rtbfabric.model.ListLinksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rtbfabric.model.ListLinksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLinks(software.amazon.awssdk.services.rtbfabric.model.ListLinksRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLinksRequest.Builder} avoiding the need to
     * create one manually via {@link ListLinksRequest#builder()}
     * </p>
     *
     * @param listLinksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.ListLinksRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.ListLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListLinks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLinksPublisher listLinksPaginator(Consumer<ListLinksRequest.Builder> listLinksRequest) {
        return listLinksPaginator(ListLinksRequest.builder().applyMutation(listLinksRequest).build());
    }

    /**
     * <p>
     * Lists requester gateways.
     * </p>
     *
     * @param listRequesterGatewaysRequest
     * @return A Java Future containing the result of the ListRequesterGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.ListRequesterGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListRequesterGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRequesterGatewaysResponse> listRequesterGateways(
            ListRequesterGatewaysRequest listRequesterGatewaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists requester gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRequesterGatewaysRequest.Builder} avoiding the
     * need to create one manually via {@link ListRequesterGatewaysRequest#builder()}
     * </p>
     *
     * @param listRequesterGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListRequesterGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.ListRequesterGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListRequesterGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRequesterGatewaysResponse> listRequesterGateways(
            Consumer<ListRequesterGatewaysRequest.Builder> listRequesterGatewaysRequest) {
        return listRequesterGateways(ListRequesterGatewaysRequest.builder().applyMutation(listRequesterGatewaysRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRequesterGateways(software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListRequesterGatewaysPublisher publisher = client.listRequesterGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListRequesterGatewaysPublisher publisher = client.listRequesterGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRequesterGateways(software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRequesterGatewaysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.ListRequesterGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListRequesterGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRequesterGatewaysPublisher listRequesterGatewaysPaginator(
            ListRequesterGatewaysRequest listRequesterGatewaysRequest) {
        return new ListRequesterGatewaysPublisher(this, listRequesterGatewaysRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRequesterGateways(software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListRequesterGatewaysPublisher publisher = client.listRequesterGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListRequesterGatewaysPublisher publisher = client.listRequesterGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRequesterGateways(software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRequesterGatewaysRequest.Builder} avoiding the
     * need to create one manually via {@link ListRequesterGatewaysRequest#builder()}
     * </p>
     *
     * @param listRequesterGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.ListRequesterGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListRequesterGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRequesterGatewaysPublisher listRequesterGatewaysPaginator(
            Consumer<ListRequesterGatewaysRequest.Builder> listRequesterGatewaysRequest) {
        return listRequesterGatewaysPaginator(ListRequesterGatewaysRequest.builder().applyMutation(listRequesterGatewaysRequest)
                .build());
    }

    /**
     * <p>
     * Lists reponder gateways.
     * </p>
     *
     * @param listResponderGatewaysRequest
     * @return A Java Future containing the result of the ListResponderGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.ListResponderGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListResponderGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResponderGatewaysResponse> listResponderGateways(
            ListResponderGatewaysRequest listResponderGatewaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists reponder gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResponderGatewaysRequest.Builder} avoiding the
     * need to create one manually via {@link ListResponderGatewaysRequest#builder()}
     * </p>
     *
     * @param listResponderGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListResponderGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.ListResponderGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListResponderGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResponderGatewaysResponse> listResponderGateways(
            Consumer<ListResponderGatewaysRequest.Builder> listResponderGatewaysRequest) {
        return listResponderGateways(ListResponderGatewaysRequest.builder().applyMutation(listResponderGatewaysRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResponderGateways(software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListResponderGatewaysPublisher publisher = client.listResponderGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListResponderGatewaysPublisher publisher = client.listResponderGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResponderGateways(software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResponderGatewaysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.ListResponderGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListResponderGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResponderGatewaysPublisher listResponderGatewaysPaginator(
            ListResponderGatewaysRequest listResponderGatewaysRequest) {
        return new ListResponderGatewaysPublisher(this, listResponderGatewaysRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResponderGateways(software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListResponderGatewaysPublisher publisher = client.listResponderGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListResponderGatewaysPublisher publisher = client.listResponderGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResponderGateways(software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResponderGatewaysRequest.Builder} avoiding the
     * need to create one manually via {@link ListResponderGatewaysRequest#builder()}
     * </p>
     *
     * @param listResponderGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.ListResponderGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListResponderGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResponderGatewaysPublisher listResponderGatewaysPaginator(
            Consumer<ListResponderGatewaysRequest.Builder> listResponderGatewaysRequest) {
        return listResponderGatewaysPaginator(ListResponderGatewaysRequest.builder().applyMutation(listResponderGatewaysRequest)
                .build());
    }

    /**
     * <p>
     * Lists tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Rejects a link request between gateways.
     * </p>
     * <p>
     * When a requester gateway requests to link with a responder gateway, the responder can use this operation to
     * decline the link request.
     * </p>
     *
     * @param rejectLinkRequest
     * @return A Java Future containing the result of the RejectLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.RejectLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/RejectLink" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RejectLinkResponse> rejectLink(RejectLinkRequest rejectLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects a link request between gateways.
     * </p>
     * <p>
     * When a requester gateway requests to link with a responder gateway, the responder can use this operation to
     * decline the link request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectLinkRequest.Builder} avoiding the need to
     * create one manually via {@link RejectLinkRequest#builder()}
     * </p>
     *
     * @param rejectLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.RejectLinkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RejectLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.RejectLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/RejectLink" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RejectLinkResponse> rejectLink(Consumer<RejectLinkRequest.Builder> rejectLinkRequest) {
        return rejectLink(RejectLinkRequest.builder().applyMutation(rejectLinkRequest).build());
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag or tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag or tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of a link between gateways.
     * </p>
     * <p>
     * Allows you to modify settings and parameters for an existing link.
     * </p>
     *
     * @param updateLinkRequest
     * @return A Java Future containing the result of the UpdateLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.UpdateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/UpdateLink" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateLinkResponse> updateLink(UpdateLinkRequest updateLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of a link between gateways.
     * </p>
     * <p>
     * Allows you to modify settings and parameters for an existing link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLinkRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateLinkRequest#builder()}
     * </p>
     *
     * @param updateLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.UpdateLinkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.UpdateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/UpdateLink" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateLinkResponse> updateLink(Consumer<UpdateLinkRequest.Builder> updateLinkRequest) {
        return updateLink(UpdateLinkRequest.builder().applyMutation(updateLinkRequest).build());
    }

    /**
     * <p>
     * Updates a link module flow.
     * </p>
     *
     * @param updateLinkModuleFlowRequest
     * @return A Java Future containing the result of the UpdateLinkModuleFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request could not be completed because you exceeded a service
     *         quota.</li>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.UpdateLinkModuleFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/UpdateLinkModuleFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLinkModuleFlowResponse> updateLinkModuleFlow(
            UpdateLinkModuleFlowRequest updateLinkModuleFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a link module flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLinkModuleFlowRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateLinkModuleFlowRequest#builder()}
     * </p>
     *
     * @param updateLinkModuleFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.UpdateLinkModuleFlowRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateLinkModuleFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request could not be completed because you exceeded a service
     *         quota.</li>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.UpdateLinkModuleFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/UpdateLinkModuleFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLinkModuleFlowResponse> updateLinkModuleFlow(
            Consumer<UpdateLinkModuleFlowRequest.Builder> updateLinkModuleFlowRequest) {
        return updateLinkModuleFlow(UpdateLinkModuleFlowRequest.builder().applyMutation(updateLinkModuleFlowRequest).build());
    }

    /**
     * <p>
     * Updates a requester gateway.
     * </p>
     *
     * @param updateRequesterGatewayRequest
     * @return A Java Future containing the result of the UpdateRequesterGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.UpdateRequesterGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/UpdateRequesterGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRequesterGatewayResponse> updateRequesterGateway(
            UpdateRequesterGatewayRequest updateRequesterGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a requester gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRequesterGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRequesterGatewayRequest#builder()}
     * </p>
     *
     * @param updateRequesterGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.UpdateRequesterGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateRequesterGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.UpdateRequesterGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/UpdateRequesterGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRequesterGatewayResponse> updateRequesterGateway(
            Consumer<UpdateRequesterGatewayRequest.Builder> updateRequesterGatewayRequest) {
        return updateRequesterGateway(UpdateRequesterGatewayRequest.builder().applyMutation(updateRequesterGatewayRequest)
                .build());
    }

    /**
     * <p>
     * Updates a responder gateway.
     * </p>
     *
     * @param updateResponderGatewayRequest
     * @return A Java Future containing the result of the UpdateResponderGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.UpdateResponderGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/UpdateResponderGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResponderGatewayResponse> updateResponderGateway(
            UpdateResponderGatewayRequest updateResponderGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a responder gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResponderGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResponderGatewayRequest#builder()}
     * </p>
     *
     * @param updateResponderGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.UpdateResponderGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateResponderGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The request could not be completed because the resource does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException The request could not be completed because you do not have sufficient access to
     *         perform this action.</li>
     *         <li>ConflictException The request could not be completed because of a conflict in the current state of
     *         the resource.</li>
     *         <li>InternalServerException The request could not be completed because of an internal server error. Try
     *         your call again.</li>
     *         <li>ValidationException The request could not be completed because it fails satisfy the constraints
     *         specified by the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RtbFabricException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RtbFabricAsyncClient.UpdateResponderGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/UpdateResponderGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResponderGatewayResponse> updateResponderGateway(
            Consumer<UpdateResponderGatewayRequest.Builder> updateResponderGatewayRequest) {
        return updateResponderGateway(UpdateResponderGatewayRequest.builder().applyMutation(updateResponderGatewayRequest)
                .build());
    }

    /**
     * Create an instance of {@link RtbFabricAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link RtbFabricAsyncWaiter}
     */
    default RtbFabricAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default RtbFabricServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link RtbFabricAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static RtbFabricAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link RtbFabricAsyncClient}.
     */
    static RtbFabricAsyncClientBuilder builder() {
        return new DefaultRtbFabricAsyncClientBuilder();
    }
}
