/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.rtbfabric.model.AcceptLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.AcceptLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.AccessDeniedException;
import software.amazon.awssdk.services.rtbfabric.model.ConflictException;
import software.amazon.awssdk.services.rtbfabric.model.CreateInboundExternalLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.CreateInboundExternalLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.CreateLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.CreateLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.CreateOutboundExternalLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.CreateOutboundExternalLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.CreateRequesterGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.CreateRequesterGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.model.CreateResponderGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.CreateResponderGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.model.DeleteInboundExternalLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.DeleteInboundExternalLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.DeleteLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.DeleteLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.DeleteOutboundExternalLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.DeleteOutboundExternalLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.DeleteRequesterGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.DeleteRequesterGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.model.DeleteResponderGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.DeleteResponderGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetInboundExternalLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetInboundExternalLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetOutboundExternalLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetOutboundExternalLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetRequesterGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetRequesterGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetResponderGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetResponderGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.model.InternalServerException;
import software.amazon.awssdk.services.rtbfabric.model.ListLinksRequest;
import software.amazon.awssdk.services.rtbfabric.model.ListLinksResponse;
import software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysRequest;
import software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysResponse;
import software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysRequest;
import software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysResponse;
import software.amazon.awssdk.services.rtbfabric.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.rtbfabric.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.rtbfabric.model.RejectLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.RejectLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.ResourceNotFoundException;
import software.amazon.awssdk.services.rtbfabric.model.RtbFabricException;
import software.amazon.awssdk.services.rtbfabric.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.rtbfabric.model.TagResourceRequest;
import software.amazon.awssdk.services.rtbfabric.model.TagResourceResponse;
import software.amazon.awssdk.services.rtbfabric.model.ThrottlingException;
import software.amazon.awssdk.services.rtbfabric.model.UntagResourceRequest;
import software.amazon.awssdk.services.rtbfabric.model.UntagResourceResponse;
import software.amazon.awssdk.services.rtbfabric.model.UpdateLinkModuleFlowRequest;
import software.amazon.awssdk.services.rtbfabric.model.UpdateLinkModuleFlowResponse;
import software.amazon.awssdk.services.rtbfabric.model.UpdateLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.UpdateLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.UpdateRequesterGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.UpdateRequesterGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.model.UpdateResponderGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.UpdateResponderGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.model.ValidationException;
import software.amazon.awssdk.services.rtbfabric.paginators.ListLinksIterable;
import software.amazon.awssdk.services.rtbfabric.paginators.ListRequesterGatewaysIterable;
import software.amazon.awssdk.services.rtbfabric.paginators.ListResponderGatewaysIterable;
import software.amazon.awssdk.services.rtbfabric.waiters.RtbFabricWaiter;

/**
 * Service client for accessing RTBFabric. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Web Services RTB Fabric provides secure, low-latency infrastructure for connecting real-time bidding (RTB)
 * applications. Rather than hosting applications directly, RTB Fabric acts as the connecting fabric that enables your
 * applications to communicate efficiently over private networks instead of the public internet. You maintain complete
 * control over your applications, data, and bidding decisions, while RTB Fabric provides the underlying infrastructure
 * for secure, reliable connectivity.
 * </p>
 * <p>
 * You can use these APIs to complete RTB Fabric tasks, such as setting up audit log ingestions or viewing user access.
 * For more information about RTB Fabric, including the required permissions to use the service, see the <a
 * href="https://docs.aws.amazon.com/rtb-fabric/latest/userguide/">Amazon Web Services RTB Fabric User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface RtbFabricClient extends AwsClient {
    String SERVICE_NAME = "rtbfabric";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "rtbfabric";

    /**
     * <p>
     * Accepts a link request between gateways.
     * </p>
     * <p>
     * When a requester gateway requests to link with a responder gateway, the responder can use this operation to
     * accept the link request and establish the connection.
     * </p>
     *
     * @param acceptLinkRequest
     * @return Result of the AcceptLink operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.AcceptLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/AcceptLink" target="_top">AWS API
     *      Documentation</a>
     */
    default AcceptLinkResponse acceptLink(AcceptLinkRequest acceptLinkRequest) throws ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, ConflictException, InternalServerException, ValidationException,
            AwsServiceException, SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a link request between gateways.
     * </p>
     * <p>
     * When a requester gateway requests to link with a responder gateway, the responder can use this operation to
     * accept the link request and establish the connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptLinkRequest.Builder} avoiding the need to
     * create one manually via {@link AcceptLinkRequest#builder()}
     * </p>
     *
     * @param acceptLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.AcceptLinkRequest.Builder} to create a request.
     * @return Result of the AcceptLink operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.AcceptLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/AcceptLink" target="_top">AWS API
     *      Documentation</a>
     */
    default AcceptLinkResponse acceptLink(Consumer<AcceptLinkRequest.Builder> acceptLinkRequest)
            throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        return acceptLink(AcceptLinkRequest.builder().applyMutation(acceptLinkRequest).build());
    }

    /**
     * <p>
     * Creates an inbound external link.
     * </p>
     *
     * @param createInboundExternalLinkRequest
     * @return Result of the CreateInboundExternalLink operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because you exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.CreateInboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/CreateInboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInboundExternalLinkResponse createInboundExternalLink(
            CreateInboundExternalLinkRequest createInboundExternalLinkRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException, InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an inbound external link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInboundExternalLinkRequest.Builder} avoiding
     * the need to create one manually via {@link CreateInboundExternalLinkRequest#builder()}
     * </p>
     *
     * @param createInboundExternalLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.CreateInboundExternalLinkRequest.Builder} to create
     *        a request.
     * @return Result of the CreateInboundExternalLink operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because you exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.CreateInboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/CreateInboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInboundExternalLinkResponse createInboundExternalLink(
            Consumer<CreateInboundExternalLinkRequest.Builder> createInboundExternalLinkRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ConflictException, InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            RtbFabricException {
        return createInboundExternalLink(CreateInboundExternalLinkRequest.builder()
                .applyMutation(createInboundExternalLinkRequest).build());
    }

    /**
     * <p>
     * Creates a new link between gateways.
     * </p>
     * <p>
     * Establishes a connection that allows gateways to communicate and exchange bid requests and responses.
     * </p>
     *
     * @param createLinkRequest
     * @return Result of the CreateLink operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because you exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.CreateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/CreateLink" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLinkResponse createLink(CreateLinkRequest createLinkRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException, InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new link between gateways.
     * </p>
     * <p>
     * Establishes a connection that allows gateways to communicate and exchange bid requests and responses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLinkRequest.Builder} avoiding the need to
     * create one manually via {@link CreateLinkRequest#builder()}
     * </p>
     *
     * @param createLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.CreateLinkRequest.Builder} to create a request.
     * @return Result of the CreateLink operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because you exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.CreateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/CreateLink" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLinkResponse createLink(Consumer<CreateLinkRequest.Builder> createLinkRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ConflictException, InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            RtbFabricException {
        return createLink(CreateLinkRequest.builder().applyMutation(createLinkRequest).build());
    }

    /**
     * <p>
     * Creates an outbound external link.
     * </p>
     *
     * @param createOutboundExternalLinkRequest
     * @return Result of the CreateOutboundExternalLink operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because you exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.CreateOutboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/CreateOutboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOutboundExternalLinkResponse createOutboundExternalLink(
            CreateOutboundExternalLinkRequest createOutboundExternalLinkRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            AwsServiceException, SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an outbound external link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOutboundExternalLinkRequest.Builder} avoiding
     * the need to create one manually via {@link CreateOutboundExternalLinkRequest#builder()}
     * </p>
     *
     * @param createOutboundExternalLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.CreateOutboundExternalLinkRequest.Builder} to
     *        create a request.
     * @return Result of the CreateOutboundExternalLink operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because you exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.CreateOutboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/CreateOutboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOutboundExternalLinkResponse createOutboundExternalLink(
            Consumer<CreateOutboundExternalLinkRequest.Builder> createOutboundExternalLinkRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        return createOutboundExternalLink(CreateOutboundExternalLinkRequest.builder()
                .applyMutation(createOutboundExternalLinkRequest).build());
    }

    /**
     * <p>
     * Creates a requester gateway.
     * </p>
     *
     * @param createRequesterGatewayRequest
     * @return Result of the CreateRequesterGateway operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because you exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.CreateRequesterGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/CreateRequesterGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRequesterGatewayResponse createRequesterGateway(CreateRequesterGatewayRequest createRequesterGatewayRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a requester gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRequesterGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRequesterGatewayRequest#builder()}
     * </p>
     *
     * @param createRequesterGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.CreateRequesterGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the CreateRequesterGateway operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because you exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.CreateRequesterGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/CreateRequesterGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRequesterGatewayResponse createRequesterGateway(
            Consumer<CreateRequesterGatewayRequest.Builder> createRequesterGatewayRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            AwsServiceException, SdkClientException, RtbFabricException {
        return createRequesterGateway(CreateRequesterGatewayRequest.builder().applyMutation(createRequesterGatewayRequest)
                .build());
    }

    /**
     * <p>
     * Creates a responder gateway.
     * </p>
     * <important>
     * <p>
     * A domain name or managed endpoint is required.
     * </p>
     * </important>
     *
     * @param createResponderGatewayRequest
     * @return Result of the CreateResponderGateway operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because you exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.CreateResponderGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/CreateResponderGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResponderGatewayResponse createResponderGateway(CreateResponderGatewayRequest createResponderGatewayRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a responder gateway.
     * </p>
     * <important>
     * <p>
     * A domain name or managed endpoint is required.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResponderGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResponderGatewayRequest#builder()}
     * </p>
     *
     * @param createResponderGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.CreateResponderGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the CreateResponderGateway operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because you exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.CreateResponderGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/CreateResponderGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResponderGatewayResponse createResponderGateway(
            Consumer<CreateResponderGatewayRequest.Builder> createResponderGatewayRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            AwsServiceException, SdkClientException, RtbFabricException {
        return createResponderGateway(CreateResponderGatewayRequest.builder().applyMutation(createResponderGatewayRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an inbound external link.
     * </p>
     *
     * @param deleteInboundExternalLinkRequest
     * @return Result of the DeleteInboundExternalLink operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.DeleteInboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/DeleteInboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInboundExternalLinkResponse deleteInboundExternalLink(
            DeleteInboundExternalLinkRequest deleteInboundExternalLinkRequest) throws ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, ConflictException, InternalServerException, ValidationException,
            AwsServiceException, SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an inbound external link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInboundExternalLinkRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteInboundExternalLinkRequest#builder()}
     * </p>
     *
     * @param deleteInboundExternalLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.DeleteInboundExternalLinkRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteInboundExternalLink operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.DeleteInboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/DeleteInboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInboundExternalLinkResponse deleteInboundExternalLink(
            Consumer<DeleteInboundExternalLinkRequest.Builder> deleteInboundExternalLinkRequest)
            throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        return deleteInboundExternalLink(DeleteInboundExternalLinkRequest.builder()
                .applyMutation(deleteInboundExternalLinkRequest).build());
    }

    /**
     * <p>
     * Deletes a link between gateways.
     * </p>
     * <p>
     * Permanently removes the connection between gateways. This action cannot be undone.
     * </p>
     *
     * @param deleteLinkRequest
     * @return Result of the DeleteLink operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.DeleteLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/DeleteLink" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLinkResponse deleteLink(DeleteLinkRequest deleteLinkRequest) throws ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, ConflictException, InternalServerException, ValidationException,
            AwsServiceException, SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a link between gateways.
     * </p>
     * <p>
     * Permanently removes the connection between gateways. This action cannot be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLinkRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLinkRequest#builder()}
     * </p>
     *
     * @param deleteLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.DeleteLinkRequest.Builder} to create a request.
     * @return Result of the DeleteLink operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.DeleteLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/DeleteLink" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLinkResponse deleteLink(Consumer<DeleteLinkRequest.Builder> deleteLinkRequest)
            throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        return deleteLink(DeleteLinkRequest.builder().applyMutation(deleteLinkRequest).build());
    }

    /**
     * <p>
     * Deletes an outbound external link.
     * </p>
     *
     * @param deleteOutboundExternalLinkRequest
     * @return Result of the DeleteOutboundExternalLink operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.DeleteOutboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/DeleteOutboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOutboundExternalLinkResponse deleteOutboundExternalLink(
            DeleteOutboundExternalLinkRequest deleteOutboundExternalLinkRequest) throws ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, ConflictException, InternalServerException, ValidationException,
            AwsServiceException, SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an outbound external link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOutboundExternalLinkRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteOutboundExternalLinkRequest#builder()}
     * </p>
     *
     * @param deleteOutboundExternalLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.DeleteOutboundExternalLinkRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteOutboundExternalLink operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.DeleteOutboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/DeleteOutboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOutboundExternalLinkResponse deleteOutboundExternalLink(
            Consumer<DeleteOutboundExternalLinkRequest.Builder> deleteOutboundExternalLinkRequest)
            throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        return deleteOutboundExternalLink(DeleteOutboundExternalLinkRequest.builder()
                .applyMutation(deleteOutboundExternalLinkRequest).build());
    }

    /**
     * <p>
     * Deletes a requester gateway.
     * </p>
     *
     * @param deleteRequesterGatewayRequest
     * @return Result of the DeleteRequesterGateway operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.DeleteRequesterGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/DeleteRequesterGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRequesterGatewayResponse deleteRequesterGateway(DeleteRequesterGatewayRequest deleteRequesterGatewayRequest)
            throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a requester gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRequesterGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRequesterGatewayRequest#builder()}
     * </p>
     *
     * @param deleteRequesterGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.DeleteRequesterGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRequesterGateway operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.DeleteRequesterGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/DeleteRequesterGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRequesterGatewayResponse deleteRequesterGateway(
            Consumer<DeleteRequesterGatewayRequest.Builder> deleteRequesterGatewayRequest) throws ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, RtbFabricException {
        return deleteRequesterGateway(DeleteRequesterGatewayRequest.builder().applyMutation(deleteRequesterGatewayRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a responder gateway.
     * </p>
     *
     * @param deleteResponderGatewayRequest
     * @return Result of the DeleteResponderGateway operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.DeleteResponderGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/DeleteResponderGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResponderGatewayResponse deleteResponderGateway(DeleteResponderGatewayRequest deleteResponderGatewayRequest)
            throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a responder gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResponderGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResponderGatewayRequest#builder()}
     * </p>
     *
     * @param deleteResponderGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.DeleteResponderGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResponderGateway operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.DeleteResponderGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/DeleteResponderGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResponderGatewayResponse deleteResponderGateway(
            Consumer<DeleteResponderGatewayRequest.Builder> deleteResponderGatewayRequest) throws ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, RtbFabricException {
        return deleteResponderGateway(DeleteResponderGatewayRequest.builder().applyMutation(deleteResponderGatewayRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about an inbound external link.
     * </p>
     *
     * @param getInboundExternalLinkRequest
     * @return Result of the GetInboundExternalLink operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.GetInboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/GetInboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInboundExternalLinkResponse getInboundExternalLink(GetInboundExternalLinkRequest getInboundExternalLinkRequest)
            throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an inbound external link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInboundExternalLinkRequest.Builder} avoiding the
     * need to create one manually via {@link GetInboundExternalLinkRequest#builder()}
     * </p>
     *
     * @param getInboundExternalLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.GetInboundExternalLinkRequest.Builder} to create a
     *        request.
     * @return Result of the GetInboundExternalLink operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.GetInboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/GetInboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInboundExternalLinkResponse getInboundExternalLink(
            Consumer<GetInboundExternalLinkRequest.Builder> getInboundExternalLinkRequest) throws ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, RtbFabricException {
        return getInboundExternalLink(GetInboundExternalLinkRequest.builder().applyMutation(getInboundExternalLinkRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about a link between gateways.
     * </p>
     * <p>
     * Returns detailed information about the link configuration, status, and associated gateways.
     * </p>
     *
     * @param getLinkRequest
     * @return Result of the GetLink operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.GetLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/GetLink" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLinkResponse getLink(GetLinkRequest getLinkRequest) throws ResourceNotFoundException, ThrottlingException,
            AccessDeniedException, ConflictException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a link between gateways.
     * </p>
     * <p>
     * Returns detailed information about the link configuration, status, and associated gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLinkRequest.Builder} avoiding the need to create
     * one manually via {@link GetLinkRequest#builder()}
     * </p>
     *
     * @param getLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.GetLinkRequest.Builder} to create a request.
     * @return Result of the GetLink operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.GetLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/GetLink" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLinkResponse getLink(Consumer<GetLinkRequest.Builder> getLinkRequest) throws ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, ConflictException, InternalServerException, ValidationException,
            AwsServiceException, SdkClientException, RtbFabricException {
        return getLink(GetLinkRequest.builder().applyMutation(getLinkRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an outbound external link.
     * </p>
     *
     * @param getOutboundExternalLinkRequest
     * @return Result of the GetOutboundExternalLink operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.GetOutboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/GetOutboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOutboundExternalLinkResponse getOutboundExternalLink(GetOutboundExternalLinkRequest getOutboundExternalLinkRequest)
            throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an outbound external link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOutboundExternalLinkRequest.Builder} avoiding
     * the need to create one manually via {@link GetOutboundExternalLinkRequest#builder()}
     * </p>
     *
     * @param getOutboundExternalLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.GetOutboundExternalLinkRequest.Builder} to create a
     *        request.
     * @return Result of the GetOutboundExternalLink operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.GetOutboundExternalLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/GetOutboundExternalLink"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOutboundExternalLinkResponse getOutboundExternalLink(
            Consumer<GetOutboundExternalLinkRequest.Builder> getOutboundExternalLinkRequest) throws ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, RtbFabricException {
        return getOutboundExternalLink(GetOutboundExternalLinkRequest.builder().applyMutation(getOutboundExternalLinkRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about a requester gateway.
     * </p>
     *
     * @param getRequesterGatewayRequest
     * @return Result of the GetRequesterGateway operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.GetRequesterGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/GetRequesterGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default GetRequesterGatewayResponse getRequesterGateway(GetRequesterGatewayRequest getRequesterGatewayRequest)
            throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a requester gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRequesterGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link GetRequesterGatewayRequest#builder()}
     * </p>
     *
     * @param getRequesterGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.GetRequesterGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the GetRequesterGateway operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.GetRequesterGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/GetRequesterGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default GetRequesterGatewayResponse getRequesterGateway(
            Consumer<GetRequesterGatewayRequest.Builder> getRequesterGatewayRequest) throws ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, RtbFabricException {
        return getRequesterGateway(GetRequesterGatewayRequest.builder().applyMutation(getRequesterGatewayRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a responder gateway.
     * </p>
     *
     * @param getResponderGatewayRequest
     * @return Result of the GetResponderGateway operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.GetResponderGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/GetResponderGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default GetResponderGatewayResponse getResponderGateway(GetResponderGatewayRequest getResponderGatewayRequest)
            throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a responder gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResponderGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link GetResponderGatewayRequest#builder()}
     * </p>
     *
     * @param getResponderGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.GetResponderGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the GetResponderGateway operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.GetResponderGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/GetResponderGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default GetResponderGatewayResponse getResponderGateway(
            Consumer<GetResponderGatewayRequest.Builder> getResponderGatewayRequest) throws ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, RtbFabricException {
        return getResponderGateway(GetResponderGatewayRequest.builder().applyMutation(getResponderGatewayRequest).build());
    }

    /**
     * <p>
     * Lists links associated with gateways.
     * </p>
     * <p>
     * Returns a list of all links for the specified gateways, including their status and configuration details.
     * </p>
     *
     * @param listLinksRequest
     * @return Result of the ListLinks operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.ListLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListLinks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLinksResponse listLinks(ListLinksRequest listLinksRequest) throws ResourceNotFoundException, ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists links associated with gateways.
     * </p>
     * <p>
     * Returns a list of all links for the specified gateways, including their status and configuration details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLinksRequest.Builder} avoiding the need to
     * create one manually via {@link ListLinksRequest#builder()}
     * </p>
     *
     * @param listLinksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.ListLinksRequest.Builder} to create a request.
     * @return Result of the ListLinks operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.ListLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListLinks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLinksResponse listLinks(Consumer<ListLinksRequest.Builder> listLinksRequest) throws ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, RtbFabricException {
        return listLinks(ListLinksRequest.builder().applyMutation(listLinksRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listLinks(software.amazon.awssdk.services.rtbfabric.model.ListLinksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListLinksIterable responses = client.listLinksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rtbfabric.paginators.ListLinksIterable responses = client.listLinksPaginator(request);
     *     for (software.amazon.awssdk.services.rtbfabric.model.ListLinksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListLinksIterable responses = client.listLinksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLinks(software.amazon.awssdk.services.rtbfabric.model.ListLinksRequest)} operation.</b>
     * </p>
     *
     * @param listLinksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.ListLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListLinks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLinksIterable listLinksPaginator(ListLinksRequest listLinksRequest) throws ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, RtbFabricException {
        return new ListLinksIterable(this, listLinksRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listLinks(software.amazon.awssdk.services.rtbfabric.model.ListLinksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListLinksIterable responses = client.listLinksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rtbfabric.paginators.ListLinksIterable responses = client.listLinksPaginator(request);
     *     for (software.amazon.awssdk.services.rtbfabric.model.ListLinksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListLinksIterable responses = client.listLinksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLinks(software.amazon.awssdk.services.rtbfabric.model.ListLinksRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLinksRequest.Builder} avoiding the need to
     * create one manually via {@link ListLinksRequest#builder()}
     * </p>
     *
     * @param listLinksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.ListLinksRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.ListLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListLinks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLinksIterable listLinksPaginator(Consumer<ListLinksRequest.Builder> listLinksRequest)
            throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        return listLinksPaginator(ListLinksRequest.builder().applyMutation(listLinksRequest).build());
    }

    /**
     * <p>
     * Lists requester gateways.
     * </p>
     *
     * @param listRequesterGatewaysRequest
     * @return Result of the ListRequesterGateways operation returned by the service.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.ListRequesterGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListRequesterGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRequesterGatewaysResponse listRequesterGateways(ListRequesterGatewaysRequest listRequesterGatewaysRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists requester gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRequesterGatewaysRequest.Builder} avoiding the
     * need to create one manually via {@link ListRequesterGatewaysRequest#builder()}
     * </p>
     *
     * @param listRequesterGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysRequest.Builder} to create a
     *        request.
     * @return Result of the ListRequesterGateways operation returned by the service.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.ListRequesterGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListRequesterGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRequesterGatewaysResponse listRequesterGateways(
            Consumer<ListRequesterGatewaysRequest.Builder> listRequesterGatewaysRequest) throws InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        return listRequesterGateways(ListRequesterGatewaysRequest.builder().applyMutation(listRequesterGatewaysRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRequesterGateways(software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListRequesterGatewaysIterable responses = client.listRequesterGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rtbfabric.paginators.ListRequesterGatewaysIterable responses = client
     *             .listRequesterGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListRequesterGatewaysIterable responses = client.listRequesterGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRequesterGateways(software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRequesterGatewaysRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.ListRequesterGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListRequesterGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRequesterGatewaysIterable listRequesterGatewaysPaginator(ListRequesterGatewaysRequest listRequesterGatewaysRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        return new ListRequesterGatewaysIterable(this, listRequesterGatewaysRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRequesterGateways(software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListRequesterGatewaysIterable responses = client.listRequesterGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rtbfabric.paginators.ListRequesterGatewaysIterable responses = client
     *             .listRequesterGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListRequesterGatewaysIterable responses = client.listRequesterGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRequesterGateways(software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRequesterGatewaysRequest.Builder} avoiding the
     * need to create one manually via {@link ListRequesterGatewaysRequest#builder()}
     * </p>
     *
     * @param listRequesterGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.ListRequesterGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListRequesterGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRequesterGatewaysIterable listRequesterGatewaysPaginator(
            Consumer<ListRequesterGatewaysRequest.Builder> listRequesterGatewaysRequest) throws InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        return listRequesterGatewaysPaginator(ListRequesterGatewaysRequest.builder().applyMutation(listRequesterGatewaysRequest)
                .build());
    }

    /**
     * <p>
     * Lists reponder gateways.
     * </p>
     *
     * @param listResponderGatewaysRequest
     * @return Result of the ListResponderGateways operation returned by the service.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.ListResponderGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListResponderGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResponderGatewaysResponse listResponderGateways(ListResponderGatewaysRequest listResponderGatewaysRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists reponder gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResponderGatewaysRequest.Builder} avoiding the
     * need to create one manually via {@link ListResponderGatewaysRequest#builder()}
     * </p>
     *
     * @param listResponderGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysRequest.Builder} to create a
     *        request.
     * @return Result of the ListResponderGateways operation returned by the service.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.ListResponderGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListResponderGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResponderGatewaysResponse listResponderGateways(
            Consumer<ListResponderGatewaysRequest.Builder> listResponderGatewaysRequest) throws InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        return listResponderGateways(ListResponderGatewaysRequest.builder().applyMutation(listResponderGatewaysRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResponderGateways(software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListResponderGatewaysIterable responses = client.listResponderGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rtbfabric.paginators.ListResponderGatewaysIterable responses = client
     *             .listResponderGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListResponderGatewaysIterable responses = client.listResponderGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResponderGateways(software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResponderGatewaysRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.ListResponderGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListResponderGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResponderGatewaysIterable listResponderGatewaysPaginator(ListResponderGatewaysRequest listResponderGatewaysRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        return new ListResponderGatewaysIterable(this, listResponderGatewaysRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResponderGateways(software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListResponderGatewaysIterable responses = client.listResponderGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rtbfabric.paginators.ListResponderGatewaysIterable responses = client
     *             .listResponderGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rtbfabric.paginators.ListResponderGatewaysIterable responses = client.listResponderGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResponderGateways(software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResponderGatewaysRequest.Builder} avoiding the
     * need to create one manually via {@link ListResponderGatewaysRequest#builder()}
     * </p>
     *
     * @param listResponderGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.ListResponderGatewaysRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.ListResponderGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListResponderGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResponderGatewaysIterable listResponderGatewaysPaginator(
            Consumer<ListResponderGatewaysRequest.Builder> listResponderGatewaysRequest) throws InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        return listResponderGatewaysPaginator(ListResponderGatewaysRequest.builder().applyMutation(listResponderGatewaysRequest)
                .build());
    }

    /**
     * <p>
     * Lists tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, RtbFabricException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Rejects a link request between gateways.
     * </p>
     * <p>
     * When a requester gateway requests to link with a responder gateway, the responder can use this operation to
     * decline the link request.
     * </p>
     *
     * @param rejectLinkRequest
     * @return Result of the RejectLink operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.RejectLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/RejectLink" target="_top">AWS API
     *      Documentation</a>
     */
    default RejectLinkResponse rejectLink(RejectLinkRequest rejectLinkRequest) throws ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, ConflictException, InternalServerException, ValidationException,
            AwsServiceException, SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects a link request between gateways.
     * </p>
     * <p>
     * When a requester gateway requests to link with a responder gateway, the responder can use this operation to
     * decline the link request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectLinkRequest.Builder} avoiding the need to
     * create one manually via {@link RejectLinkRequest#builder()}
     * </p>
     *
     * @param rejectLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.RejectLinkRequest.Builder} to create a request.
     * @return Result of the RejectLink operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.RejectLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/RejectLink" target="_top">AWS API
     *      Documentation</a>
     */
    default RejectLinkResponse rejectLink(Consumer<RejectLinkRequest.Builder> rejectLinkRequest)
            throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        return rejectLink(RejectLinkRequest.builder().applyMutation(rejectLinkRequest).build());
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag or tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag or tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of a link between gateways.
     * </p>
     * <p>
     * Allows you to modify settings and parameters for an existing link.
     * </p>
     *
     * @param updateLinkRequest
     * @return Result of the UpdateLink operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.UpdateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/UpdateLink" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateLinkResponse updateLink(UpdateLinkRequest updateLinkRequest) throws ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, ConflictException, InternalServerException, ValidationException,
            AwsServiceException, SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of a link between gateways.
     * </p>
     * <p>
     * Allows you to modify settings and parameters for an existing link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLinkRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateLinkRequest#builder()}
     * </p>
     *
     * @param updateLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.UpdateLinkRequest.Builder} to create a request.
     * @return Result of the UpdateLink operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.UpdateLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/UpdateLink" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateLinkResponse updateLink(Consumer<UpdateLinkRequest.Builder> updateLinkRequest)
            throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        return updateLink(UpdateLinkRequest.builder().applyMutation(updateLinkRequest).build());
    }

    /**
     * <p>
     * Updates a link module flow.
     * </p>
     *
     * @param updateLinkModuleFlowRequest
     * @return Result of the UpdateLinkModuleFlow operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because you exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.UpdateLinkModuleFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/UpdateLinkModuleFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLinkModuleFlowResponse updateLinkModuleFlow(UpdateLinkModuleFlowRequest updateLinkModuleFlowRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            ConflictException, InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a link module flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLinkModuleFlowRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateLinkModuleFlowRequest#builder()}
     * </p>
     *
     * @param updateLinkModuleFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.UpdateLinkModuleFlowRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateLinkModuleFlow operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because you exceeded a service quota.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.UpdateLinkModuleFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/UpdateLinkModuleFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLinkModuleFlowResponse updateLinkModuleFlow(
            Consumer<UpdateLinkModuleFlowRequest.Builder> updateLinkModuleFlowRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException, InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        return updateLinkModuleFlow(UpdateLinkModuleFlowRequest.builder().applyMutation(updateLinkModuleFlowRequest).build());
    }

    /**
     * <p>
     * Updates a requester gateway.
     * </p>
     *
     * @param updateRequesterGatewayRequest
     * @return Result of the UpdateRequesterGateway operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.UpdateRequesterGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/UpdateRequesterGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRequesterGatewayResponse updateRequesterGateway(UpdateRequesterGatewayRequest updateRequesterGatewayRequest)
            throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a requester gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRequesterGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRequesterGatewayRequest#builder()}
     * </p>
     *
     * @param updateRequesterGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.UpdateRequesterGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateRequesterGateway operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.UpdateRequesterGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/UpdateRequesterGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRequesterGatewayResponse updateRequesterGateway(
            Consumer<UpdateRequesterGatewayRequest.Builder> updateRequesterGatewayRequest) throws ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, ConflictException, InternalServerException, ValidationException,
            AwsServiceException, SdkClientException, RtbFabricException {
        return updateRequesterGateway(UpdateRequesterGatewayRequest.builder().applyMutation(updateRequesterGatewayRequest)
                .build());
    }

    /**
     * <p>
     * Updates a responder gateway.
     * </p>
     *
     * @param updateResponderGatewayRequest
     * @return Result of the UpdateResponderGateway operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.UpdateResponderGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/UpdateResponderGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResponderGatewayResponse updateResponderGateway(UpdateResponderGatewayRequest updateResponderGatewayRequest)
            throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException, RtbFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a responder gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResponderGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResponderGatewayRequest#builder()}
     * </p>
     *
     * @param updateResponderGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rtbfabric.model.UpdateResponderGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateResponderGateway operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request could not be completed because the resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         The request could not be completed because you do not have sufficient access to perform this action.
     * @throws ConflictException
     *         The request could not be completed because of a conflict in the current state of the resource.
     * @throws InternalServerException
     *         The request could not be completed because of an internal server error. Try your call again.
     * @throws ValidationException
     *         The request could not be completed because it fails satisfy the constraints specified by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RtbFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RtbFabricClient.UpdateResponderGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/UpdateResponderGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResponderGatewayResponse updateResponderGateway(
            Consumer<UpdateResponderGatewayRequest.Builder> updateResponderGatewayRequest) throws ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, ConflictException, InternalServerException, ValidationException,
            AwsServiceException, SdkClientException, RtbFabricException {
        return updateResponderGateway(UpdateResponderGatewayRequest.builder().applyMutation(updateResponderGatewayRequest)
                .build());
    }

    /**
     * Create an instance of {@link RtbFabricWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link RtbFabricWaiter}
     */
    default RtbFabricWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link RtbFabricClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static RtbFabricClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link RtbFabricClient}.
     */
    static RtbFabricClientBuilder builder() {
        return new DefaultRtbFabricClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default RtbFabricServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
