/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInboundExternalLinkRequest extends RtbFabricRequest implements
        ToCopyableBuilder<CreateInboundExternalLinkRequest.Builder, CreateInboundExternalLinkRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateInboundExternalLinkRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayId").getter(getter(CreateInboundExternalLinkRequest::gatewayId))
            .setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayId").build()).build();

    private static final SdkField<LinkAttributes> ATTRIBUTES_FIELD = SdkField.<LinkAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("attributes").getter(getter(CreateInboundExternalLinkRequest::attributes))
            .setter(setter(Builder::attributes)).constructor(LinkAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build()).build();

    private static final SdkField<LinkLogSettings> LOG_SETTINGS_FIELD = SdkField
            .<LinkLogSettings> builder(MarshallingType.SDK_POJO).memberName("logSettings")
            .getter(getter(CreateInboundExternalLinkRequest::logSettings)).setter(setter(Builder::logSettings))
            .constructor(LinkLogSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logSettings").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateInboundExternalLinkRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            GATEWAY_ID_FIELD, ATTRIBUTES_FIELD, LOG_SETTINGS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String gatewayId;

    private final LinkAttributes attributes;

    private final LinkLogSettings logSettings;

    private final Map<String, String> tags;

    private CreateInboundExternalLinkRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.gatewayId = builder.gatewayId;
        this.attributes = builder.attributes;
        this.logSettings = builder.logSettings;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique client token.
     * </p>
     * 
     * @return The unique client token.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The unique identifier of the gateway.
     * </p>
     * 
     * @return The unique identifier of the gateway.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * Attributes of the link.
     * </p>
     * 
     * @return Attributes of the link.
     */
    public final LinkAttributes attributes() {
        return attributes;
    }

    /**
     * Returns the value of the LogSettings property for this object.
     * 
     * @return The value of the LogSettings property for this object.
     */
    public final LinkLogSettings logSettings() {
        return logSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of the key-value pairs of the tag or tags to assign to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of the key-value pairs of the tag or tags to assign to the resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(logSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInboundExternalLinkRequest)) {
            return false;
        }
        CreateInboundExternalLinkRequest other = (CreateInboundExternalLinkRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(gatewayId(), other.gatewayId())
                && Objects.equals(attributes(), other.attributes()) && Objects.equals(logSettings(), other.logSettings())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInboundExternalLinkRequest").add("ClientToken", clientToken())
                .add("GatewayId", gatewayId()).add("Attributes", attributes()).add("LogSettings", logSettings())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "gatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "logSettings":
            return Optional.ofNullable(clazz.cast(logSettings()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("gatewayId", GATEWAY_ID_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("logSettings", LOG_SETTINGS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInboundExternalLinkRequest, T> g) {
        return obj -> g.apply((CreateInboundExternalLinkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RtbFabricRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateInboundExternalLinkRequest> {
        /**
         * <p>
         * The unique client token.
         * </p>
         * 
         * @param clientToken
         *        The unique client token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The unique identifier of the gateway.
         * </p>
         * 
         * @param gatewayId
         *        The unique identifier of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * Attributes of the link.
         * </p>
         * 
         * @param attributes
         *        Attributes of the link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(LinkAttributes attributes);

        /**
         * <p>
         * Attributes of the link.
         * </p>
         * This is a convenience method that creates an instance of the {@link LinkAttributes.Builder} avoiding the need
         * to create one manually via {@link LinkAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LinkAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #attributes(LinkAttributes)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link LinkAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(LinkAttributes)
         */
        default Builder attributes(Consumer<LinkAttributes.Builder> attributes) {
            return attributes(LinkAttributes.builder().applyMutation(attributes).build());
        }

        /**
         * Sets the value of the LogSettings property for this object.
         *
         * @param logSettings
         *        The new value for the LogSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logSettings(LinkLogSettings logSettings);

        /**
         * Sets the value of the LogSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LinkLogSettings.Builder} avoiding the
         * need to create one manually via {@link LinkLogSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LinkLogSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #logSettings(LinkLogSettings)}.
         * 
         * @param logSettings
         *        a consumer that will call methods on {@link LinkLogSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logSettings(LinkLogSettings)
         */
        default Builder logSettings(Consumer<LinkLogSettings.Builder> logSettings) {
            return logSettings(LinkLogSettings.builder().applyMutation(logSettings).build());
        }

        /**
         * <p>
         * A map of the key-value pairs of the tag or tags to assign to the resource.
         * </p>
         * 
         * @param tags
         *        A map of the key-value pairs of the tag or tags to assign to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RtbFabricRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String gatewayId;

        private LinkAttributes attributes;

        private LinkLogSettings logSettings;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInboundExternalLinkRequest model) {
            super(model);
            clientToken(model.clientToken);
            gatewayId(model.gatewayId);
            attributes(model.attributes);
            logSettings(model.logSettings);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final LinkAttributes.Builder getAttributes() {
            return attributes != null ? attributes.toBuilder() : null;
        }

        public final void setAttributes(LinkAttributes.BuilderImpl attributes) {
            this.attributes = attributes != null ? attributes.build() : null;
        }

        @Override
        public final Builder attributes(LinkAttributes attributes) {
            this.attributes = attributes;
            return this;
        }

        public final LinkLogSettings.Builder getLogSettings() {
            return logSettings != null ? logSettings.toBuilder() : null;
        }

        public final void setLogSettings(LinkLogSettings.BuilderImpl logSettings) {
            this.logSettings = logSettings != null ? logSettings.build() : null;
        }

        @Override
        public final Builder logSettings(LinkLogSettings logSettings) {
            this.logSettings = logSettings;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInboundExternalLinkRequest build() {
            return new CreateInboundExternalLinkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
