/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of an Amazon Elastic Kubernetes Service endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EksEndpointsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EksEndpointsConfiguration.Builder, EksEndpointsConfiguration> {
    private static final SdkField<String> ENDPOINTS_RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpointsResourceName").getter(getter(EksEndpointsConfiguration::endpointsResourceName))
            .setter(setter(Builder::endpointsResourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointsResourceName").build())
            .build();

    private static final SdkField<String> ENDPOINTS_RESOURCE_NAMESPACE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("endpointsResourceNamespace")
            .getter(getter(EksEndpointsConfiguration::endpointsResourceNamespace))
            .setter(setter(Builder::endpointsResourceNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointsResourceNamespace").build())
            .build();

    private static final SdkField<String> CLUSTER_API_SERVER_ENDPOINT_URI_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clusterApiServerEndpointUri")
            .getter(getter(EksEndpointsConfiguration::clusterApiServerEndpointUri))
            .setter(setter(Builder::clusterApiServerEndpointUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterApiServerEndpointUri")
                    .build()).build();

    private static final SdkField<String> CLUSTER_API_SERVER_CA_CERTIFICATE_CHAIN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clusterApiServerCaCertificateChain")
            .getter(getter(EksEndpointsConfiguration::clusterApiServerCaCertificateChain))
            .setter(setter(Builder::clusterApiServerCaCertificateChain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterApiServerCaCertificateChain")
                    .build()).build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(EksEndpointsConfiguration::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(EksEndpointsConfiguration::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINTS_RESOURCE_NAME_FIELD,
            ENDPOINTS_RESOURCE_NAMESPACE_FIELD, CLUSTER_API_SERVER_ENDPOINT_URI_FIELD,
            CLUSTER_API_SERVER_CA_CERTIFICATE_CHAIN_FIELD, CLUSTER_NAME_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String endpointsResourceName;

    private final String endpointsResourceNamespace;

    private final String clusterApiServerEndpointUri;

    private final String clusterApiServerCaCertificateChain;

    private final String clusterName;

    private final String roleArn;

    private EksEndpointsConfiguration(BuilderImpl builder) {
        this.endpointsResourceName = builder.endpointsResourceName;
        this.endpointsResourceNamespace = builder.endpointsResourceNamespace;
        this.clusterApiServerEndpointUri = builder.clusterApiServerEndpointUri;
        this.clusterApiServerCaCertificateChain = builder.clusterApiServerCaCertificateChain;
        this.clusterName = builder.clusterName;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The name of the endpoint resource.
     * </p>
     * 
     * @return The name of the endpoint resource.
     */
    public final String endpointsResourceName() {
        return endpointsResourceName;
    }

    /**
     * <p>
     * The namespace of the endpoint resource.
     * </p>
     * 
     * @return The namespace of the endpoint resource.
     */
    public final String endpointsResourceNamespace() {
        return endpointsResourceNamespace;
    }

    /**
     * <p>
     * The URI of the cluster API server endpoint.
     * </p>
     * 
     * @return The URI of the cluster API server endpoint.
     */
    public final String clusterApiServerEndpointUri() {
        return clusterApiServerEndpointUri;
    }

    /**
     * <p>
     * The CA certificate chain of the cluster API server.
     * </p>
     * 
     * @return The CA certificate chain of the cluster API server.
     */
    public final String clusterApiServerCaCertificateChain() {
        return clusterApiServerCaCertificateChain;
    }

    /**
     * <p>
     * The name of the cluster.
     * </p>
     * 
     * @return The name of the cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The role ARN for the cluster.
     * </p>
     * 
     * @return The role ARN for the cluster.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointsResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(endpointsResourceNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(clusterApiServerEndpointUri());
        hashCode = 31 * hashCode + Objects.hashCode(clusterApiServerCaCertificateChain());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksEndpointsConfiguration)) {
            return false;
        }
        EksEndpointsConfiguration other = (EksEndpointsConfiguration) obj;
        return Objects.equals(endpointsResourceName(), other.endpointsResourceName())
                && Objects.equals(endpointsResourceNamespace(), other.endpointsResourceNamespace())
                && Objects.equals(clusterApiServerEndpointUri(), other.clusterApiServerEndpointUri())
                && Objects.equals(clusterApiServerCaCertificateChain(), other.clusterApiServerCaCertificateChain())
                && Objects.equals(clusterName(), other.clusterName()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("EksEndpointsConfiguration")
                .add("EndpointsResourceName", endpointsResourceName())
                .add("EndpointsResourceNamespace", endpointsResourceNamespace())
                .add("ClusterApiServerEndpointUri", clusterApiServerEndpointUri())
                .add("ClusterApiServerCaCertificateChain",
                        clusterApiServerCaCertificateChain() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ClusterName", clusterName()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endpointsResourceName":
            return Optional.ofNullable(clazz.cast(endpointsResourceName()));
        case "endpointsResourceNamespace":
            return Optional.ofNullable(clazz.cast(endpointsResourceNamespace()));
        case "clusterApiServerEndpointUri":
            return Optional.ofNullable(clazz.cast(clusterApiServerEndpointUri()));
        case "clusterApiServerCaCertificateChain":
            return Optional.ofNullable(clazz.cast(clusterApiServerCaCertificateChain()));
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("endpointsResourceName", ENDPOINTS_RESOURCE_NAME_FIELD);
        map.put("endpointsResourceNamespace", ENDPOINTS_RESOURCE_NAMESPACE_FIELD);
        map.put("clusterApiServerEndpointUri", CLUSTER_API_SERVER_ENDPOINT_URI_FIELD);
        map.put("clusterApiServerCaCertificateChain", CLUSTER_API_SERVER_CA_CERTIFICATE_CHAIN_FIELD);
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EksEndpointsConfiguration, T> g) {
        return obj -> g.apply((EksEndpointsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EksEndpointsConfiguration> {
        /**
         * <p>
         * The name of the endpoint resource.
         * </p>
         * 
         * @param endpointsResourceName
         *        The name of the endpoint resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointsResourceName(String endpointsResourceName);

        /**
         * <p>
         * The namespace of the endpoint resource.
         * </p>
         * 
         * @param endpointsResourceNamespace
         *        The namespace of the endpoint resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointsResourceNamespace(String endpointsResourceNamespace);

        /**
         * <p>
         * The URI of the cluster API server endpoint.
         * </p>
         * 
         * @param clusterApiServerEndpointUri
         *        The URI of the cluster API server endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterApiServerEndpointUri(String clusterApiServerEndpointUri);

        /**
         * <p>
         * The CA certificate chain of the cluster API server.
         * </p>
         * 
         * @param clusterApiServerCaCertificateChain
         *        The CA certificate chain of the cluster API server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterApiServerCaCertificateChain(String clusterApiServerCaCertificateChain);

        /**
         * <p>
         * The name of the cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The role ARN for the cluster.
         * </p>
         * 
         * @param roleArn
         *        The role ARN for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String endpointsResourceName;

        private String endpointsResourceNamespace;

        private String clusterApiServerEndpointUri;

        private String clusterApiServerCaCertificateChain;

        private String clusterName;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EksEndpointsConfiguration model) {
            endpointsResourceName(model.endpointsResourceName);
            endpointsResourceNamespace(model.endpointsResourceNamespace);
            clusterApiServerEndpointUri(model.clusterApiServerEndpointUri);
            clusterApiServerCaCertificateChain(model.clusterApiServerCaCertificateChain);
            clusterName(model.clusterName);
            roleArn(model.roleArn);
        }

        public final String getEndpointsResourceName() {
            return endpointsResourceName;
        }

        public final void setEndpointsResourceName(String endpointsResourceName) {
            this.endpointsResourceName = endpointsResourceName;
        }

        @Override
        public final Builder endpointsResourceName(String endpointsResourceName) {
            this.endpointsResourceName = endpointsResourceName;
            return this;
        }

        public final String getEndpointsResourceNamespace() {
            return endpointsResourceNamespace;
        }

        public final void setEndpointsResourceNamespace(String endpointsResourceNamespace) {
            this.endpointsResourceNamespace = endpointsResourceNamespace;
        }

        @Override
        public final Builder endpointsResourceNamespace(String endpointsResourceNamespace) {
            this.endpointsResourceNamespace = endpointsResourceNamespace;
            return this;
        }

        public final String getClusterApiServerEndpointUri() {
            return clusterApiServerEndpointUri;
        }

        public final void setClusterApiServerEndpointUri(String clusterApiServerEndpointUri) {
            this.clusterApiServerEndpointUri = clusterApiServerEndpointUri;
        }

        @Override
        public final Builder clusterApiServerEndpointUri(String clusterApiServerEndpointUri) {
            this.clusterApiServerEndpointUri = clusterApiServerEndpointUri;
            return this;
        }

        public final String getClusterApiServerCaCertificateChain() {
            return clusterApiServerCaCertificateChain;
        }

        public final void setClusterApiServerCaCertificateChain(String clusterApiServerCaCertificateChain) {
            this.clusterApiServerCaCertificateChain = clusterApiServerCaCertificateChain;
        }

        @Override
        public final Builder clusterApiServerCaCertificateChain(String clusterApiServerCaCertificateChain) {
            this.clusterApiServerCaCertificateChain = clusterApiServerCaCertificateChain;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public EksEndpointsConfiguration build() {
            return new EksEndpointsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
