/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOutboundExternalLinkResponse extends RtbFabricResponse implements
        ToCopyableBuilder<GetOutboundExternalLinkResponse.Builder, GetOutboundExternalLinkResponse> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayId").getter(getter(GetOutboundExternalLinkResponse::gatewayId))
            .setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayId").build()).build();

    private static final SdkField<String> LINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("linkId")
            .getter(getter(GetOutboundExternalLinkResponse::linkId)).setter(setter(Builder::linkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linkId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetOutboundExternalLinkResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> PUBLIC_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("publicEndpoint").getter(getter(GetOutboundExternalLinkResponse::publicEndpoint))
            .setter(setter(Builder::publicEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicEndpoint").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetOutboundExternalLinkResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(GetOutboundExternalLinkResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetOutboundExternalLinkResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<LinkLogSettings> LOG_SETTINGS_FIELD = SdkField
            .<LinkLogSettings> builder(MarshallingType.SDK_POJO).memberName("logSettings")
            .getter(getter(GetOutboundExternalLinkResponse::logSettings)).setter(setter(Builder::logSettings))
            .constructor(LinkLogSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD,
            LINK_ID_FIELD, STATUS_FIELD, PUBLIC_ENDPOINT_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, TAGS_FIELD,
            LOG_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gatewayId;

    private final String linkId;

    private final String status;

    private final String publicEndpoint;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final Map<String, String> tags;

    private final LinkLogSettings logSettings;

    private GetOutboundExternalLinkResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayId = builder.gatewayId;
        this.linkId = builder.linkId;
        this.status = builder.status;
        this.publicEndpoint = builder.publicEndpoint;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.tags = builder.tags;
        this.logSettings = builder.logSettings;
    }

    /**
     * <p>
     * The unique identifier of the gateway.
     * </p>
     * 
     * @return The unique identifier of the gateway.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The unique identifier of the link.
     * </p>
     * 
     * @return The unique identifier of the link.
     */
    public final String linkId() {
        return linkId;
    }

    /**
     * <p>
     * The status of the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LinkStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the request.
     * @see LinkStatus
     */
    public final LinkStatus status() {
        return LinkStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LinkStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the request.
     * @see LinkStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The public endpoint for the link.
     * </p>
     * 
     * @return The public endpoint for the link.
     */
    public final String publicEndpoint() {
        return publicEndpoint;
    }

    /**
     * <p>
     * The timestamp of when the outbound external link was created.
     * </p>
     * 
     * @return The timestamp of when the outbound external link was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp of when the outbound external link was updated.
     * </p>
     * 
     * @return The timestamp of when the outbound external link was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of the key-value pairs for the tag or tags assigned to the specified resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of the key-value pairs for the tag or tags assigned to the specified resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * Returns the value of the LogSettings property for this object.
     * 
     * @return The value of the LogSettings property for this object.
     */
    public final LinkLogSettings logSettings() {
        return logSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(linkId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(publicEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(logSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOutboundExternalLinkResponse)) {
            return false;
        }
        GetOutboundExternalLinkResponse other = (GetOutboundExternalLinkResponse) obj;
        return Objects.equals(gatewayId(), other.gatewayId()) && Objects.equals(linkId(), other.linkId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(publicEndpoint(), other.publicEndpoint()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(logSettings(), other.logSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOutboundExternalLinkResponse").add("GatewayId", gatewayId()).add("LinkId", linkId())
                .add("Status", statusAsString()).add("PublicEndpoint", publicEndpoint()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).add("Tags", hasTags() ? tags() : null).add("LogSettings", logSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "linkId":
            return Optional.ofNullable(clazz.cast(linkId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "publicEndpoint":
            return Optional.ofNullable(clazz.cast(publicEndpoint()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "logSettings":
            return Optional.ofNullable(clazz.cast(logSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("gatewayId", GATEWAY_ID_FIELD);
        map.put("linkId", LINK_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("publicEndpoint", PUBLIC_ENDPOINT_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("logSettings", LOG_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOutboundExternalLinkResponse, T> g) {
        return obj -> g.apply((GetOutboundExternalLinkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RtbFabricResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetOutboundExternalLinkResponse> {
        /**
         * <p>
         * The unique identifier of the gateway.
         * </p>
         * 
         * @param gatewayId
         *        The unique identifier of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The unique identifier of the link.
         * </p>
         * 
         * @param linkId
         *        The unique identifier of the link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkId(String linkId);

        /**
         * <p>
         * The status of the request.
         * </p>
         * 
         * @param status
         *        The status of the request.
         * @see LinkStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LinkStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the request.
         * </p>
         * 
         * @param status
         *        The status of the request.
         * @see LinkStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LinkStatus
         */
        Builder status(LinkStatus status);

        /**
         * <p>
         * The public endpoint for the link.
         * </p>
         * 
         * @param publicEndpoint
         *        The public endpoint for the link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicEndpoint(String publicEndpoint);

        /**
         * <p>
         * The timestamp of when the outbound external link was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the outbound external link was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp of when the outbound external link was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the outbound external link was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * A map of the key-value pairs for the tag or tags assigned to the specified resource.
         * </p>
         * 
         * @param tags
         *        A map of the key-value pairs for the tag or tags assigned to the specified resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * Sets the value of the LogSettings property for this object.
         *
         * @param logSettings
         *        The new value for the LogSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logSettings(LinkLogSettings logSettings);

        /**
         * Sets the value of the LogSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LinkLogSettings.Builder} avoiding the
         * need to create one manually via {@link LinkLogSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LinkLogSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #logSettings(LinkLogSettings)}.
         * 
         * @param logSettings
         *        a consumer that will call methods on {@link LinkLogSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logSettings(LinkLogSettings)
         */
        default Builder logSettings(Consumer<LinkLogSettings.Builder> logSettings) {
            return logSettings(LinkLogSettings.builder().applyMutation(logSettings).build());
        }
    }

    static final class BuilderImpl extends RtbFabricResponse.BuilderImpl implements Builder {
        private String gatewayId;

        private String linkId;

        private String status;

        private String publicEndpoint;

        private Instant createdAt;

        private Instant updatedAt;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private LinkLogSettings logSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOutboundExternalLinkResponse model) {
            super(model);
            gatewayId(model.gatewayId);
            linkId(model.linkId);
            status(model.status);
            publicEndpoint(model.publicEndpoint);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            tags(model.tags);
            logSettings(model.logSettings);
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getLinkId() {
            return linkId;
        }

        public final void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        @Override
        public final Builder linkId(String linkId) {
            this.linkId = linkId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LinkStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getPublicEndpoint() {
            return publicEndpoint;
        }

        public final void setPublicEndpoint(String publicEndpoint) {
            this.publicEndpoint = publicEndpoint;
        }

        @Override
        public final Builder publicEndpoint(String publicEndpoint) {
            this.publicEndpoint = publicEndpoint;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final LinkLogSettings.Builder getLogSettings() {
            return logSettings != null ? logSettings.toBuilder() : null;
        }

        public final void setLogSettings(LinkLogSettings.BuilderImpl logSettings) {
            this.logSettings = logSettings != null ? logSettings.build() : null;
        }

        @Override
        public final Builder logSettings(LinkLogSettings logSettings) {
            this.logSettings = logSettings;
            return this;
        }

        @Override
        public GetOutboundExternalLinkResponse build() {
            return new GetOutboundExternalLinkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
