/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of a link application log.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LinkApplicationLogConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LinkApplicationLogConfiguration.Builder, LinkApplicationLogConfiguration> {
    private static final SdkField<LinkApplicationLogSampling> SAMPLING_FIELD = SdkField
            .<LinkApplicationLogSampling> builder(MarshallingType.SDK_POJO).memberName("sampling")
            .getter(getter(LinkApplicationLogConfiguration::sampling)).setter(setter(Builder::sampling))
            .constructor(LinkApplicationLogSampling::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampling").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAMPLING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LinkApplicationLogSampling sampling;

    private LinkApplicationLogConfiguration(BuilderImpl builder) {
        this.sampling = builder.sampling;
    }

    /**
     * <p>
     * Describes a link application log sample.
     * </p>
     * 
     * @return Describes a link application log sample.
     */
    public final LinkApplicationLogSampling sampling() {
        return sampling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sampling());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinkApplicationLogConfiguration)) {
            return false;
        }
        LinkApplicationLogConfiguration other = (LinkApplicationLogConfiguration) obj;
        return Objects.equals(sampling(), other.sampling());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LinkApplicationLogConfiguration").add("Sampling", sampling()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sampling":
            return Optional.ofNullable(clazz.cast(sampling()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sampling", SAMPLING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LinkApplicationLogConfiguration, T> g) {
        return obj -> g.apply((LinkApplicationLogConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LinkApplicationLogConfiguration> {
        /**
         * <p>
         * Describes a link application log sample.
         * </p>
         * 
         * @param sampling
         *        Describes a link application log sample.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampling(LinkApplicationLogSampling sampling);

        /**
         * <p>
         * Describes a link application log sample.
         * </p>
         * This is a convenience method that creates an instance of the {@link LinkApplicationLogSampling.Builder}
         * avoiding the need to create one manually via {@link LinkApplicationLogSampling#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LinkApplicationLogSampling.Builder#build()} is called immediately
         * and its result is passed to {@link #sampling(LinkApplicationLogSampling)}.
         * 
         * @param sampling
         *        a consumer that will call methods on {@link LinkApplicationLogSampling.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sampling(LinkApplicationLogSampling)
         */
        default Builder sampling(Consumer<LinkApplicationLogSampling.Builder> sampling) {
            return sampling(LinkApplicationLogSampling.builder().applyMutation(sampling).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LinkApplicationLogSampling sampling;

        private BuilderImpl() {
        }

        private BuilderImpl(LinkApplicationLogConfiguration model) {
            sampling(model.sampling);
        }

        public final LinkApplicationLogSampling.Builder getSampling() {
            return sampling != null ? sampling.toBuilder() : null;
        }

        public final void setSampling(LinkApplicationLogSampling.BuilderImpl sampling) {
            this.sampling = sampling != null ? sampling.build() : null;
        }

        @Override
        public final Builder sampling(LinkApplicationLogSampling sampling) {
            this.sampling = sampling;
            return this;
        }

        @Override
        public LinkApplicationLogConfiguration build() {
            return new LinkApplicationLogConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
