/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the parameters of an open RTB attribute module.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpenRtbAttributeModuleParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<OpenRtbAttributeModuleParameters.Builder, OpenRtbAttributeModuleParameters> {
    private static final SdkField<String> FILTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterType").getter(getter(OpenRtbAttributeModuleParameters::filterTypeAsString))
            .setter(setter(Builder::filterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterType").build()).build();

    private static final SdkField<List<Filter>> FILTER_CONFIGURATION_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("filterConfiguration")
            .getter(getter(OpenRtbAttributeModuleParameters::filterConfiguration))
            .setter(setter(Builder::filterConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Action> ACTION_FIELD = SdkField.<Action> builder(MarshallingType.SDK_POJO).memberName("action")
            .getter(getter(OpenRtbAttributeModuleParameters::action)).setter(setter(Builder::action))
            .constructor(Action::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<Float> HOLDBACK_PERCENTAGE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("holdbackPercentage").getter(getter(OpenRtbAttributeModuleParameters::holdbackPercentage))
            .setter(setter(Builder::holdbackPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("holdbackPercentage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_TYPE_FIELD,
            FILTER_CONFIGURATION_FIELD, ACTION_FIELD, HOLDBACK_PERCENTAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String filterType;

    private final List<Filter> filterConfiguration;

    private final Action action;

    private final Float holdbackPercentage;

    private OpenRtbAttributeModuleParameters(BuilderImpl builder) {
        this.filterType = builder.filterType;
        this.filterConfiguration = builder.filterConfiguration;
        this.action = builder.action;
        this.holdbackPercentage = builder.holdbackPercentage;
    }

    /**
     * <p>
     * The filter type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterType} will
     * return {@link FilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterTypeAsString}.
     * </p>
     * 
     * @return The filter type.
     * @see FilterType
     */
    public final FilterType filterType() {
        return FilterType.fromValue(filterType);
    }

    /**
     * <p>
     * The filter type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterType} will
     * return {@link FilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterTypeAsString}.
     * </p>
     * 
     * @return The filter type.
     * @see FilterType
     */
    public final String filterTypeAsString() {
        return filterType;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterConfiguration property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFilterConfiguration() {
        return filterConfiguration != null && !(filterConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the configuration of a filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterConfiguration} method.
     * </p>
     * 
     * @return Describes the configuration of a filter.
     */
    public final List<Filter> filterConfiguration() {
        return filterConfiguration;
    }

    /**
     * <p>
     * Describes a bid action.
     * </p>
     * 
     * @return Describes a bid action.
     */
    public final Action action() {
        return action;
    }

    /**
     * <p>
     * The hold back percentage.
     * </p>
     * 
     * @return The hold back percentage.
     */
    public final Float holdbackPercentage() {
        return holdbackPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterConfiguration() ? filterConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(holdbackPercentage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenRtbAttributeModuleParameters)) {
            return false;
        }
        OpenRtbAttributeModuleParameters other = (OpenRtbAttributeModuleParameters) obj;
        return Objects.equals(filterTypeAsString(), other.filterTypeAsString())
                && hasFilterConfiguration() == other.hasFilterConfiguration()
                && Objects.equals(filterConfiguration(), other.filterConfiguration()) && Objects.equals(action(), other.action())
                && Objects.equals(holdbackPercentage(), other.holdbackPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpenRtbAttributeModuleParameters").add("FilterType", filterTypeAsString())
                .add("FilterConfiguration", hasFilterConfiguration() ? filterConfiguration() : null).add("Action", action())
                .add("HoldbackPercentage", holdbackPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filterType":
            return Optional.ofNullable(clazz.cast(filterTypeAsString()));
        case "filterConfiguration":
            return Optional.ofNullable(clazz.cast(filterConfiguration()));
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "holdbackPercentage":
            return Optional.ofNullable(clazz.cast(holdbackPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filterType", FILTER_TYPE_FIELD);
        map.put("filterConfiguration", FILTER_CONFIGURATION_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("holdbackPercentage", HOLDBACK_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpenRtbAttributeModuleParameters, T> g) {
        return obj -> g.apply((OpenRtbAttributeModuleParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpenRtbAttributeModuleParameters> {
        /**
         * <p>
         * The filter type.
         * </p>
         * 
         * @param filterType
         *        The filter type.
         * @see FilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterType
         */
        Builder filterType(String filterType);

        /**
         * <p>
         * The filter type.
         * </p>
         * 
         * @param filterType
         *        The filter type.
         * @see FilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterType
         */
        Builder filterType(FilterType filterType);

        /**
         * <p>
         * Describes the configuration of a filter.
         * </p>
         * 
         * @param filterConfiguration
         *        Describes the configuration of a filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterConfiguration(Collection<Filter> filterConfiguration);

        /**
         * <p>
         * Describes the configuration of a filter.
         * </p>
         * 
         * @param filterConfiguration
         *        Describes the configuration of a filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterConfiguration(Filter... filterConfiguration);

        /**
         * <p>
         * Describes the configuration of a filter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rtbfabric.model.Filter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rtbfabric.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rtbfabric.model.Filter.Builder#build()} is called immediately and its
         * result is passed to {@link #filterConfiguration(List<Filter>)}.
         * 
         * @param filterConfiguration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rtbfabric.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterConfiguration(java.util.Collection<Filter>)
         */
        Builder filterConfiguration(Consumer<Filter.Builder>... filterConfiguration);

        /**
         * <p>
         * Describes a bid action.
         * </p>
         * 
         * @param action
         *        Describes a bid action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(Action action);

        /**
         * <p>
         * Describes a bid action.
         * </p>
         * This is a convenience method that creates an instance of the {@link Action.Builder} avoiding the need to
         * create one manually via {@link Action#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Action.Builder#build()} is called immediately and its result is
         * passed to {@link #action(Action)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(Action)
         */
        default Builder action(Consumer<Action.Builder> action) {
            return action(Action.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * The hold back percentage.
         * </p>
         * 
         * @param holdbackPercentage
         *        The hold back percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder holdbackPercentage(Float holdbackPercentage);
    }

    static final class BuilderImpl implements Builder {
        private String filterType;

        private List<Filter> filterConfiguration = DefaultSdkAutoConstructList.getInstance();

        private Action action;

        private Float holdbackPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenRtbAttributeModuleParameters model) {
            filterType(model.filterType);
            filterConfiguration(model.filterConfiguration);
            action(model.action);
            holdbackPercentage(model.holdbackPercentage);
        }

        public final String getFilterType() {
            return filterType;
        }

        public final void setFilterType(String filterType) {
            this.filterType = filterType;
        }

        @Override
        public final Builder filterType(String filterType) {
            this.filterType = filterType;
            return this;
        }

        @Override
        public final Builder filterType(FilterType filterType) {
            this.filterType(filterType == null ? null : filterType.toString());
            return this;
        }

        public final List<Filter.Builder> getFilterConfiguration() {
            List<Filter.Builder> result = FilterConfigurationCopier.copyToBuilder(this.filterConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterConfiguration(Collection<Filter.BuilderImpl> filterConfiguration) {
            this.filterConfiguration = FilterConfigurationCopier.copyFromBuilder(filterConfiguration);
        }

        @Override
        public final Builder filterConfiguration(Collection<Filter> filterConfiguration) {
            this.filterConfiguration = FilterConfigurationCopier.copy(filterConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterConfiguration(Filter... filterConfiguration) {
            filterConfiguration(Arrays.asList(filterConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterConfiguration(Consumer<Filter.Builder>... filterConfiguration) {
            filterConfiguration(Stream.of(filterConfiguration).map(c -> Filter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Action.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(Action.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(Action action) {
            this.action = action;
            return this;
        }

        public final Float getHoldbackPercentage() {
            return holdbackPercentage;
        }

        public final void setHoldbackPercentage(Float holdbackPercentage) {
            this.holdbackPercentage = holdbackPercentage;
        }

        @Override
        public final Builder holdbackPercentage(Float holdbackPercentage) {
            this.holdbackPercentage = holdbackPercentage;
            return this;
        }

        @Override
        public OpenRtbAttributeModuleParameters build() {
            return new OpenRtbAttributeModuleParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
