/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rum.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAppMonitorDataRequest extends RumRequest implements
        ToCopyableBuilder<GetAppMonitorDataRequest.Builder, GetAppMonitorDataRequest> {
    private static final SdkField<List<QueryFilter>> FILTERS_FIELD = SdkField
            .<List<QueryFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(GetAppMonitorDataRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueryFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueryFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetAppMonitorDataRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetAppMonitorDataRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetAppMonitorDataRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<TimeRange> TIME_RANGE_FIELD = SdkField.<TimeRange> builder(MarshallingType.SDK_POJO)
            .memberName("TimeRange").getter(getter(GetAppMonitorDataRequest::timeRange)).setter(setter(Builder::timeRange))
            .constructor(TimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            MAX_RESULTS_FIELD, NAME_FIELD, NEXT_TOKEN_FIELD, TIME_RANGE_FIELD));

    private final List<QueryFilter> filters;

    private final Integer maxResults;

    private final String name;

    private final String nextToken;

    private final TimeRange timeRange;

    private GetAppMonitorDataRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.name = builder.name;
        this.nextToken = builder.nextToken;
        this.timeRange = builder.timeRange;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures that you can use to filter the results to those that match one or more sets of key-value
     * pairs that you specify.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return An array of structures that you can use to filter the results to those that match one or more sets of
     *         key-value pairs that you specify.
     */
    public final List<QueryFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results to return in one operation.
     * </p>
     * 
     * @return The maximum number of results to return in one operation.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The name of the app monitor that collected the data that you want to retrieve.
     * </p>
     * 
     * @return The name of the app monitor that collected the data that you want to retrieve.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Use the token returned by the previous operation to request the next page of results.
     * </p>
     * 
     * @return Use the token returned by the previous operation to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A structure that defines the time range that you want to retrieve results from.
     * </p>
     * 
     * @return A structure that defines the time range that you want to retrieve results from.
     */
    public final TimeRange timeRange() {
        return timeRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(timeRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAppMonitorDataRequest)) {
            return false;
        }
        GetAppMonitorDataRequest other = (GetAppMonitorDataRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(name(), other.name())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(timeRange(), other.timeRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAppMonitorDataRequest").add("Filters", hasFilters() ? filters() : null)
                .add("MaxResults", maxResults()).add("Name", name()).add("NextToken", nextToken()).add("TimeRange", timeRange())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "TimeRange":
            return Optional.ofNullable(clazz.cast(timeRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAppMonitorDataRequest, T> g) {
        return obj -> g.apply((GetAppMonitorDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RumRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetAppMonitorDataRequest> {
        /**
         * <p>
         * An array of structures that you can use to filter the results to those that match one or more sets of
         * key-value pairs that you specify.
         * </p>
         * 
         * @param filters
         *        An array of structures that you can use to filter the results to those that match one or more sets of
         *        key-value pairs that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<QueryFilter> filters);

        /**
         * <p>
         * An array of structures that you can use to filter the results to those that match one or more sets of
         * key-value pairs that you specify.
         * </p>
         * 
         * @param filters
         *        An array of structures that you can use to filter the results to those that match one or more sets of
         *        key-value pairs that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(QueryFilter... filters);

        /**
         * <p>
         * An array of structures that you can use to filter the results to those that match one or more sets of
         * key-value pairs that you specify.
         * </p>
         * This is a convenience that creates an instance of the {@link List<QueryFilter>.Builder} avoiding the need to
         * create one manually via {@link List<QueryFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<QueryFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<QueryFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<QueryFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<QueryFilter>)
         */
        Builder filters(Consumer<QueryFilter.Builder>... filters);

        /**
         * <p>
         * The maximum number of results to return in one operation.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in one operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The name of the app monitor that collected the data that you want to retrieve.
         * </p>
         * 
         * @param name
         *        The name of the app monitor that collected the data that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Use the token returned by the previous operation to request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Use the token returned by the previous operation to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A structure that defines the time range that you want to retrieve results from.
         * </p>
         * 
         * @param timeRange
         *        A structure that defines the time range that you want to retrieve results from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRange(TimeRange timeRange);

        /**
         * <p>
         * A structure that defines the time range that you want to retrieve results from.
         * </p>
         * This is a convenience that creates an instance of the {@link TimeRange.Builder} avoiding the need to create
         * one manually via {@link TimeRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimeRange.Builder#build()} is called immediately and its result
         * is passed to {@link #timeRange(TimeRange)}.
         * 
         * @param timeRange
         *        a consumer that will call methods on {@link TimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeRange(TimeRange)
         */
        default Builder timeRange(Consumer<TimeRange.Builder> timeRange) {
            return timeRange(TimeRange.builder().applyMutation(timeRange).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RumRequest.BuilderImpl implements Builder {
        private List<QueryFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String name;

        private String nextToken;

        private TimeRange timeRange;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAppMonitorDataRequest model) {
            super(model);
            filters(model.filters);
            maxResults(model.maxResults);
            name(model.name);
            nextToken(model.nextToken);
            timeRange(model.timeRange);
        }

        public final List<QueryFilter.Builder> getFilters() {
            List<QueryFilter.Builder> result = QueryFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<QueryFilter.BuilderImpl> filters) {
            this.filters = QueryFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<QueryFilter> filters) {
            this.filters = QueryFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(QueryFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<QueryFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> QueryFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final TimeRange.Builder getTimeRange() {
            return timeRange != null ? timeRange.toBuilder() : null;
        }

        public final void setTimeRange(TimeRange.BuilderImpl timeRange) {
            this.timeRange = timeRange != null ? timeRange.build() : null;
        }

        @Override
        @Transient
        public final Builder timeRange(TimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAppMonitorDataRequest build() {
            return new GetAppMonitorDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
