/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rum.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that defines the time range that you want to retrieve results from.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeRange implements SdkPojo, Serializable, ToCopyableBuilder<TimeRange.Builder, TimeRange> {
    private static final SdkField<Long> AFTER_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("After")
            .getter(getter(TimeRange::after)).setter(setter(Builder::after))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("After").build()).build();

    private static final SdkField<Long> BEFORE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Before")
            .getter(getter(TimeRange::before)).setter(setter(Builder::before))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Before").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFTER_FIELD, BEFORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long after;

    private final Long before;

    private TimeRange(BuilderImpl builder) {
        this.after = builder.after;
        this.before = builder.before;
    }

    /**
     * <p>
     * The beginning of the time range to retrieve performance events from.
     * </p>
     * 
     * @return The beginning of the time range to retrieve performance events from.
     */
    public final Long after() {
        return after;
    }

    /**
     * <p>
     * The end of the time range to retrieve performance events from. If you omit this, the time range extends to the
     * time that this operation is performed.
     * </p>
     * 
     * @return The end of the time range to retrieve performance events from. If you omit this, the time range extends
     *         to the time that this operation is performed.
     */
    public final Long before() {
        return before;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(after());
        hashCode = 31 * hashCode + Objects.hashCode(before());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeRange)) {
            return false;
        }
        TimeRange other = (TimeRange) obj;
        return Objects.equals(after(), other.after()) && Objects.equals(before(), other.before());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeRange").add("After", after()).add("Before", before()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "After":
            return Optional.ofNullable(clazz.cast(after()));
        case "Before":
            return Optional.ofNullable(clazz.cast(before()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeRange, T> g) {
        return obj -> g.apply((TimeRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeRange> {
        /**
         * <p>
         * The beginning of the time range to retrieve performance events from.
         * </p>
         * 
         * @param after
         *        The beginning of the time range to retrieve performance events from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder after(Long after);

        /**
         * <p>
         * The end of the time range to retrieve performance events from. If you omit this, the time range extends to
         * the time that this operation is performed.
         * </p>
         * 
         * @param before
         *        The end of the time range to retrieve performance events from. If you omit this, the time range
         *        extends to the time that this operation is performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder before(Long before);
    }

    static final class BuilderImpl implements Builder {
        private Long after;

        private Long before;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeRange model) {
            after(model.after);
            before(model.before);
        }

        public final Long getAfter() {
            return after;
        }

        public final void setAfter(Long after) {
            this.after = after;
        }

        @Override
        @Transient
        public final Builder after(Long after) {
            this.after = after;
            return this;
        }

        public final Long getBefore() {
            return before;
        }

        public final void setBefore(Long before) {
            this.before = before;
        }

        @Override
        @Transient
        public final Builder before(Long before) {
            this.before = before;
            return this;
        }

        @Override
        public TimeRange build() {
            return new TimeRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
