/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteRumMetricDefinitionsRequest extends RumRequest implements
        ToCopyableBuilder<BatchDeleteRumMetricDefinitionsRequest.Builder, BatchDeleteRumMetricDefinitionsRequest> {
    private static final SdkField<String> APP_MONITOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppMonitorName").getter(getter(BatchDeleteRumMetricDefinitionsRequest::appMonitorName))
            .setter(setter(Builder::appMonitorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AppMonitorName").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Destination").getter(getter(BatchDeleteRumMetricDefinitionsRequest::destinationAsString))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("destination").build()).build();

    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationArn").getter(getter(BatchDeleteRumMetricDefinitionsRequest::destinationArn))
            .setter(setter(Builder::destinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("destinationArn").build())
            .build();

    private static final SdkField<List<String>> METRIC_DEFINITION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MetricDefinitionIds")
            .getter(getter(BatchDeleteRumMetricDefinitionsRequest::metricDefinitionIds))
            .setter(setter(Builder::metricDefinitionIds))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("metricDefinitionIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_MONITOR_NAME_FIELD,
            DESTINATION_FIELD, DESTINATION_ARN_FIELD, METRIC_DEFINITION_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appMonitorName;

    private final String destination;

    private final String destinationArn;

    private final List<String> metricDefinitionIds;

    private BatchDeleteRumMetricDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.appMonitorName = builder.appMonitorName;
        this.destination = builder.destination;
        this.destinationArn = builder.destinationArn;
        this.metricDefinitionIds = builder.metricDefinitionIds;
    }

    /**
     * <p>
     * The name of the CloudWatch RUM app monitor that is sending these metrics.
     * </p>
     * 
     * @return The name of the CloudWatch RUM app monitor that is sending these metrics.
     */
    public final String appMonitorName() {
        return appMonitorName;
    }

    /**
     * <p>
     * Defines the destination where you want to stop sending the specified metrics. Valid values are
     * <code>CloudWatch</code> and <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify
     * the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission
     * to write to the experiment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destination} will
     * return {@link MetricDestination#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #destinationAsString}.
     * </p>
     * 
     * @return Defines the destination where you want to stop sending the specified metrics. Valid values are
     *         <code>CloudWatch</code> and <code>Evidently</code>. If you specify <code>Evidently</code>, you must also
     *         specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that
     *         has permission to write to the experiment.
     * @see MetricDestination
     */
    public final MetricDestination destination() {
        return MetricDestination.fromValue(destination);
    }

    /**
     * <p>
     * Defines the destination where you want to stop sending the specified metrics. Valid values are
     * <code>CloudWatch</code> and <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify
     * the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission
     * to write to the experiment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destination} will
     * return {@link MetricDestination#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #destinationAsString}.
     * </p>
     * 
     * @return Defines the destination where you want to stop sending the specified metrics. Valid values are
     *         <code>CloudWatch</code> and <code>Evidently</code>. If you specify <code>Evidently</code>, you must also
     *         specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that
     *         has permission to write to the experiment.
     * @see MetricDestination
     */
    public final String destinationAsString() {
        return destination;
    }

    /**
     * <p>
     * This parameter is required if <code>Destination</code> is <code>Evidently</code>. If <code>Destination</code> is
     * <code>CloudWatch</code>, do not use this parameter.
     * </p>
     * <p>
     * This parameter specifies the ARN of the Evidently experiment that was receiving the metrics that are being
     * deleted.
     * </p>
     * 
     * @return This parameter is required if <code>Destination</code> is <code>Evidently</code>. If
     *         <code>Destination</code> is <code>CloudWatch</code>, do not use this parameter. </p>
     *         <p>
     *         This parameter specifies the ARN of the Evidently experiment that was receiving the metrics that are
     *         being deleted.
     */
    public final String destinationArn() {
        return destinationArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricDefinitionIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricDefinitionIds() {
        return metricDefinitionIds != null && !(metricDefinitionIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures which define the metrics that you want to stop sending.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricDefinitionIds} method.
     * </p>
     * 
     * @return An array of structures which define the metrics that you want to stop sending.
     */
    public final List<String> metricDefinitionIds() {
        return metricDefinitionIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appMonitorName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricDefinitionIds() ? metricDefinitionIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteRumMetricDefinitionsRequest)) {
            return false;
        }
        BatchDeleteRumMetricDefinitionsRequest other = (BatchDeleteRumMetricDefinitionsRequest) obj;
        return Objects.equals(appMonitorName(), other.appMonitorName())
                && Objects.equals(destinationAsString(), other.destinationAsString())
                && Objects.equals(destinationArn(), other.destinationArn())
                && hasMetricDefinitionIds() == other.hasMetricDefinitionIds()
                && Objects.equals(metricDefinitionIds(), other.metricDefinitionIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteRumMetricDefinitionsRequest").add("AppMonitorName", appMonitorName())
                .add("Destination", destinationAsString()).add("DestinationArn", destinationArn())
                .add("MetricDefinitionIds", hasMetricDefinitionIds() ? metricDefinitionIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppMonitorName":
            return Optional.ofNullable(clazz.cast(appMonitorName()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destinationAsString()));
        case "DestinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        case "MetricDefinitionIds":
            return Optional.ofNullable(clazz.cast(metricDefinitionIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppMonitorName", APP_MONITOR_NAME_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("destinationArn", DESTINATION_ARN_FIELD);
        map.put("metricDefinitionIds", METRIC_DEFINITION_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteRumMetricDefinitionsRequest, T> g) {
        return obj -> g.apply((BatchDeleteRumMetricDefinitionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RumRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDeleteRumMetricDefinitionsRequest> {
        /**
         * <p>
         * The name of the CloudWatch RUM app monitor that is sending these metrics.
         * </p>
         * 
         * @param appMonitorName
         *        The name of the CloudWatch RUM app monitor that is sending these metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appMonitorName(String appMonitorName);

        /**
         * <p>
         * Defines the destination where you want to stop sending the specified metrics. Valid values are
         * <code>CloudWatch</code> and <code>Evidently</code>. If you specify <code>Evidently</code>, you must also
         * specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has
         * permission to write to the experiment.
         * </p>
         * 
         * @param destination
         *        Defines the destination where you want to stop sending the specified metrics. Valid values are
         *        <code>CloudWatch</code> and <code>Evidently</code>. If you specify <code>Evidently</code>, you must
         *        also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM
         *        role that has permission to write to the experiment.
         * @see MetricDestination
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricDestination
         */
        Builder destination(String destination);

        /**
         * <p>
         * Defines the destination where you want to stop sending the specified metrics. Valid values are
         * <code>CloudWatch</code> and <code>Evidently</code>. If you specify <code>Evidently</code>, you must also
         * specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has
         * permission to write to the experiment.
         * </p>
         * 
         * @param destination
         *        Defines the destination where you want to stop sending the specified metrics. Valid values are
         *        <code>CloudWatch</code> and <code>Evidently</code>. If you specify <code>Evidently</code>, you must
         *        also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM
         *        role that has permission to write to the experiment.
         * @see MetricDestination
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricDestination
         */
        Builder destination(MetricDestination destination);

        /**
         * <p>
         * This parameter is required if <code>Destination</code> is <code>Evidently</code>. If <code>Destination</code>
         * is <code>CloudWatch</code>, do not use this parameter.
         * </p>
         * <p>
         * This parameter specifies the ARN of the Evidently experiment that was receiving the metrics that are being
         * deleted.
         * </p>
         * 
         * @param destinationArn
         *        This parameter is required if <code>Destination</code> is <code>Evidently</code>. If
         *        <code>Destination</code> is <code>CloudWatch</code>, do not use this parameter. </p>
         *        <p>
         *        This parameter specifies the ARN of the Evidently experiment that was receiving the metrics that are
         *        being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p>
         * An array of structures which define the metrics that you want to stop sending.
         * </p>
         * 
         * @param metricDefinitionIds
         *        An array of structures which define the metrics that you want to stop sending.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDefinitionIds(Collection<String> metricDefinitionIds);

        /**
         * <p>
         * An array of structures which define the metrics that you want to stop sending.
         * </p>
         * 
         * @param metricDefinitionIds
         *        An array of structures which define the metrics that you want to stop sending.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDefinitionIds(String... metricDefinitionIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RumRequest.BuilderImpl implements Builder {
        private String appMonitorName;

        private String destination;

        private String destinationArn;

        private List<String> metricDefinitionIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteRumMetricDefinitionsRequest model) {
            super(model);
            appMonitorName(model.appMonitorName);
            destination(model.destination);
            destinationArn(model.destinationArn);
            metricDefinitionIds(model.metricDefinitionIds);
        }

        public final String getAppMonitorName() {
            return appMonitorName;
        }

        public final void setAppMonitorName(String appMonitorName) {
            this.appMonitorName = appMonitorName;
        }

        @Override
        public final Builder appMonitorName(String appMonitorName) {
            this.appMonitorName = appMonitorName;
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public final Builder destination(MetricDestination destination) {
            this.destination(destination == null ? null : destination.toString());
            return this;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final Collection<String> getMetricDefinitionIds() {
            if (metricDefinitionIds instanceof SdkAutoConstructList) {
                return null;
            }
            return metricDefinitionIds;
        }

        public final void setMetricDefinitionIds(Collection<String> metricDefinitionIds) {
            this.metricDefinitionIds = MetricDefinitionIdsCopier.copy(metricDefinitionIds);
        }

        @Override
        public final Builder metricDefinitionIds(Collection<String> metricDefinitionIds) {
            this.metricDefinitionIds = MetricDefinitionIdsCopier.copy(metricDefinitionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDefinitionIds(String... metricDefinitionIds) {
            metricDefinitionIds(Arrays.asList(metricDefinitionIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteRumMetricDefinitionsRequest build() {
            return new BatchDeleteRumMetricDefinitionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
