/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteRumMetricDefinitionsResponse extends RumResponse implements
        ToCopyableBuilder<BatchDeleteRumMetricDefinitionsResponse.Builder, BatchDeleteRumMetricDefinitionsResponse> {
    private static final SdkField<List<BatchDeleteRumMetricDefinitionsError>> ERRORS_FIELD = SdkField
            .<List<BatchDeleteRumMetricDefinitionsError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(BatchDeleteRumMetricDefinitionsResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchDeleteRumMetricDefinitionsError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchDeleteRumMetricDefinitionsError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> METRIC_DEFINITION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MetricDefinitionIds")
            .getter(getter(BatchDeleteRumMetricDefinitionsResponse::metricDefinitionIds))
            .setter(setter(Builder::metricDefinitionIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDefinitionIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD,
            METRIC_DEFINITION_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BatchDeleteRumMetricDefinitionsError> errors;

    private final List<String> metricDefinitionIds;

    private BatchDeleteRumMetricDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.metricDefinitionIds = builder.metricDefinitionIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of error objects, if the operation caused any errors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return An array of error objects, if the operation caused any errors.
     */
    public final List<BatchDeleteRumMetricDefinitionsError> errors() {
        return errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricDefinitionIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricDefinitionIds() {
        return metricDefinitionIds != null && !(metricDefinitionIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the metric definitions that were deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricDefinitionIds} method.
     * </p>
     * 
     * @return The IDs of the metric definitions that were deleted.
     */
    public final List<String> metricDefinitionIds() {
        return metricDefinitionIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricDefinitionIds() ? metricDefinitionIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteRumMetricDefinitionsResponse)) {
            return false;
        }
        BatchDeleteRumMetricDefinitionsResponse other = (BatchDeleteRumMetricDefinitionsResponse) obj;
        return hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors())
                && hasMetricDefinitionIds() == other.hasMetricDefinitionIds()
                && Objects.equals(metricDefinitionIds(), other.metricDefinitionIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteRumMetricDefinitionsResponse").add("Errors", hasErrors() ? errors() : null)
                .add("MetricDefinitionIds", hasMetricDefinitionIds() ? metricDefinitionIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "MetricDefinitionIds":
            return Optional.ofNullable(clazz.cast(metricDefinitionIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Errors", ERRORS_FIELD);
        map.put("MetricDefinitionIds", METRIC_DEFINITION_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteRumMetricDefinitionsResponse, T> g) {
        return obj -> g.apply((BatchDeleteRumMetricDefinitionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RumResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDeleteRumMetricDefinitionsResponse> {
        /**
         * <p>
         * An array of error objects, if the operation caused any errors.
         * </p>
         * 
         * @param errors
         *        An array of error objects, if the operation caused any errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchDeleteRumMetricDefinitionsError> errors);

        /**
         * <p>
         * An array of error objects, if the operation caused any errors.
         * </p>
         * 
         * @param errors
         *        An array of error objects, if the operation caused any errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchDeleteRumMetricDefinitionsError... errors);

        /**
         * <p>
         * An array of error objects, if the operation caused any errors.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rum.model.BatchDeleteRumMetricDefinitionsError.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.rum.model.BatchDeleteRumMetricDefinitionsError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rum.model.BatchDeleteRumMetricDefinitionsError.Builder#build()} is
         * called immediately and its result is passed to {@link #errors(List<BatchDeleteRumMetricDefinitionsError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rum.model.BatchDeleteRumMetricDefinitionsError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchDeleteRumMetricDefinitionsError>)
         */
        Builder errors(Consumer<BatchDeleteRumMetricDefinitionsError.Builder>... errors);

        /**
         * <p>
         * The IDs of the metric definitions that were deleted.
         * </p>
         * 
         * @param metricDefinitionIds
         *        The IDs of the metric definitions that were deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDefinitionIds(Collection<String> metricDefinitionIds);

        /**
         * <p>
         * The IDs of the metric definitions that were deleted.
         * </p>
         * 
         * @param metricDefinitionIds
         *        The IDs of the metric definitions that were deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDefinitionIds(String... metricDefinitionIds);
    }

    static final class BuilderImpl extends RumResponse.BuilderImpl implements Builder {
        private List<BatchDeleteRumMetricDefinitionsError> errors = DefaultSdkAutoConstructList.getInstance();

        private List<String> metricDefinitionIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteRumMetricDefinitionsResponse model) {
            super(model);
            errors(model.errors);
            metricDefinitionIds(model.metricDefinitionIds);
        }

        public final List<BatchDeleteRumMetricDefinitionsError.Builder> getErrors() {
            List<BatchDeleteRumMetricDefinitionsError.Builder> result = BatchDeleteRumMetricDefinitionsErrorsCopier
                    .copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchDeleteRumMetricDefinitionsError.BuilderImpl> errors) {
            this.errors = BatchDeleteRumMetricDefinitionsErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchDeleteRumMetricDefinitionsError> errors) {
            this.errors = BatchDeleteRumMetricDefinitionsErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchDeleteRumMetricDefinitionsError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchDeleteRumMetricDefinitionsError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchDeleteRumMetricDefinitionsError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getMetricDefinitionIds() {
            if (metricDefinitionIds instanceof SdkAutoConstructList) {
                return null;
            }
            return metricDefinitionIds;
        }

        public final void setMetricDefinitionIds(Collection<String> metricDefinitionIds) {
            this.metricDefinitionIds = MetricDefinitionIdsCopier.copy(metricDefinitionIds);
        }

        @Override
        public final Builder metricDefinitionIds(Collection<String> metricDefinitionIds) {
            this.metricDefinitionIds = MetricDefinitionIdsCopier.copy(metricDefinitionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDefinitionIds(String... metricDefinitionIds) {
            metricDefinitionIds(Arrays.asList(metricDefinitionIds));
            return this;
        }

        @Override
        public BatchDeleteRumMetricDefinitionsResponse build() {
            return new BatchDeleteRumMetricDefinitionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
