/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rum.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that includes some data about app monitors and their settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppMonitorSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AppMonitorSummary.Builder, AppMonitorSummary> {
    private static final SdkField<String> CREATED_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Created")
            .getter(getter(AppMonitorSummary::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(AppMonitorSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> LAST_MODIFIED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModified").getter(getter(AppMonitorSummary::lastModified)).setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AppMonitorSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(AppMonitorSummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_FIELD, ID_FIELD,
            LAST_MODIFIED_FIELD, NAME_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String created;

    private final String id;

    private final String lastModified;

    private final String name;

    private final String state;

    private AppMonitorSummary(BuilderImpl builder) {
        this.created = builder.created;
        this.id = builder.id;
        this.lastModified = builder.lastModified;
        this.name = builder.name;
        this.state = builder.state;
    }

    /**
     * <p>
     * The date and time that the app monitor was created.
     * </p>
     * 
     * @return The date and time that the app monitor was created.
     */
    public final String created() {
        return created;
    }

    /**
     * <p>
     * The unique ID of this app monitor.
     * </p>
     * 
     * @return The unique ID of this app monitor.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The date and time of the most recent changes to this app monitor's configuration.
     * </p>
     * 
     * @return The date and time of the most recent changes to this app monitor's configuration.
     */
    public final String lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * The name of this app monitor.
     * </p>
     * 
     * @return The name of this app monitor.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The current state of this app monitor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link StateEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of this app monitor.
     * @see StateEnum
     */
    public final StateEnum state() {
        return StateEnum.fromValue(state);
    }

    /**
     * <p>
     * The current state of this app monitor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link StateEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of this app monitor.
     * @see StateEnum
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppMonitorSummary)) {
            return false;
        }
        AppMonitorSummary other = (AppMonitorSummary) obj;
        return Objects.equals(created(), other.created()) && Objects.equals(id(), other.id())
                && Objects.equals(lastModified(), other.lastModified()) && Objects.equals(name(), other.name())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppMonitorSummary").add("Created", created()).add("Id", id())
                .add("LastModified", lastModified()).add("Name", name()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Created":
            return Optional.ofNullable(clazz.cast(created()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Created", CREATED_FIELD);
        map.put("Id", ID_FIELD);
        map.put("LastModified", LAST_MODIFIED_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppMonitorSummary, T> g) {
        return obj -> g.apply((AppMonitorSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppMonitorSummary> {
        /**
         * <p>
         * The date and time that the app monitor was created.
         * </p>
         * 
         * @param created
         *        The date and time that the app monitor was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(String created);

        /**
         * <p>
         * The unique ID of this app monitor.
         * </p>
         * 
         * @param id
         *        The unique ID of this app monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The date and time of the most recent changes to this app monitor's configuration.
         * </p>
         * 
         * @param lastModified
         *        The date and time of the most recent changes to this app monitor's configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(String lastModified);

        /**
         * <p>
         * The name of this app monitor.
         * </p>
         * 
         * @param name
         *        The name of this app monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current state of this app monitor.
         * </p>
         * 
         * @param state
         *        The current state of this app monitor.
         * @see StateEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateEnum
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of this app monitor.
         * </p>
         * 
         * @param state
         *        The current state of this app monitor.
         * @see StateEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateEnum
         */
        Builder state(StateEnum state);
    }

    static final class BuilderImpl implements Builder {
        private String created;

        private String id;

        private String lastModified;

        private String name;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(AppMonitorSummary model) {
            created(model.created);
            id(model.id);
            lastModified(model.lastModified);
            name(model.name);
            state(model.state);
        }

        public final String getCreated() {
            return created;
        }

        public final void setCreated(String created) {
            this.created = created;
        }

        @Override
        public final Builder created(String created) {
            this.created = created;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLastModified() {
            return lastModified;
        }

        public final void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(String lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(StateEnum state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public AppMonitorSummary build() {
            return new AppMonitorSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
