/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutResourcePolicyRequest extends RumRequest implements
        ToCopyableBuilder<PutResourcePolicyRequest.Builder, PutResourcePolicyRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PutResourcePolicyRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()).build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyDocument").getter(getter(PutResourcePolicyRequest::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").build()).build();

    private static final SdkField<String> POLICY_REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyRevisionId").getter(getter(PutResourcePolicyRequest::policyRevisionId))
            .setter(setter(Builder::policyRevisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyRevisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            POLICY_DOCUMENT_FIELD, POLICY_REVISION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String policyDocument;

    private final String policyRevisionId;

    private PutResourcePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.policyDocument = builder.policyDocument;
        this.policyRevisionId = builder.policyRevisionId;
    }

    /**
     * <p>
     * The name of the app monitor that you want to apply this resource-based policy to. To find the names of your app
     * monitors, you can use the <a
     * href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_ListAppMonitors.html">ListAppMonitors</a>
     * operation.
     * </p>
     * 
     * @return The name of the app monitor that you want to apply this resource-based policy to. To find the names of
     *         your app monitors, you can use the <a
     *         href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_ListAppMonitors.html"
     *         >ListAppMonitors</a> operation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The JSON to use as the resource policy. The document can be up to 4 KB in size. For more information about the
     * contents and syntax for this policy, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-resource-policies.html">Using
     * resource-based policies with CloudWatch RUM</a>.
     * </p>
     * 
     * @return The JSON to use as the resource policy. The document can be up to 4 KB in size. For more information
     *         about the contents and syntax for this policy, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-resource-policies.html"
     *         >Using resource-based policies with CloudWatch RUM</a>.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * A string value that you can use to conditionally update your policy. You can provide the revision ID of your
     * existing policy to make mutating requests against that policy.
     * </p>
     * <p>
     * When you assign a policy revision ID, then later requests about that policy will be rejected with an
     * <code>InvalidPolicyRevisionIdException</code> error if they don't provide the correct current revision ID.
     * </p>
     * 
     * @return A string value that you can use to conditionally update your policy. You can provide the revision ID of
     *         your existing policy to make mutating requests against that policy.</p>
     *         <p>
     *         When you assign a policy revision ID, then later requests about that policy will be rejected with an
     *         <code>InvalidPolicyRevisionIdException</code> error if they don't provide the correct current revision
     *         ID.
     */
    public final String policyRevisionId() {
        return policyRevisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(policyRevisionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResourcePolicyRequest)) {
            return false;
        }
        PutResourcePolicyRequest other = (PutResourcePolicyRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(policyDocument(), other.policyDocument())
                && Objects.equals(policyRevisionId(), other.policyRevisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutResourcePolicyRequest").add("Name", name()).add("PolicyDocument", policyDocument())
                .add("PolicyRevisionId", policyRevisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PolicyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        case "PolicyRevisionId":
            return Optional.ofNullable(clazz.cast(policyRevisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("PolicyDocument", POLICY_DOCUMENT_FIELD);
        map.put("PolicyRevisionId", POLICY_REVISION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutResourcePolicyRequest, T> g) {
        return obj -> g.apply((PutResourcePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RumRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutResourcePolicyRequest> {
        /**
         * <p>
         * The name of the app monitor that you want to apply this resource-based policy to. To find the names of your
         * app monitors, you can use the <a
         * href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_ListAppMonitors.html"
         * >ListAppMonitors</a> operation.
         * </p>
         * 
         * @param name
         *        The name of the app monitor that you want to apply this resource-based policy to. To find the names of
         *        your app monitors, you can use the <a
         *        href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_ListAppMonitors.html"
         *        >ListAppMonitors</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The JSON to use as the resource policy. The document can be up to 4 KB in size. For more information about
         * the contents and syntax for this policy, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-resource-policies.html"
         * >Using resource-based policies with CloudWatch RUM</a>.
         * </p>
         * 
         * @param policyDocument
         *        The JSON to use as the resource policy. The document can be up to 4 KB in size. For more information
         *        about the contents and syntax for this policy, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-resource-policies.html"
         *        >Using resource-based policies with CloudWatch RUM</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * A string value that you can use to conditionally update your policy. You can provide the revision ID of your
         * existing policy to make mutating requests against that policy.
         * </p>
         * <p>
         * When you assign a policy revision ID, then later requests about that policy will be rejected with an
         * <code>InvalidPolicyRevisionIdException</code> error if they don't provide the correct current revision ID.
         * </p>
         * 
         * @param policyRevisionId
         *        A string value that you can use to conditionally update your policy. You can provide the revision ID
         *        of your existing policy to make mutating requests against that policy.</p>
         *        <p>
         *        When you assign a policy revision ID, then later requests about that policy will be rejected with an
         *        <code>InvalidPolicyRevisionIdException</code> error if they don't provide the correct current revision
         *        ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyRevisionId(String policyRevisionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RumRequest.BuilderImpl implements Builder {
        private String name;

        private String policyDocument;

        private String policyRevisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResourcePolicyRequest model) {
            super(model);
            name(model.name);
            policyDocument(model.policyDocument);
            policyRevisionId(model.policyRevisionId);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final String getPolicyRevisionId() {
            return policyRevisionId;
        }

        public final void setPolicyRevisionId(String policyRevisionId) {
            this.policyRevisionId = policyRevisionId;
        }

        @Override
        public final Builder policyRevisionId(String policyRevisionId) {
            this.policyRevisionId = policyRevisionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutResourcePolicyRequest build() {
            return new PutResourcePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
