/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRumEventsRequest extends RumRequest implements
        ToCopyableBuilder<PutRumEventsRequest.Builder, PutRumEventsRequest> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(PutRumEventsRequest::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final SdkField<AppMonitorDetails> APP_MONITOR_DETAILS_FIELD = SdkField
            .<AppMonitorDetails> builder(MarshallingType.SDK_POJO).memberName("AppMonitorDetails")
            .getter(getter(PutRumEventsRequest::appMonitorDetails)).setter(setter(Builder::appMonitorDetails))
            .constructor(AppMonitorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppMonitorDetails").build()).build();

    private static final SdkField<String> BATCH_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BatchId").getter(getter(PutRumEventsRequest::batchId)).setter(setter(Builder::batchId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(PutRumEventsRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()).build();

    private static final SdkField<List<RumEvent>> RUM_EVENTS_FIELD = SdkField
            .<List<RumEvent>> builder(MarshallingType.LIST)
            .memberName("RumEvents")
            .getter(getter(PutRumEventsRequest::rumEvents))
            .setter(setter(Builder::rumEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RumEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RumEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(RumEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<UserDetails> USER_DETAILS_FIELD = SdkField.<UserDetails> builder(MarshallingType.SDK_POJO)
            .memberName("UserDetails").getter(getter(PutRumEventsRequest::userDetails)).setter(setter(Builder::userDetails))
            .constructor(UserDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD,
            APP_MONITOR_DETAILS_FIELD, BATCH_ID_FIELD, ID_FIELD, RUM_EVENTS_FIELD, USER_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String alias;

    private final AppMonitorDetails appMonitorDetails;

    private final String batchId;

    private final String id;

    private final List<RumEvent> rumEvents;

    private final UserDetails userDetails;

    private PutRumEventsRequest(BuilderImpl builder) {
        super(builder);
        this.alias = builder.alias;
        this.appMonitorDetails = builder.appMonitorDetails;
        this.batchId = builder.batchId;
        this.id = builder.id;
        this.rumEvents = builder.rumEvents;
        this.userDetails = builder.userDetails;
    }

    /**
     * <p>
     * If the app monitor uses a resource-based policy that requires <code>PutRumEvents</code> requests to specify a
     * certain alias, specify that alias here. This alias will be compared to the <code>rum:alias</code> context key in
     * the resource-based policy. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-resource-policies.html">Using
     * resource-based policies with CloudWatch RUM</a>.
     * </p>
     * 
     * @return If the app monitor uses a resource-based policy that requires <code>PutRumEvents</code> requests to
     *         specify a certain alias, specify that alias here. This alias will be compared to the
     *         <code>rum:alias</code> context key in the resource-based policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-resource-policies.html"
     *         >Using resource-based policies with CloudWatch RUM</a>.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * A structure that contains information about the app monitor that collected this telemetry information.
     * </p>
     * 
     * @return A structure that contains information about the app monitor that collected this telemetry information.
     */
    public final AppMonitorDetails appMonitorDetails() {
        return appMonitorDetails;
    }

    /**
     * <p>
     * A unique identifier for this batch of RUM event data.
     * </p>
     * 
     * @return A unique identifier for this batch of RUM event data.
     */
    public final String batchId() {
        return batchId;
    }

    /**
     * <p>
     * The ID of the app monitor that is sending this data.
     * </p>
     * 
     * @return The ID of the app monitor that is sending this data.
     */
    public final String id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the RumEvents property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRumEvents() {
        return rumEvents != null && !(rumEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures that contain the telemetry event data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRumEvents} method.
     * </p>
     * 
     * @return An array of structures that contain the telemetry event data.
     */
    public final List<RumEvent> rumEvents() {
        return rumEvents;
    }

    /**
     * <p>
     * A structure that contains information about the user session that this batch of events was collected from.
     * </p>
     * 
     * @return A structure that contains information about the user session that this batch of events was collected
     *         from.
     */
    public final UserDetails userDetails() {
        return userDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(appMonitorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(batchId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasRumEvents() ? rumEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRumEventsRequest)) {
            return false;
        }
        PutRumEventsRequest other = (PutRumEventsRequest) obj;
        return Objects.equals(alias(), other.alias()) && Objects.equals(appMonitorDetails(), other.appMonitorDetails())
                && Objects.equals(batchId(), other.batchId()) && Objects.equals(id(), other.id())
                && hasRumEvents() == other.hasRumEvents() && Objects.equals(rumEvents(), other.rumEvents())
                && Objects.equals(userDetails(), other.userDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRumEventsRequest").add("Alias", alias()).add("AppMonitorDetails", appMonitorDetails())
                .add("BatchId", batchId()).add("Id", id()).add("RumEvents", hasRumEvents() ? rumEvents() : null)
                .add("UserDetails", userDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "AppMonitorDetails":
            return Optional.ofNullable(clazz.cast(appMonitorDetails()));
        case "BatchId":
            return Optional.ofNullable(clazz.cast(batchId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "RumEvents":
            return Optional.ofNullable(clazz.cast(rumEvents()));
        case "UserDetails":
            return Optional.ofNullable(clazz.cast(userDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Alias", ALIAS_FIELD);
        map.put("AppMonitorDetails", APP_MONITOR_DETAILS_FIELD);
        map.put("BatchId", BATCH_ID_FIELD);
        map.put("Id", ID_FIELD);
        map.put("RumEvents", RUM_EVENTS_FIELD);
        map.put("UserDetails", USER_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRumEventsRequest, T> g) {
        return obj -> g.apply((PutRumEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RumRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutRumEventsRequest> {
        /**
         * <p>
         * If the app monitor uses a resource-based policy that requires <code>PutRumEvents</code> requests to specify a
         * certain alias, specify that alias here. This alias will be compared to the <code>rum:alias</code> context key
         * in the resource-based policy. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-resource-policies.html"
         * >Using resource-based policies with CloudWatch RUM</a>.
         * </p>
         * 
         * @param alias
         *        If the app monitor uses a resource-based policy that requires <code>PutRumEvents</code> requests to
         *        specify a certain alias, specify that alias here. This alias will be compared to the
         *        <code>rum:alias</code> context key in the resource-based policy. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-resource-policies.html"
         *        >Using resource-based policies with CloudWatch RUM</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * A structure that contains information about the app monitor that collected this telemetry information.
         * </p>
         * 
         * @param appMonitorDetails
         *        A structure that contains information about the app monitor that collected this telemetry information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appMonitorDetails(AppMonitorDetails appMonitorDetails);

        /**
         * <p>
         * A structure that contains information about the app monitor that collected this telemetry information.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppMonitorDetails.Builder} avoiding the
         * need to create one manually via {@link AppMonitorDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppMonitorDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #appMonitorDetails(AppMonitorDetails)}.
         * 
         * @param appMonitorDetails
         *        a consumer that will call methods on {@link AppMonitorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appMonitorDetails(AppMonitorDetails)
         */
        default Builder appMonitorDetails(Consumer<AppMonitorDetails.Builder> appMonitorDetails) {
            return appMonitorDetails(AppMonitorDetails.builder().applyMutation(appMonitorDetails).build());
        }

        /**
         * <p>
         * A unique identifier for this batch of RUM event data.
         * </p>
         * 
         * @param batchId
         *        A unique identifier for this batch of RUM event data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchId(String batchId);

        /**
         * <p>
         * The ID of the app monitor that is sending this data.
         * </p>
         * 
         * @param id
         *        The ID of the app monitor that is sending this data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * An array of structures that contain the telemetry event data.
         * </p>
         * 
         * @param rumEvents
         *        An array of structures that contain the telemetry event data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rumEvents(Collection<RumEvent> rumEvents);

        /**
         * <p>
         * An array of structures that contain the telemetry event data.
         * </p>
         * 
         * @param rumEvents
         *        An array of structures that contain the telemetry event data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rumEvents(RumEvent... rumEvents);

        /**
         * <p>
         * An array of structures that contain the telemetry event data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rum.model.RumEvent.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.rum.model.RumEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rum.model.RumEvent.Builder#build()} is called immediately and its
         * result is passed to {@link #rumEvents(List<RumEvent>)}.
         * 
         * @param rumEvents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rum.model.RumEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rumEvents(java.util.Collection<RumEvent>)
         */
        Builder rumEvents(Consumer<RumEvent.Builder>... rumEvents);

        /**
         * <p>
         * A structure that contains information about the user session that this batch of events was collected from.
         * </p>
         * 
         * @param userDetails
         *        A structure that contains information about the user session that this batch of events was collected
         *        from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userDetails(UserDetails userDetails);

        /**
         * <p>
         * A structure that contains information about the user session that this batch of events was collected from.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserDetails.Builder} avoiding the need to
         * create one manually via {@link UserDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserDetails.Builder#build()} is called immediately and its result
         * is passed to {@link #userDetails(UserDetails)}.
         * 
         * @param userDetails
         *        a consumer that will call methods on {@link UserDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userDetails(UserDetails)
         */
        default Builder userDetails(Consumer<UserDetails.Builder> userDetails) {
            return userDetails(UserDetails.builder().applyMutation(userDetails).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RumRequest.BuilderImpl implements Builder {
        private String alias;

        private AppMonitorDetails appMonitorDetails;

        private String batchId;

        private String id;

        private List<RumEvent> rumEvents = DefaultSdkAutoConstructList.getInstance();

        private UserDetails userDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRumEventsRequest model) {
            super(model);
            alias(model.alias);
            appMonitorDetails(model.appMonitorDetails);
            batchId(model.batchId);
            id(model.id);
            rumEvents(model.rumEvents);
            userDetails(model.userDetails);
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final AppMonitorDetails.Builder getAppMonitorDetails() {
            return appMonitorDetails != null ? appMonitorDetails.toBuilder() : null;
        }

        public final void setAppMonitorDetails(AppMonitorDetails.BuilderImpl appMonitorDetails) {
            this.appMonitorDetails = appMonitorDetails != null ? appMonitorDetails.build() : null;
        }

        @Override
        public final Builder appMonitorDetails(AppMonitorDetails appMonitorDetails) {
            this.appMonitorDetails = appMonitorDetails;
            return this;
        }

        public final String getBatchId() {
            return batchId;
        }

        public final void setBatchId(String batchId) {
            this.batchId = batchId;
        }

        @Override
        public final Builder batchId(String batchId) {
            this.batchId = batchId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<RumEvent.Builder> getRumEvents() {
            List<RumEvent.Builder> result = RumEventListCopier.copyToBuilder(this.rumEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRumEvents(Collection<RumEvent.BuilderImpl> rumEvents) {
            this.rumEvents = RumEventListCopier.copyFromBuilder(rumEvents);
        }

        @Override
        public final Builder rumEvents(Collection<RumEvent> rumEvents) {
            this.rumEvents = RumEventListCopier.copy(rumEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rumEvents(RumEvent... rumEvents) {
            rumEvents(Arrays.asList(rumEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rumEvents(Consumer<RumEvent.Builder>... rumEvents) {
            rumEvents(Stream.of(rumEvents).map(c -> RumEvent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final UserDetails.Builder getUserDetails() {
            return userDetails != null ? userDetails.toBuilder() : null;
        }

        public final void setUserDetails(UserDetails.BuilderImpl userDetails) {
            this.userDetails = userDetails != null ? userDetails.build() : null;
        }

        @Override
        public final Builder userDetails(UserDetails userDetails) {
            this.userDetails = userDetails;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRumEventsRequest build() {
            return new PutRumEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
