/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rum.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the information for one performance event that RUM collects from a user session with your
 * application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RumEvent implements SdkPojo, Serializable, ToCopyableBuilder<RumEvent.Builder, RumEvent> {
    private static final SdkField<String> DETAILS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("details")
            .getter(getter(RumEvent::details))
            .setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(RumEvent::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> METADATA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("metadata")
            .getter(getter(RumEvent::metadata))
            .setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("timestamp").getter(getter(RumEvent::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(RumEvent::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILS_FIELD, ID_FIELD,
            METADATA_FIELD, TIMESTAMP_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String details;

    private final String id;

    private final String metadata;

    private final Instant timestamp;

    private final String type;

    private RumEvent(BuilderImpl builder) {
        this.details = builder.details;
        this.id = builder.id;
        this.metadata = builder.metadata;
        this.timestamp = builder.timestamp;
        this.type = builder.type;
    }

    /**
     * <p>
     * A string containing details about the event.
     * </p>
     * 
     * @return A string containing details about the event.
     */
    public final String details() {
        return details;
    }

    /**
     * <p>
     * A unique ID for this event.
     * </p>
     * 
     * @return A unique ID for this event.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Metadata about this event, which contains a JSON serialization of the identity of the user for this session. The
     * user information comes from information such as the HTTP user-agent request header and document interface.
     * </p>
     * 
     * @return Metadata about this event, which contains a JSON serialization of the identity of the user for this
     *         session. The user information comes from information such as the HTTP user-agent request header and
     *         document interface.
     */
    public final String metadata() {
        return metadata;
    }

    /**
     * <p>
     * The exact time that this event occurred.
     * </p>
     * 
     * @return The exact time that this event occurred.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The JSON schema that denotes the type of event this is, such as a page load or a new session.
     * </p>
     * 
     * @return The JSON schema that denotes the type of event this is, such as a page load or a new session.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RumEvent)) {
            return false;
        }
        RumEvent other = (RumEvent) obj;
        return Objects.equals(details(), other.details()) && Objects.equals(id(), other.id())
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RumEvent").add("Details", details()).add("Id", id()).add("Metadata", metadata())
                .add("Timestamp", timestamp()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("details", DETAILS_FIELD);
        map.put("id", ID_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RumEvent, T> g) {
        return obj -> g.apply((RumEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RumEvent> {
        /**
         * <p>
         * A string containing details about the event.
         * </p>
         * 
         * @param details
         *        A string containing details about the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(String details);

        /**
         * <p>
         * A unique ID for this event.
         * </p>
         * 
         * @param id
         *        A unique ID for this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Metadata about this event, which contains a JSON serialization of the identity of the user for this session.
         * The user information comes from information such as the HTTP user-agent request header and document
         * interface.
         * </p>
         * 
         * @param metadata
         *        Metadata about this event, which contains a JSON serialization of the identity of the user for this
         *        session. The user information comes from information such as the HTTP user-agent request header and
         *        document interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);

        /**
         * <p>
         * The exact time that this event occurred.
         * </p>
         * 
         * @param timestamp
         *        The exact time that this event occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The JSON schema that denotes the type of event this is, such as a page load or a new session.
         * </p>
         * 
         * @param type
         *        The JSON schema that denotes the type of event this is, such as a page load or a new session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String details;

        private String id;

        private String metadata;

        private Instant timestamp;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RumEvent model) {
            details(model.details);
            id(model.id);
            metadata(model.metadata);
            timestamp(model.timestamp);
            type(model.type);
        }

        public final String getDetails() {
            return details;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMetadata() {
            return metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public RumEvent build() {
            return new RumEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
