/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAppMonitorRequest extends RumRequest implements
        ToCopyableBuilder<UpdateAppMonitorRequest.Builder, UpdateAppMonitorRequest> {
    private static final SdkField<AppMonitorConfiguration> APP_MONITOR_CONFIGURATION_FIELD = SdkField
            .<AppMonitorConfiguration> builder(MarshallingType.SDK_POJO).memberName("AppMonitorConfiguration")
            .getter(getter(UpdateAppMonitorRequest::appMonitorConfiguration)).setter(setter(Builder::appMonitorConfiguration))
            .constructor(AppMonitorConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppMonitorConfiguration").build())
            .build();

    private static final SdkField<CustomEvents> CUSTOM_EVENTS_FIELD = SdkField.<CustomEvents> builder(MarshallingType.SDK_POJO)
            .memberName("CustomEvents").getter(getter(UpdateAppMonitorRequest::customEvents))
            .setter(setter(Builder::customEvents)).constructor(CustomEvents::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEvents").build()).build();

    private static final SdkField<Boolean> CW_LOG_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CwLogEnabled").getter(getter(UpdateAppMonitorRequest::cwLogEnabled))
            .setter(setter(Builder::cwLogEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CwLogEnabled").build()).build();

    private static final SdkField<DeobfuscationConfiguration> DEOBFUSCATION_CONFIGURATION_FIELD = SdkField
            .<DeobfuscationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("DeobfuscationConfiguration")
            .getter(getter(UpdateAppMonitorRequest::deobfuscationConfiguration))
            .setter(setter(Builder::deobfuscationConfiguration))
            .constructor(DeobfuscationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeobfuscationConfiguration").build())
            .build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(UpdateAppMonitorRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<List<String>> DOMAIN_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DomainList")
            .getter(getter(UpdateAppMonitorRequest::domainList))
            .setter(setter(Builder::domainList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateAppMonitorRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APP_MONITOR_CONFIGURATION_FIELD, CUSTOM_EVENTS_FIELD, CW_LOG_ENABLED_FIELD, DEOBFUSCATION_CONFIGURATION_FIELD,
            DOMAIN_FIELD, DOMAIN_LIST_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AppMonitorConfiguration appMonitorConfiguration;

    private final CustomEvents customEvents;

    private final Boolean cwLogEnabled;

    private final DeobfuscationConfiguration deobfuscationConfiguration;

    private final String domain;

    private final List<String> domainList;

    private final String name;

    private UpdateAppMonitorRequest(BuilderImpl builder) {
        super(builder);
        this.appMonitorConfiguration = builder.appMonitorConfiguration;
        this.customEvents = builder.customEvents;
        this.cwLogEnabled = builder.cwLogEnabled;
        this.deobfuscationConfiguration = builder.deobfuscationConfiguration;
        this.domain = builder.domain;
        this.domainList = builder.domainList;
        this.name = builder.name;
    }

    /**
     * <p>
     * A structure that contains much of the configuration data for the app monitor. If you are using Amazon Cognito for
     * authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito
     * identity pool to use for authorization. If you don't include <code>AppMonitorConfiguration</code>, you must set
     * up your own authorization method. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html"
     * >Authorize your application to send data to Amazon Web Services</a>.
     * </p>
     * 
     * @return A structure that contains much of the configuration data for the app monitor. If you are using Amazon
     *         Cognito for authorization, you must include this structure in your request, and it must include the ID of
     *         the Amazon Cognito identity pool to use for authorization. If you don't include
     *         <code>AppMonitorConfiguration</code>, you must set up your own authorization method. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html"
     *         >Authorize your application to send data to Amazon Web Services</a>.
     */
    public final AppMonitorConfiguration appMonitorConfiguration() {
        return appMonitorConfiguration;
    }

    /**
     * <p>
     * Specifies whether this app monitor allows the web client to define and send custom events. The default is for
     * custom events to be <code>DISABLED</code>.
     * </p>
     * <p>
     * For more information about custom events, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-custom-events.html">Send
     * custom events</a>.
     * </p>
     * 
     * @return Specifies whether this app monitor allows the web client to define and send custom events. The default is
     *         for custom events to be <code>DISABLED</code>.</p>
     *         <p>
     *         For more information about custom events, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-custom-events.html"
     *         >Send custom events</a>.
     */
    public final CustomEvents customEvents() {
        return customEvents;
    }

    /**
     * <p>
     * Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM sends a
     * copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry
     * data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.
     * </p>
     * 
     * @return Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM
     *         sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep
     *         the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.
     */
    public final Boolean cwLogEnabled() {
        return cwLogEnabled;
    }

    /**
     * <p>
     * A structure that contains the configuration for how an app monitor can deobfuscate stack traces.
     * </p>
     * 
     * @return A structure that contains the configuration for how an app monitor can deobfuscate stack traces.
     */
    public final DeobfuscationConfiguration deobfuscationConfiguration() {
        return deobfuscationConfiguration;
    }

    /**
     * <p>
     * The top-level internet domain name for which your application has administrative authority.
     * </p>
     * 
     * @return The top-level internet domain name for which your application has administrative authority.
     */
    public final String domain() {
        return domain;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDomainList() {
        return domainList != null && !(domainList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List the domain names for which your application has administrative authority. The <code>UpdateAppMonitor</code>
     * allows either the domain or the domain list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainList} method.
     * </p>
     * 
     * @return List the domain names for which your application has administrative authority. The
     *         <code>UpdateAppMonitor</code> allows either the domain or the domain list.
     */
    public final List<String> domainList() {
        return domainList;
    }

    /**
     * <p>
     * The name of the app monitor to update.
     * </p>
     * 
     * @return The name of the app monitor to update.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appMonitorConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(customEvents());
        hashCode = 31 * hashCode + Objects.hashCode(cwLogEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(deobfuscationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainList() ? domainList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppMonitorRequest)) {
            return false;
        }
        UpdateAppMonitorRequest other = (UpdateAppMonitorRequest) obj;
        return Objects.equals(appMonitorConfiguration(), other.appMonitorConfiguration())
                && Objects.equals(customEvents(), other.customEvents()) && Objects.equals(cwLogEnabled(), other.cwLogEnabled())
                && Objects.equals(deobfuscationConfiguration(), other.deobfuscationConfiguration())
                && Objects.equals(domain(), other.domain()) && hasDomainList() == other.hasDomainList()
                && Objects.equals(domainList(), other.domainList()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAppMonitorRequest").add("AppMonitorConfiguration", appMonitorConfiguration())
                .add("CustomEvents", customEvents()).add("CwLogEnabled", cwLogEnabled())
                .add("DeobfuscationConfiguration", deobfuscationConfiguration()).add("Domain", domain())
                .add("DomainList", hasDomainList() ? domainList() : null).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppMonitorConfiguration":
            return Optional.ofNullable(clazz.cast(appMonitorConfiguration()));
        case "CustomEvents":
            return Optional.ofNullable(clazz.cast(customEvents()));
        case "CwLogEnabled":
            return Optional.ofNullable(clazz.cast(cwLogEnabled()));
        case "DeobfuscationConfiguration":
            return Optional.ofNullable(clazz.cast(deobfuscationConfiguration()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "DomainList":
            return Optional.ofNullable(clazz.cast(domainList()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppMonitorConfiguration", APP_MONITOR_CONFIGURATION_FIELD);
        map.put("CustomEvents", CUSTOM_EVENTS_FIELD);
        map.put("CwLogEnabled", CW_LOG_ENABLED_FIELD);
        map.put("DeobfuscationConfiguration", DEOBFUSCATION_CONFIGURATION_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        map.put("DomainList", DOMAIN_LIST_FIELD);
        map.put("Name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAppMonitorRequest, T> g) {
        return obj -> g.apply((UpdateAppMonitorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RumRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAppMonitorRequest> {
        /**
         * <p>
         * A structure that contains much of the configuration data for the app monitor. If you are using Amazon Cognito
         * for authorization, you must include this structure in your request, and it must include the ID of the Amazon
         * Cognito identity pool to use for authorization. If you don't include <code>AppMonitorConfiguration</code>,
         * you must set up your own authorization method. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html"
         * >Authorize your application to send data to Amazon Web Services</a>.
         * </p>
         * 
         * @param appMonitorConfiguration
         *        A structure that contains much of the configuration data for the app monitor. If you are using Amazon
         *        Cognito for authorization, you must include this structure in your request, and it must include the ID
         *        of the Amazon Cognito identity pool to use for authorization. If you don't include
         *        <code>AppMonitorConfiguration</code>, you must set up your own authorization method. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html"
         *        >Authorize your application to send data to Amazon Web Services</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appMonitorConfiguration(AppMonitorConfiguration appMonitorConfiguration);

        /**
         * <p>
         * A structure that contains much of the configuration data for the app monitor. If you are using Amazon Cognito
         * for authorization, you must include this structure in your request, and it must include the ID of the Amazon
         * Cognito identity pool to use for authorization. If you don't include <code>AppMonitorConfiguration</code>,
         * you must set up your own authorization method. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html"
         * >Authorize your application to send data to Amazon Web Services</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppMonitorConfiguration.Builder} avoiding
         * the need to create one manually via {@link AppMonitorConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppMonitorConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #appMonitorConfiguration(AppMonitorConfiguration)}.
         * 
         * @param appMonitorConfiguration
         *        a consumer that will call methods on {@link AppMonitorConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appMonitorConfiguration(AppMonitorConfiguration)
         */
        default Builder appMonitorConfiguration(Consumer<AppMonitorConfiguration.Builder> appMonitorConfiguration) {
            return appMonitorConfiguration(AppMonitorConfiguration.builder().applyMutation(appMonitorConfiguration).build());
        }

        /**
         * <p>
         * Specifies whether this app monitor allows the web client to define and send custom events. The default is for
         * custom events to be <code>DISABLED</code>.
         * </p>
         * <p>
         * For more information about custom events, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-custom-events.html">Send
         * custom events</a>.
         * </p>
         * 
         * @param customEvents
         *        Specifies whether this app monitor allows the web client to define and send custom events. The default
         *        is for custom events to be <code>DISABLED</code>.</p>
         *        <p>
         *        For more information about custom events, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-custom-events.html"
         *        >Send custom events</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customEvents(CustomEvents customEvents);

        /**
         * <p>
         * Specifies whether this app monitor allows the web client to define and send custom events. The default is for
         * custom events to be <code>DISABLED</code>.
         * </p>
         * <p>
         * For more information about custom events, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-custom-events.html">Send
         * custom events</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomEvents.Builder} avoiding the need
         * to create one manually via {@link CustomEvents#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomEvents.Builder#build()} is called immediately and its
         * result is passed to {@link #customEvents(CustomEvents)}.
         * 
         * @param customEvents
         *        a consumer that will call methods on {@link CustomEvents.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customEvents(CustomEvents)
         */
        default Builder customEvents(Consumer<CustomEvents.Builder> customEvents) {
            return customEvents(CustomEvents.builder().applyMutation(customEvents).build());
        }

        /**
         * <p>
         * Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM sends
         * a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the
         * telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.
         * </p>
         * 
         * @param cwLogEnabled
         *        Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether
         *        RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to
         *        keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cwLogEnabled(Boolean cwLogEnabled);

        /**
         * <p>
         * A structure that contains the configuration for how an app monitor can deobfuscate stack traces.
         * </p>
         * 
         * @param deobfuscationConfiguration
         *        A structure that contains the configuration for how an app monitor can deobfuscate stack traces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deobfuscationConfiguration(DeobfuscationConfiguration deobfuscationConfiguration);

        /**
         * <p>
         * A structure that contains the configuration for how an app monitor can deobfuscate stack traces.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeobfuscationConfiguration.Builder}
         * avoiding the need to create one manually via {@link DeobfuscationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeobfuscationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #deobfuscationConfiguration(DeobfuscationConfiguration)}.
         * 
         * @param deobfuscationConfiguration
         *        a consumer that will call methods on {@link DeobfuscationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deobfuscationConfiguration(DeobfuscationConfiguration)
         */
        default Builder deobfuscationConfiguration(Consumer<DeobfuscationConfiguration.Builder> deobfuscationConfiguration) {
            return deobfuscationConfiguration(DeobfuscationConfiguration.builder().applyMutation(deobfuscationConfiguration)
                    .build());
        }

        /**
         * <p>
         * The top-level internet domain name for which your application has administrative authority.
         * </p>
         * 
         * @param domain
         *        The top-level internet domain name for which your application has administrative authority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * List the domain names for which your application has administrative authority. The
         * <code>UpdateAppMonitor</code> allows either the domain or the domain list.
         * </p>
         * 
         * @param domainList
         *        List the domain names for which your application has administrative authority. The
         *        <code>UpdateAppMonitor</code> allows either the domain or the domain list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainList(Collection<String> domainList);

        /**
         * <p>
         * List the domain names for which your application has administrative authority. The
         * <code>UpdateAppMonitor</code> allows either the domain or the domain list.
         * </p>
         * 
         * @param domainList
         *        List the domain names for which your application has administrative authority. The
         *        <code>UpdateAppMonitor</code> allows either the domain or the domain list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainList(String... domainList);

        /**
         * <p>
         * The name of the app monitor to update.
         * </p>
         * 
         * @param name
         *        The name of the app monitor to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RumRequest.BuilderImpl implements Builder {
        private AppMonitorConfiguration appMonitorConfiguration;

        private CustomEvents customEvents;

        private Boolean cwLogEnabled;

        private DeobfuscationConfiguration deobfuscationConfiguration;

        private String domain;

        private List<String> domainList = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAppMonitorRequest model) {
            super(model);
            appMonitorConfiguration(model.appMonitorConfiguration);
            customEvents(model.customEvents);
            cwLogEnabled(model.cwLogEnabled);
            deobfuscationConfiguration(model.deobfuscationConfiguration);
            domain(model.domain);
            domainList(model.domainList);
            name(model.name);
        }

        public final AppMonitorConfiguration.Builder getAppMonitorConfiguration() {
            return appMonitorConfiguration != null ? appMonitorConfiguration.toBuilder() : null;
        }

        public final void setAppMonitorConfiguration(AppMonitorConfiguration.BuilderImpl appMonitorConfiguration) {
            this.appMonitorConfiguration = appMonitorConfiguration != null ? appMonitorConfiguration.build() : null;
        }

        @Override
        public final Builder appMonitorConfiguration(AppMonitorConfiguration appMonitorConfiguration) {
            this.appMonitorConfiguration = appMonitorConfiguration;
            return this;
        }

        public final CustomEvents.Builder getCustomEvents() {
            return customEvents != null ? customEvents.toBuilder() : null;
        }

        public final void setCustomEvents(CustomEvents.BuilderImpl customEvents) {
            this.customEvents = customEvents != null ? customEvents.build() : null;
        }

        @Override
        public final Builder customEvents(CustomEvents customEvents) {
            this.customEvents = customEvents;
            return this;
        }

        public final Boolean getCwLogEnabled() {
            return cwLogEnabled;
        }

        public final void setCwLogEnabled(Boolean cwLogEnabled) {
            this.cwLogEnabled = cwLogEnabled;
        }

        @Override
        public final Builder cwLogEnabled(Boolean cwLogEnabled) {
            this.cwLogEnabled = cwLogEnabled;
            return this;
        }

        public final DeobfuscationConfiguration.Builder getDeobfuscationConfiguration() {
            return deobfuscationConfiguration != null ? deobfuscationConfiguration.toBuilder() : null;
        }

        public final void setDeobfuscationConfiguration(DeobfuscationConfiguration.BuilderImpl deobfuscationConfiguration) {
            this.deobfuscationConfiguration = deobfuscationConfiguration != null ? deobfuscationConfiguration.build() : null;
        }

        @Override
        public final Builder deobfuscationConfiguration(DeobfuscationConfiguration deobfuscationConfiguration) {
            this.deobfuscationConfiguration = deobfuscationConfiguration;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final Collection<String> getDomainList() {
            if (domainList instanceof SdkAutoConstructList) {
                return null;
            }
            return domainList;
        }

        public final void setDomainList(Collection<String> domainList) {
            this.domainList = AppMonitorDomainListCopier.copy(domainList);
        }

        @Override
        public final Builder domainList(Collection<String> domainList) {
            this.domainList = AppMonitorDomainListCopier.copy(domainList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainList(String... domainList) {
            domainList(Arrays.asList(domainList));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAppMonitorRequest build() {
            return new UpdateAppMonitorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
