/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal;

import com.amazonaws.s3.RequestDataSupplier;
import com.amazonaws.s3.S3NativeClient;
import com.amazonaws.s3.model.GetObjectRequest;
import com.amazonaws.s3.model.PutObjectRequest;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.client.config.ClientAsyncConfiguration;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.transfer.s3.internal.CrtErrorHandler;
import software.amazon.awssdk.transfer.s3.internal.CrtResponseDataConsumerAdapter;
import software.amazon.awssdk.transfer.s3.internal.RequestDataSupplierAdapter;
import software.amazon.awssdk.transfer.s3.internal.S3CrtAsyncClient;
import software.amazon.awssdk.transfer.s3.internal.S3CrtPojoConversion;
import software.amazon.awssdk.transfer.s3.internal.S3NativeClientConfiguration;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
public final class DefaultS3CrtAsyncClient
implements S3CrtAsyncClient {
    private final S3NativeClient s3NativeClient;
    private final S3NativeClientConfiguration configuration;
    private final CrtErrorHandler crtErrorHandler;

    public DefaultS3CrtAsyncClient(DefaultS3CrtClientBuilder builder) {
        S3NativeClientConfiguration.Builder configBuilder = S3NativeClientConfiguration.builder().targetThroughputInGbps(builder.targetThroughputInGbps()).partSizeInBytes(builder.minimumPartSizeInBytes()).maxConcurrency(builder.maxConcurrency).credentialsProvider(builder.credentialsProvider).asyncConfiguration(builder.asyncConfiguration);
        if (builder.region() != null) {
            configBuilder.signingRegion(builder.region().id());
        }
        this.configuration = configBuilder.build();
        this.s3NativeClient = new S3NativeClient(this.configuration.signingRegion(), this.configuration.clientBootstrap(), this.configuration.credentialsProvider(), this.configuration.partSizeBytes(), this.configuration.targetThroughputInGbps(), this.configuration.maxConcurrency());
        this.crtErrorHandler = new CrtErrorHandler();
    }

    @SdkTestInternalApi
    DefaultS3CrtAsyncClient(S3NativeClientConfiguration configuration, S3NativeClient nativeClient) {
        this.configuration = configuration;
        this.s3NativeClient = nativeClient;
        this.crtErrorHandler = new CrtErrorHandler();
    }

    public <ReturnT> CompletableFuture<ReturnT> getObject(software.amazon.awssdk.services.s3.model.GetObjectRequest getObjectRequest, AsyncResponseTransformer<GetObjectResponse, ReturnT> asyncResponseTransformer) {
        CompletableFuture returnFuture = new CompletableFuture();
        GetObjectRequest crtGetObjectRequest = S3CrtPojoConversion.toCrtGetObjectRequest(getObjectRequest);
        CrtResponseDataConsumerAdapter<ReturnT> adapter = new CrtResponseDataConsumerAdapter<ReturnT>(asyncResponseTransformer);
        CompletableFuture<ReturnT> adapterFuture = adapter.transformerFuture();
        CompletableFuture crtFuture = this.s3NativeClient.getObject(crtGetObjectRequest, adapter);
        CompletableFutureUtils.forwardExceptionTo(returnFuture, (CompletableFuture)crtFuture);
        CompletableFutureUtils.forwardTransformedExceptionTo((CompletableFuture)crtFuture, returnFuture, t -> t instanceof Exception ? this.crtErrorHandler.transformException((Exception)t) : t);
        returnFuture.whenComplete((r, t) -> {
            if (t == null) {
                returnFuture.complete(r);
            } else {
                returnFuture.completeExceptionally(t instanceof Exception ? this.crtErrorHandler.transformException((Exception)t) : t);
            }
        });
        CompletableFutureUtils.forwardResultTo(adapterFuture, returnFuture, (Executor)this.configuration.futureCompletionExecutor());
        return CompletableFutureUtils.forwardExceptionTo(returnFuture, adapterFuture);
    }

    public CompletableFuture<PutObjectResponse> putObject(software.amazon.awssdk.services.s3.model.PutObjectRequest putObjectRequest, AsyncRequestBody requestBody) {
        CompletableFuture returnFuture = new CompletableFuture();
        PutObjectRequest adaptedRequest = S3CrtPojoConversion.toCrtPutObjectRequest(putObjectRequest);
        if (adaptedRequest.contentLength() == null && requestBody.contentLength().isPresent()) {
            adaptedRequest = adaptedRequest.toBuilder().contentLength((Long)requestBody.contentLength().get()).build();
        }
        RequestDataSupplierAdapter requestDataSupplier = new RequestDataSupplierAdapter((Publisher<ByteBuffer>)requestBody);
        CompletableFuture crtFuture = this.s3NativeClient.putObject(adaptedRequest, (RequestDataSupplier)requestDataSupplier);
        CompletableFutureUtils.forwardExceptionTo(returnFuture, (CompletableFuture)crtFuture);
        CompletableFuture<SdkHttpResponse> httpResponseFuture = requestDataSupplier.sdkHttpResponseFuture();
        CompletionStage executeFuture = crtFuture.thenApply(putObjectOutput -> S3CrtPojoConversion.fromCrtPutObjectOutput(putObjectOutput, (SdkHttpResponse)httpResponseFuture.getNow((SdkHttpResponse)SdkHttpResponse.builder().build())));
        ((CompletableFuture)executeFuture).whenComplete((r, t) -> {
            if (t == null) {
                returnFuture.complete(r);
            } else {
                returnFuture.completeExceptionally(t instanceof Exception ? this.crtErrorHandler.transformException((Exception)t) : t);
            }
        });
        CompletableFutureUtils.forwardResultTo((CompletableFuture)executeFuture, returnFuture, (Executor)this.configuration.futureCompletionExecutor());
        return CompletableFutureUtils.forwardExceptionTo(returnFuture, (CompletableFuture)executeFuture);
    }

    public String serviceName() {
        return "s3";
    }

    public void close() {
        this.s3NativeClient.close();
        this.configuration.close();
    }

    public static final class DefaultS3CrtClientBuilder
    implements S3CrtAsyncClient.S3CrtAsyncClientBuilder {
        private AwsCredentialsProvider credentialsProvider;
        private Region region;
        private Long minimalPartSizeInBytes;
        private Double targetThroughputInGbps;
        private Integer maxConcurrency;
        private ClientAsyncConfiguration asyncConfiguration;

        public AwsCredentialsProvider credentialsProvider() {
            return this.credentialsProvider;
        }

        public Region region() {
            return this.region;
        }

        public Long minimumPartSizeInBytes() {
            return this.minimalPartSizeInBytes;
        }

        public Double targetThroughputInGbps() {
            return this.targetThroughputInGbps;
        }

        public Integer maxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public S3CrtAsyncClient.S3CrtAsyncClientBuilder credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        @Override
        public S3CrtAsyncClient.S3CrtAsyncClientBuilder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public S3CrtAsyncClient.S3CrtAsyncClientBuilder minimumPartSizeInBytes(Long partSizeBytes) {
            this.minimalPartSizeInBytes = partSizeBytes;
            return this;
        }

        @Override
        public S3CrtAsyncClient.S3CrtAsyncClientBuilder targetThroughputInGbps(Double targetThroughputInGbps) {
            this.targetThroughputInGbps = targetThroughputInGbps;
            return this;
        }

        @Override
        public S3CrtAsyncClient.S3CrtAsyncClientBuilder maxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        @Override
        public S3CrtAsyncClient.S3CrtAsyncClientBuilder asyncConfiguration(ClientAsyncConfiguration configuration) {
            this.asyncConfiguration = configuration;
            return this;
        }

        @Override
        public S3CrtAsyncClient build() {
            return new DefaultS3CrtAsyncClient(this);
        }
    }
}

