/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal;

import com.amazonaws.s3.OperationHandler;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkStandardLogger;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.http.HttpStatusFamily;
import software.amazon.awssdk.http.SdkHttpResponse;

@SdkInternalApi
public final class ResponseHeadersHandler
implements OperationHandler {
    private static final String REQUEST_ID = "x-amz-request-id";
    private final SdkHttpResponse.Builder responseBuilder = SdkHttpResponse.builder();
    private final CompletableFuture<SdkHttpResponse> responseFuture = new CompletableFuture();

    public void onResponseHeaders(int statusCode, HttpHeader[] headers) {
        if (HttpStatusFamily.of((int)statusCode) == HttpStatusFamily.SUCCESSFUL) {
            SdkStandardLogger.REQUEST_LOGGER.debug(() -> "Received successful response: " + statusCode);
        } else {
            SdkStandardLogger.REQUEST_LOGGER.debug(() -> "Received error response: " + statusCode);
        }
        for (HttpHeader header : headers) {
            this.responseBuilder.appendHeader(header.getName(), header.getValue());
        }
        this.responseBuilder.statusCode(statusCode);
        SdkStandardLogger.REQUEST_ID_LOGGER.debug(() -> "x-amz-request-id : " + this.responseBuilder.firstMatchingHeader(REQUEST_ID).orElse("not available"));
        SdkStandardLogger.REQUEST_ID_LOGGER.debug(() -> "x-amz-id-2 : " + this.responseBuilder.firstMatchingHeader("x-amz-id-2").orElse("not available"));
        this.responseFuture.complete((SdkHttpResponse)this.responseBuilder.build());
    }

    public CompletableFuture<SdkHttpResponse> sdkHttpResponseFuture() {
        return this.responseFuture;
    }
}

