/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal;

import java.io.File;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.transfer.s3.CompletedFileDownload;
import software.amazon.awssdk.transfer.s3.DownloadFileRequest;
import software.amazon.awssdk.transfer.s3.FileDownload;
import software.amazon.awssdk.transfer.s3.ResumableFileDownload;
import software.amazon.awssdk.transfer.s3.internal.progress.DefaultTransferProgress;
import software.amazon.awssdk.transfer.s3.internal.progress.DefaultTransferProgressSnapshot;
import software.amazon.awssdk.transfer.s3.progress.TransferProgress;
import software.amazon.awssdk.transfer.s3.progress.TransferProgressSnapshot;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultFileDownload
implements FileDownload {
    private static final Logger log = Logger.loggerFor(FileDownload.class);
    private final CompletableFuture<CompletedFileDownload> completionFuture;
    private final CompletableFuture<TransferProgress> progressFuture;
    private final CompletableFuture<DownloadFileRequest> requestFuture;
    private volatile ResumableFileDownload resumableFileDownload;
    private final Object lock = new Object();

    DefaultFileDownload(CompletableFuture<CompletedFileDownload> completedFileDownloadFuture, CompletableFuture<TransferProgress> progressFuture, CompletableFuture<DownloadFileRequest> requestFuture) {
        this.completionFuture = (CompletableFuture)Validate.paramNotNull(completedFileDownloadFuture, (String)"completedFileDownloadFuture");
        this.progressFuture = (CompletableFuture)Validate.paramNotNull(progressFuture, (String)"progressFuture");
        this.requestFuture = (CompletableFuture)Validate.paramNotNull(requestFuture, (String)"requestFuture");
    }

    @Override
    public TransferProgress progress() {
        return this.progressFuture.isDone() ? this.progressFuture.join() : new DefaultTransferProgress(DefaultTransferProgressSnapshot.builder().build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResumableFileDownload pause() {
        log.debug(() -> "Start to pause ");
        if (this.resumableFileDownload == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.resumableFileDownload == null) {
                    this.completionFuture.cancel(true);
                    if (!this.requestFuture.isDone() || !this.progressFuture.isDone()) {
                        throw SdkClientException.create((String)"DownloadFileRequest is unknown, not able to pause. This is likely because you are trying to pause a resumed download request that hasn't started yet. Please try later");
                    }
                    DownloadFileRequest request = this.requestFuture.join();
                    TransferProgress progress = this.progressFuture.join();
                    Instant s3objectLastModified = null;
                    Long totalBytesTransferred = null;
                    TransferProgressSnapshot snapshot = progress.snapshot();
                    if (snapshot.sdkResponse().isPresent() && snapshot.sdkResponse().get() instanceof GetObjectResponse) {
                        GetObjectResponse getObjectResponse = (GetObjectResponse)snapshot.sdkResponse().get();
                        s3objectLastModified = getObjectResponse.lastModified();
                        totalBytesTransferred = getObjectResponse.contentLength();
                    }
                    File destination = request.destination().toFile();
                    long length = destination.length();
                    Instant fileLastModified = Instant.ofEpochMilli(destination.lastModified());
                    this.resumableFileDownload = (ResumableFileDownload)ResumableFileDownload.builder().downloadFileRequest(request).s3ObjectLastModified(s3objectLastModified).fileLastModified(fileLastModified).bytesTransferred(length).totalSizeInBytes(totalBytesTransferred).build();
                }
            }
        }
        return this.resumableFileDownload;
    }

    @Override
    public CompletableFuture<CompletedFileDownload> completionFuture() {
        return this.completionFuture;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultFileDownload that = (DefaultFileDownload)o;
        if (!Objects.equals(this.completionFuture, that.completionFuture)) {
            return false;
        }
        if (!Objects.equals(this.requestFuture, that.requestFuture)) {
            return false;
        }
        return Objects.equals(this.progressFuture, that.progressFuture);
    }

    public int hashCode() {
        int result = this.completionFuture != null ? this.completionFuture.hashCode() : 0;
        result = 31 * result + (this.requestFuture != null ? this.requestFuture.hashCode() : 0);
        result = 31 * result + (this.progressFuture != null ? this.progressFuture.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"DefaultFileDownload").add("completionFuture", this.completionFuture).add("progress", this.progressFuture).add("request", this.requestFuture).build();
    }
}

