/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.serialization;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.DateUtils;

@FunctionalInterface
@SdkInternalApi
public interface TransferManagerJsonUnmarshaller<T> {
    public static final TransferManagerJsonUnmarshaller<String> STRING = val -> val;
    public static final TransferManagerJsonUnmarshaller<Short> SHORT = Short::parseShort;
    public static final TransferManagerJsonUnmarshaller<Integer> INTEGER = Integer::parseInt;
    public static final TransferManagerJsonUnmarshaller<Long> LONG = Long::parseLong;
    public static final TransferManagerJsonUnmarshaller<Void> NULL = val -> null;
    public static final TransferManagerJsonUnmarshaller<Float> FLOAT = Float::parseFloat;
    public static final TransferManagerJsonUnmarshaller<Double> DOUBLE = Double::parseDouble;
    public static final TransferManagerJsonUnmarshaller<BigDecimal> BIG_DECIMAL = BigDecimal::new;
    public static final TransferManagerJsonUnmarshaller<Boolean> BOOLEAN = Boolean::parseBoolean;
    public static final TransferManagerJsonUnmarshaller<SdkBytes> SDK_BYTES = content -> SdkBytes.fromByteArray((byte[])BinaryUtils.fromBase64((String)content));
    public static final TransferManagerJsonUnmarshaller<Instant> INSTANT = new TransferManagerJsonUnmarshaller<Instant>(){

        @Override
        public Instant unmarshall(String value) {
            if (value == null) {
                return null;
            }
            return this.safeParseDate(DateUtils::parseUnixTimestampInstant).apply(value);
        }

        private Function<String, Instant> safeParseDate(Function<String, Instant> dateUnmarshaller) {
            return value -> {
                try {
                    return (Instant)dateUnmarshaller.apply((String)value);
                }
                catch (NumberFormatException e) {
                    throw SdkClientException.builder().message("Unable to parse date : " + value).cause((Throwable)e).build();
                }
            };
        }
    };

    default public T unmarshall(JsonNode jsonContent) {
        return jsonContent != null && !jsonContent.isNull() ? (T)this.unmarshall(jsonContent.text()) : null;
    }

    public T unmarshall(String var1);
}

