/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.serialization;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.protocols.core.Marshaller;
import software.amazon.awssdk.protocols.jsoncore.JsonWriter;
import software.amazon.awssdk.transfer.s3.internal.serialization.TransferManagerMarshallingUtils;

@FunctionalInterface
@SdkInternalApi
public interface TransferManagerJsonMarshaller<T>
extends Marshaller<T> {
    public static final TransferManagerJsonMarshaller<String> STRING = (val, jsonGenerator) -> jsonGenerator.writeValue(val);
    public static final TransferManagerJsonMarshaller<Short> SHORT = (val, jsonGenerator) -> jsonGenerator.writeValue(val.shortValue());
    public static final TransferManagerJsonMarshaller<Integer> INTEGER = (val, jsonGenerator) -> jsonGenerator.writeValue(val.intValue());
    public static final TransferManagerJsonMarshaller<Long> LONG = (val, jsonGenerator) -> jsonGenerator.writeValue(val.longValue());
    public static final TransferManagerJsonMarshaller<Float> FLOAT = (val, jsonGenerator) -> jsonGenerator.writeValue(val.floatValue());
    public static final TransferManagerJsonMarshaller<Double> DOUBLE = (val, jsonGenerator) -> jsonGenerator.writeValue(val.doubleValue());
    public static final TransferManagerJsonMarshaller<BigDecimal> BIG_DECIMAL = (val, jsonGenerator) -> jsonGenerator.writeValue(val);
    public static final TransferManagerJsonMarshaller<Boolean> BOOLEAN = (val, jsonGenerator) -> jsonGenerator.writeValue(val.booleanValue());
    public static final TransferManagerJsonMarshaller<Instant> INSTANT = (val, jsonGenerator) -> jsonGenerator.writeValue(val);
    public static final TransferManagerJsonMarshaller<SdkBytes> SDK_BYTES = (val, jsonGenerator) -> jsonGenerator.writeValue(val.asByteBuffer());
    public static final TransferManagerJsonMarshaller<Void> NULL = new TransferManagerJsonMarshaller<Void>(){

        @Override
        public void marshall(Void val, JsonWriter generator, String paramName) {
            if (paramName == null) {
                generator.writeNull();
            }
        }

        @Override
        public void marshall(Void val, JsonWriter jsonGenerator) {
        }
    };
    public static final TransferManagerJsonMarshaller<List<?>> LIST = new TransferManagerJsonMarshaller<List<?>>(){

        @Override
        public void marshall(List<?> list, JsonWriter jsonGenerator) {
            jsonGenerator.writeStartArray();
            list.forEach(val -> TransferManagerMarshallingUtils.getMarshaller(val).marshall(val, jsonGenerator, null));
            jsonGenerator.writeEndArray();
        }

        @Override
        public boolean shouldEmit(List<?> list) {
            return !list.isEmpty() || !(list instanceof SdkAutoConstructList);
        }
    };
    public static final TransferManagerJsonMarshaller<Map<String, ?>> MAP = new TransferManagerJsonMarshaller<Map<String, ?>>(){

        @Override
        public void marshall(Map<String, ?> map, JsonWriter jsonGenerator) {
            jsonGenerator.writeStartObject();
            map.forEach((key, value) -> {
                if (value != null) {
                    jsonGenerator.writeFieldName(key);
                    TransferManagerMarshallingUtils.getMarshaller(value).marshall(value, jsonGenerator, null);
                }
            });
            jsonGenerator.writeEndObject();
        }

        @Override
        public boolean shouldEmit(Map<String, ?> map) {
            return !map.isEmpty() || !(map instanceof SdkAutoConstructMap);
        }
    };

    default public void marshall(T val, JsonWriter generator, String paramName) {
        if (!this.shouldEmit(val)) {
            return;
        }
        if (paramName != null) {
            generator.writeFieldName(paramName);
        }
        this.marshall(val, generator);
    }

    public void marshall(T var1, JsonWriter var2);

    default public boolean shouldEmit(T val) {
        return true;
    }
}

