/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.progress;

import java.util.OptionalLong;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.StringUtils;

@SdkInternalApi
public final class ContentRangeParser {
    private static final Logger log = Logger.loggerFor(ContentRangeParser.class);

    private ContentRangeParser() {
    }

    public static OptionalLong totalBytes(String contentRange) {
        if (StringUtils.isEmpty((CharSequence)contentRange)) {
            return OptionalLong.empty();
        }
        String trimmed = contentRange.trim();
        if (!trimmed.startsWith("bytes")) {
            return OptionalLong.empty();
        }
        int lastSlash = trimmed.lastIndexOf(47);
        if (lastSlash == -1) {
            return OptionalLong.empty();
        }
        String totalBytes = trimmed.substring(lastSlash + 1);
        if ("*".equals(totalBytes)) {
            return OptionalLong.empty();
        }
        try {
            long value = Long.parseLong(totalBytes);
            return value > 0L ? OptionalLong.of(value) : OptionalLong.empty();
        }
        catch (NumberFormatException e) {
            log.warn(() -> "failed to parse content range", (Throwable)e);
            return OptionalLong.empty();
        }
    }
}

