/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.crt.s3.ResumeToken;
import software.amazon.awssdk.http.SdkHttpExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpExecutionAttributes;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.crt.S3CrtSdkHttpExecutionAttribute;
import software.amazon.awssdk.services.s3.internal.crt.S3InternalSdkHttpExecutionAttribute;
import software.amazon.awssdk.services.s3.internal.crt.S3MetaRequestPauseObservable;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.transfer.s3.internal.GenericS3TransferManager;
import software.amazon.awssdk.transfer.s3.internal.TransferManagerConfiguration;
import software.amazon.awssdk.transfer.s3.internal.model.CrtFileUpload;
import software.amazon.awssdk.transfer.s3.internal.model.DefaultUpload;
import software.amazon.awssdk.transfer.s3.internal.progress.TransferProgressUpdater;
import software.amazon.awssdk.transfer.s3.model.CompletedFileUpload;
import software.amazon.awssdk.transfer.s3.model.CompletedUpload;
import software.amazon.awssdk.transfer.s3.model.FileUpload;
import software.amazon.awssdk.transfer.s3.model.ResumableFileUpload;
import software.amazon.awssdk.transfer.s3.model.Upload;
import software.amazon.awssdk.transfer.s3.model.UploadFileRequest;
import software.amazon.awssdk.transfer.s3.model.UploadRequest;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
class CrtS3TransferManager
extends GenericS3TransferManager {
    private final S3AsyncClient s3AsyncClient;

    CrtS3TransferManager(TransferManagerConfiguration transferConfiguration, S3AsyncClient s3AsyncClient, boolean isDefaultS3AsyncClient) {
        super(transferConfiguration, s3AsyncClient, isDefaultS3AsyncClient);
        this.s3AsyncClient = s3AsyncClient;
    }

    @Override
    public final Upload upload(UploadRequest uploadRequest) {
        Validate.paramNotNull((Object)uploadRequest, (String)"uploadRequest");
        AsyncRequestBody requestBody = uploadRequest.requestBody();
        CompletableFuture<CompletedUpload> returnFuture = new CompletableFuture<CompletedUpload>();
        TransferProgressUpdater progressUpdater = new TransferProgressUpdater(uploadRequest, requestBody.contentLength().orElse(null));
        progressUpdater.transferInitiated();
        progressUpdater.registerCompletion(returnFuture);
        Consumer<SdkHttpExecutionAttributes.Builder> attachProgress = b -> b.put((SdkHttpExecutionAttribute)S3CrtSdkHttpExecutionAttribute.CRT_PROGRESS_LISTENER, progressUpdater.crtProgressListener());
        PutObjectRequest putObjectRequest = this.attachCrtSdkAttribute(uploadRequest.putObjectRequest(), attachProgress);
        this.doUpload(putObjectRequest, requestBody, returnFuture);
        return new DefaultUpload(returnFuture, progressUpdater.progress());
    }

    @Override
    public FileUpload uploadFile(UploadFileRequest uploadFileRequest) {
        Validate.paramNotNull((Object)uploadFileRequest, (String)"uploadFileRequest");
        S3MetaRequestPauseObservable observable = new S3MetaRequestPauseObservable();
        Long fileContentLength = AsyncRequestBody.fromFile((Path)uploadFileRequest.source()).contentLength().orElse(null);
        TransferProgressUpdater progressUpdater = new TransferProgressUpdater(uploadFileRequest, fileContentLength);
        Consumer<SdkHttpExecutionAttributes.Builder> attachObservable = b -> b.put((SdkHttpExecutionAttribute)S3CrtSdkHttpExecutionAttribute.METAREQUEST_PAUSE_OBSERVABLE, (Object)observable).put((SdkHttpExecutionAttribute)S3CrtSdkHttpExecutionAttribute.CRT_PROGRESS_LISTENER, progressUpdater.crtProgressListener());
        PutObjectRequest putObjectRequest = this.attachCrtSdkAttribute(uploadFileRequest.putObjectRequest(), attachObservable);
        CompletableFuture<CompletedFileUpload> returnFuture = new CompletableFuture<CompletedFileUpload>();
        progressUpdater.transferInitiated();
        progressUpdater.registerCompletion(returnFuture);
        try {
            CrtS3TransferManager.assertNotUnsupportedArn(putObjectRequest.bucket(), "upload");
            CompletableFuture crtFuture = this.s3AsyncClient.putObject(putObjectRequest, uploadFileRequest.source());
            CompletableFutureUtils.forwardExceptionTo(returnFuture, (CompletableFuture)crtFuture);
            CompletableFutureUtils.forwardTransformedResultTo((CompletableFuture)crtFuture, returnFuture, r -> CompletedFileUpload.builder().response((PutObjectResponse)r).build());
        }
        catch (Throwable throwable) {
            returnFuture.completeExceptionally(throwable);
        }
        return new CrtFileUpload(returnFuture, progressUpdater.progress(), observable, uploadFileRequest);
    }

    @Override
    FileUpload doResumeUpload(ResumableFileUpload resumableFileUpload) {
        UploadFileRequest uploadFileRequest = resumableFileUpload.uploadFileRequest();
        PutObjectRequest putObjectRequest = uploadFileRequest.putObjectRequest();
        ResumeToken resumeToken = CrtS3TransferManager.crtResumeToken(resumableFileUpload);
        Consumer<SdkHttpExecutionAttributes.Builder> attachResumeToken = b -> b.put((SdkHttpExecutionAttribute)S3InternalSdkHttpExecutionAttribute.CRT_PAUSE_RESUME_TOKEN, (Object)resumeToken);
        PutObjectRequest modifiedPutObjectRequest = this.attachCrtSdkAttribute(putObjectRequest, attachResumeToken);
        return this.uploadFile((UploadFileRequest)uploadFileRequest.toBuilder().putObjectRequest(modifiedPutObjectRequest).build());
    }

    private static ResumeToken crtResumeToken(ResumableFileUpload resumableFileUpload) {
        return new ResumeToken(new ResumeToken.PutResumeTokenBuilder().withNumPartsCompleted(resumableFileUpload.transferredParts().orElse(0L)).withTotalNumParts(resumableFileUpload.totalParts().orElse(0L)).withPartSize(resumableFileUpload.partSizeInBytes().getAsLong()).withUploadId((String)resumableFileUpload.multipartUploadId().orElse(null)));
    }

    private PutObjectRequest attachCrtSdkAttribute(PutObjectRequest putObjectRequest, Consumer<SdkHttpExecutionAttributes.Builder> builderMutation) {
        SdkHttpExecutionAttributes modifiedAttributes = putObjectRequest.overrideConfiguration().map(o -> (SdkHttpExecutionAttributes)o.executionAttributes().getAttribute(SdkInternalExecutionAttribute.SDK_HTTP_EXECUTION_ATTRIBUTES)).map(b -> ((SdkHttpExecutionAttributes.Builder)b.toBuilder().applyMutation(builderMutation)).build()).orElseGet(() -> ((SdkHttpExecutionAttributes.Builder)SdkHttpExecutionAttributes.builder().applyMutation(builderMutation)).build());
        Consumer<AwsRequestOverrideConfiguration.Builder> attachSdkHttpAttributes = b -> b.putExecutionAttribute(SdkInternalExecutionAttribute.SDK_HTTP_EXECUTION_ATTRIBUTES, (Object)modifiedAttributes);
        AwsRequestOverrideConfiguration modifiedRequestOverrideConfig = putObjectRequest.overrideConfiguration().map(o -> ((AwsRequestOverrideConfiguration.Builder)o.toBuilder().applyMutation(attachSdkHttpAttributes)).build()).orElseGet(() -> ((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(attachSdkHttpAttributes)).build());
        return (PutObjectRequest)putObjectRequest.toBuilder().overrideConfiguration(modifiedRequestOverrideConfig).build();
    }
}

