/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteMarkerEntry implements ToCopyableBuilder<DeleteMarkerEntry.Builder, DeleteMarkerEntry> {
    private final Owner owner;

    private final String key;

    private final String versionId;

    private final Boolean isLatest;

    private final Date lastModified;

    private DeleteMarkerEntry(BuilderImpl builder) {
        this.owner = builder.owner;
        this.key = builder.key;
        this.versionId = builder.versionId;
        this.isLatest = builder.isLatest;
        this.lastModified = builder.lastModified;
    }

    /**
     *
     * @return
     */
    public Owner owner() {
        return owner;
    }

    /**
     * The object key.
     * 
     * @return The object key.
     */
    public String key() {
        return key;
    }

    /**
     * Version ID of an object.
     * 
     * @return Version ID of an object.
     */
    public String versionId() {
        return versionId;
    }

    /**
     * Specifies whether the object is (true) or is not (false) the latest version of an object.
     * 
     * @return Specifies whether the object is (true) or is not (false) the latest version of an object.
     */
    public Boolean isLatest() {
        return isLatest;
    }

    /**
     * Date and time the object was last modified.
     * 
     * @return Date and time the object was last modified.
     */
    public Date lastModified() {
        return lastModified;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((owner() == null) ? 0 : owner().hashCode());
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        hashCode = 31 * hashCode + ((versionId() == null) ? 0 : versionId().hashCode());
        hashCode = 31 * hashCode + ((isLatest() == null) ? 0 : isLatest().hashCode());
        hashCode = 31 * hashCode + ((lastModified() == null) ? 0 : lastModified().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMarkerEntry)) {
            return false;
        }
        DeleteMarkerEntry other = (DeleteMarkerEntry) obj;
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        if (other.owner() != null && !other.owner().equals(this.owner())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.versionId() == null ^ this.versionId() == null) {
            return false;
        }
        if (other.versionId() != null && !other.versionId().equals(this.versionId())) {
            return false;
        }
        if (other.isLatest() == null ^ this.isLatest() == null) {
            return false;
        }
        if (other.isLatest() != null && !other.isLatest().equals(this.isLatest())) {
            return false;
        }
        if (other.lastModified() == null ^ this.lastModified() == null) {
            return false;
        }
        if (other.lastModified() != null && !other.lastModified().equals(this.lastModified())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (owner() != null) {
            sb.append("Owner: ").append(owner()).append(",");
        }
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (versionId() != null) {
            sb.append("VersionId: ").append(versionId()).append(",");
        }
        if (isLatest() != null) {
            sb.append("IsLatest: ").append(isLatest()).append(",");
        }
        if (lastModified() != null) {
            sb.append("LastModified: ").append(lastModified()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteMarkerEntry> {
        /**
         *
         * @param owner
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(Owner owner);

        /**
         * The object key.
         * 
         * @param key
         *        The object key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * Version ID of an object.
         * 
         * @param versionId
         *        Version ID of an object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * Specifies whether the object is (true) or is not (false) the latest version of an object.
         * 
         * @param isLatest
         *        Specifies whether the object is (true) or is not (false) the latest version of an object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isLatest(Boolean isLatest);

        /**
         * Date and time the object was last modified.
         * 
         * @param lastModified
         *        Date and time the object was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Date lastModified);
    }

    private static final class BuilderImpl implements Builder {
        private Owner owner;

        private String key;

        private String versionId;

        private Boolean isLatest;

        private Date lastModified;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMarkerEntry model) {
            setOwner(model.owner);
            setKey(model.key);
            setVersionId(model.versionId);
            setIsLatest(model.isLatest);
            setLastModified(model.lastModified);
        }

        public final Owner getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner owner) {
            this.owner = owner;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Boolean getIsLatest() {
            return isLatest;
        }

        @Override
        public final Builder isLatest(Boolean isLatest) {
            this.isLatest = isLatest;
            return this;
        }

        public final void setIsLatest(Boolean isLatest) {
            this.isLatest = isLatest;
        }

        public final Date getLastModified() {
            return lastModified;
        }

        @Override
        public final Builder lastModified(Date lastModified) {
            this.lastModified = StandardMemberCopier.copy(lastModified);
            return this;
        }

        public final void setLastModified(Date lastModified) {
            this.lastModified = StandardMemberCopier.copy(lastModified);
        }

        @Override
        public DeleteMarkerEntry build() {
            return new DeleteMarkerEntry(this);
        }
    }
}
