/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteObjectsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DeleteObjectsResponse.Builder, DeleteObjectsResponse> {
    private final List<DeletedObject> deleted;

    private final String requestCharged;

    private final List<S3Error> errors;

    private DeleteObjectsResponse(BuilderImpl builder) {
        this.deleted = builder.deleted;
        this.requestCharged = builder.requestCharged;
        this.errors = builder.errors;
    }

    /**
     *
     * @return
     */
    public List<DeletedObject> deleted() {
        return deleted;
    }

    /**
     *
     * @return
     * @see RequestCharged
     */
    public String requestCharged() {
        return requestCharged;
    }

    /**
     *
     * @return
     */
    public List<S3Error> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deleted() == null) ? 0 : deleted().hashCode());
        hashCode = 31 * hashCode + ((requestCharged() == null) ? 0 : requestCharged().hashCode());
        hashCode = 31 * hashCode + ((errors() == null) ? 0 : errors().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteObjectsResponse)) {
            return false;
        }
        DeleteObjectsResponse other = (DeleteObjectsResponse) obj;
        if (other.deleted() == null ^ this.deleted() == null) {
            return false;
        }
        if (other.deleted() != null && !other.deleted().equals(this.deleted())) {
            return false;
        }
        if (other.requestCharged() == null ^ this.requestCharged() == null) {
            return false;
        }
        if (other.requestCharged() != null && !other.requestCharged().equals(this.requestCharged())) {
            return false;
        }
        if (other.errors() == null ^ this.errors() == null) {
            return false;
        }
        if (other.errors() != null && !other.errors().equals(this.errors())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deleted() != null) {
            sb.append("Deleted: ").append(deleted()).append(",");
        }
        if (requestCharged() != null) {
            sb.append("RequestCharged: ").append(requestCharged()).append(",");
        }
        if (errors() != null) {
            sb.append("Errors: ").append(errors()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteObjectsResponse> {
        /**
         *
         * @param deleted
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleted(Collection<DeletedObject> deleted);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDeleted(java.util.Collection)} or {@link #withDeleted(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param deleted
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleted(DeletedObject... deleted);

        /**
         *
         * @param requestCharged
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestCharged
         */
        Builder requestCharged(String requestCharged);

        /**
         *
         * @param requestCharged
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestCharged
         */
        Builder requestCharged(RequestCharged requestCharged);

        /**
         *
         * @param errors
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<S3Error> errors);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setErrors(java.util.Collection)} or {@link #withErrors(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param errors
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(S3Error... errors);
    }

    private static final class BuilderImpl implements Builder {
        private List<DeletedObject> deleted;

        private String requestCharged;

        private List<S3Error> errors;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteObjectsResponse model) {
            setDeleted(model.deleted);
            setRequestCharged(model.requestCharged);
            setErrors(model.errors);
        }

        public final Collection<DeletedObject> getDeleted() {
            return deleted;
        }

        @Override
        public final Builder deleted(Collection<DeletedObject> deleted) {
            this.deleted = DeletedObjectsCopier.copy(deleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleted(DeletedObject... deleted) {
            if (this.deleted == null) {
                this.deleted = new ArrayList<>(deleted.length);
            }
            for (DeletedObject e : deleted) {
                this.deleted.add(e);
            }
            return this;
        }

        public final void setDeleted(Collection<DeletedObject> deleted) {
            this.deleted = DeletedObjectsCopier.copy(deleted);
        }

        @SafeVarargs
        public final void setDeleted(DeletedObject... deleted) {
            if (this.deleted == null) {
                this.deleted = new ArrayList<>(deleted.length);
            }
            for (DeletedObject e : deleted) {
                this.deleted.add(e);
            }
        }

        public final String getRequestCharged() {
            return requestCharged;
        }

        @Override
        public final Builder requestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
            return this;
        }

        @Override
        public final Builder requestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
            return this;
        }

        public final void setRequestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
        }

        public final void setRequestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
        }

        public final Collection<S3Error> getErrors() {
            return errors;
        }

        @Override
        public final Builder errors(Collection<S3Error> errors) {
            this.errors = ErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(S3Error... errors) {
            if (this.errors == null) {
                this.errors = new ArrayList<>(errors.length);
            }
            for (S3Error e : errors) {
                this.errors.add(e);
            }
            return this;
        }

        public final void setErrors(Collection<S3Error> errors) {
            this.errors = ErrorsCopier.copy(errors);
        }

        @SafeVarargs
        public final void setErrors(S3Error... errors) {
            if (this.errors == null) {
                this.errors = new ArrayList<>(errors.length);
            }
            for (S3Error e : errors) {
                this.errors.add(e);
            }
        }

        @Override
        public DeleteObjectsResponse build() {
            return new DeleteObjectsResponse(this);
        }
    }
}
