/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBucketInventoryConfigurationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetBucketInventoryConfigurationResponse.Builder, GetBucketInventoryConfigurationResponse> {
    private final InventoryConfiguration inventoryConfiguration;

    private GetBucketInventoryConfigurationResponse(BuilderImpl builder) {
        this.inventoryConfiguration = builder.inventoryConfiguration;
    }

    /**
     * Specifies the inventory configuration.
     * 
     * @return Specifies the inventory configuration.
     */
    public InventoryConfiguration inventoryConfiguration() {
        return inventoryConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((inventoryConfiguration() == null) ? 0 : inventoryConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketInventoryConfigurationResponse)) {
            return false;
        }
        GetBucketInventoryConfigurationResponse other = (GetBucketInventoryConfigurationResponse) obj;
        if (other.inventoryConfiguration() == null ^ this.inventoryConfiguration() == null) {
            return false;
        }
        if (other.inventoryConfiguration() != null && !other.inventoryConfiguration().equals(this.inventoryConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (inventoryConfiguration() != null) {
            sb.append("InventoryConfiguration: ").append(inventoryConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetBucketInventoryConfigurationResponse> {
        /**
         * Specifies the inventory configuration.
         * 
         * @param inventoryConfiguration
         *        Specifies the inventory configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inventoryConfiguration(InventoryConfiguration inventoryConfiguration);
    }

    private static final class BuilderImpl implements Builder {
        private InventoryConfiguration inventoryConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketInventoryConfigurationResponse model) {
            setInventoryConfiguration(model.inventoryConfiguration);
        }

        public final InventoryConfiguration getInventoryConfiguration() {
            return inventoryConfiguration;
        }

        @Override
        public final Builder inventoryConfiguration(InventoryConfiguration inventoryConfiguration) {
            this.inventoryConfiguration = inventoryConfiguration;
            return this;
        }

        public final void setInventoryConfiguration(InventoryConfiguration inventoryConfiguration) {
            this.inventoryConfiguration = inventoryConfiguration;
        }

        @Override
        public GetBucketInventoryConfigurationResponse build() {
            return new GetBucketInventoryConfigurationResponse(this);
        }
    }
}
