/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class LifecycleRule implements ToCopyableBuilder<LifecycleRule.Builder, LifecycleRule> {
    private final LifecycleExpiration expiration;

    private final String id;

    private final String prefix;

    private final LifecycleRuleFilter filter;

    private final String status;

    private final List<Transition> transitions;

    private final List<NoncurrentVersionTransition> noncurrentVersionTransitions;

    private final NoncurrentVersionExpiration noncurrentVersionExpiration;

    private final AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;

    private LifecycleRule(BuilderImpl builder) {
        this.expiration = builder.expiration;
        this.id = builder.id;
        this.prefix = builder.prefix;
        this.filter = builder.filter;
        this.status = builder.status;
        this.transitions = builder.transitions;
        this.noncurrentVersionTransitions = builder.noncurrentVersionTransitions;
        this.noncurrentVersionExpiration = builder.noncurrentVersionExpiration;
        this.abortIncompleteMultipartUpload = builder.abortIncompleteMultipartUpload;
    }

    /**
     *
     * @return
     */
    public LifecycleExpiration expiration() {
        return expiration;
    }

    /**
     * Unique identifier for the rule. The value cannot be longer than 255 characters.
     * 
     * @return Unique identifier for the rule. The value cannot be longer than 255 characters.
     */
    public String id() {
        return id;
    }

    /**
     * Prefix identifying one or more objects to which the rule applies. This is deprecated; use Filter instead.
     * 
     * @return Prefix identifying one or more objects to which the rule applies. This is deprecated; use Filter instead.
     */
    public String prefix() {
        return prefix;
    }

    /**
     *
     * @return
     */
    public LifecycleRuleFilter filter() {
        return filter;
    }

    /**
     * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
     * 
     * @return If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being
     *         applied.
     * @see ExpirationStatus
     */
    public String status() {
        return status;
    }

    /**
     *
     * @return
     */
    public List<Transition> transitions() {
        return transitions;
    }

    /**
     *
     * @return
     */
    public List<NoncurrentVersionTransition> noncurrentVersionTransitions() {
        return noncurrentVersionTransitions;
    }

    /**
     *
     * @return
     */
    public NoncurrentVersionExpiration noncurrentVersionExpiration() {
        return noncurrentVersionExpiration;
    }

    /**
     *
     * @return
     */
    public AbortIncompleteMultipartUpload abortIncompleteMultipartUpload() {
        return abortIncompleteMultipartUpload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((expiration() == null) ? 0 : expiration().hashCode());
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((prefix() == null) ? 0 : prefix().hashCode());
        hashCode = 31 * hashCode + ((filter() == null) ? 0 : filter().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((transitions() == null) ? 0 : transitions().hashCode());
        hashCode = 31 * hashCode + ((noncurrentVersionTransitions() == null) ? 0 : noncurrentVersionTransitions().hashCode());
        hashCode = 31 * hashCode + ((noncurrentVersionExpiration() == null) ? 0 : noncurrentVersionExpiration().hashCode());
        hashCode = 31 * hashCode + ((abortIncompleteMultipartUpload() == null) ? 0 : abortIncompleteMultipartUpload().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleRule)) {
            return false;
        }
        LifecycleRule other = (LifecycleRule) obj;
        if (other.expiration() == null ^ this.expiration() == null) {
            return false;
        }
        if (other.expiration() != null && !other.expiration().equals(this.expiration())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.filter() == null ^ this.filter() == null) {
            return false;
        }
        if (other.filter() != null && !other.filter().equals(this.filter())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.transitions() == null ^ this.transitions() == null) {
            return false;
        }
        if (other.transitions() != null && !other.transitions().equals(this.transitions())) {
            return false;
        }
        if (other.noncurrentVersionTransitions() == null ^ this.noncurrentVersionTransitions() == null) {
            return false;
        }
        if (other.noncurrentVersionTransitions() != null
                && !other.noncurrentVersionTransitions().equals(this.noncurrentVersionTransitions())) {
            return false;
        }
        if (other.noncurrentVersionExpiration() == null ^ this.noncurrentVersionExpiration() == null) {
            return false;
        }
        if (other.noncurrentVersionExpiration() != null
                && !other.noncurrentVersionExpiration().equals(this.noncurrentVersionExpiration())) {
            return false;
        }
        if (other.abortIncompleteMultipartUpload() == null ^ this.abortIncompleteMultipartUpload() == null) {
            return false;
        }
        if (other.abortIncompleteMultipartUpload() != null
                && !other.abortIncompleteMultipartUpload().equals(this.abortIncompleteMultipartUpload())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (expiration() != null) {
            sb.append("Expiration: ").append(expiration()).append(",");
        }
        if (id() != null) {
            sb.append("ID: ").append(id()).append(",");
        }
        if (prefix() != null) {
            sb.append("Prefix: ").append(prefix()).append(",");
        }
        if (filter() != null) {
            sb.append("Filter: ").append(filter()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (transitions() != null) {
            sb.append("Transitions: ").append(transitions()).append(",");
        }
        if (noncurrentVersionTransitions() != null) {
            sb.append("NoncurrentVersionTransitions: ").append(noncurrentVersionTransitions()).append(",");
        }
        if (noncurrentVersionExpiration() != null) {
            sb.append("NoncurrentVersionExpiration: ").append(noncurrentVersionExpiration()).append(",");
        }
        if (abortIncompleteMultipartUpload() != null) {
            sb.append("AbortIncompleteMultipartUpload: ").append(abortIncompleteMultipartUpload()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, LifecycleRule> {
        /**
         *
         * @param expiration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(LifecycleExpiration expiration);

        /**
         * Unique identifier for the rule. The value cannot be longer than 255 characters.
         * 
         * @param id
         *        Unique identifier for the rule. The value cannot be longer than 255 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Prefix identifying one or more objects to which the rule applies. This is deprecated; use Filter instead.
         * 
         * @param prefix
         *        Prefix identifying one or more objects to which the rule applies. This is deprecated; use Filter
         *        instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         *
         * @param filter
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(LifecycleRuleFilter filter);

        /**
         * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
         * 
         * @param status
         *        If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being
         *        applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpirationStatus
         */
        Builder status(String status);

        /**
         * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
         * 
         * @param status
         *        If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being
         *        applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpirationStatus
         */
        Builder status(ExpirationStatus status);

        /**
         *
         * @param transitions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitions(Collection<Transition> transitions);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setTransitions(java.util.Collection)} or {@link #withTransitions(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param transitions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitions(Transition... transitions);

        /**
         *
         * @param noncurrentVersionTransitions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noncurrentVersionTransitions(Collection<NoncurrentVersionTransition> noncurrentVersionTransitions);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setNoncurrentVersionTransitions(java.util.Collection)} or
         * {@link #withNoncurrentVersionTransitions(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param noncurrentVersionTransitions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noncurrentVersionTransitions(NoncurrentVersionTransition... noncurrentVersionTransitions);

        /**
         *
         * @param noncurrentVersionExpiration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noncurrentVersionExpiration(NoncurrentVersionExpiration noncurrentVersionExpiration);

        /**
         *
         * @param abortIncompleteMultipartUpload
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortIncompleteMultipartUpload(AbortIncompleteMultipartUpload abortIncompleteMultipartUpload);
    }

    private static final class BuilderImpl implements Builder {
        private LifecycleExpiration expiration;

        private String id;

        private String prefix;

        private LifecycleRuleFilter filter;

        private String status;

        private List<Transition> transitions;

        private List<NoncurrentVersionTransition> noncurrentVersionTransitions;

        private NoncurrentVersionExpiration noncurrentVersionExpiration;

        private AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleRule model) {
            setExpiration(model.expiration);
            setID(model.id);
            setPrefix(model.prefix);
            setFilter(model.filter);
            setStatus(model.status);
            setTransitions(model.transitions);
            setNoncurrentVersionTransitions(model.noncurrentVersionTransitions);
            setNoncurrentVersionExpiration(model.noncurrentVersionExpiration);
            setAbortIncompleteMultipartUpload(model.abortIncompleteMultipartUpload);
        }

        public final LifecycleExpiration getExpiration() {
            return expiration;
        }

        @Override
        public final Builder expiration(LifecycleExpiration expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(LifecycleExpiration expiration) {
            this.expiration = expiration;
        }

        public final String getID() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setID(String id) {
            this.id = id;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final LifecycleRuleFilter getFilter() {
            return filter;
        }

        @Override
        public final Builder filter(LifecycleRuleFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(LifecycleRuleFilter filter) {
            this.filter = filter;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExpirationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ExpirationStatus status) {
            this.status(status.toString());
        }

        public final Collection<Transition> getTransitions() {
            return transitions;
        }

        @Override
        public final Builder transitions(Collection<Transition> transitions) {
            this.transitions = TransitionListCopier.copy(transitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitions(Transition... transitions) {
            if (this.transitions == null) {
                this.transitions = new ArrayList<>(transitions.length);
            }
            for (Transition e : transitions) {
                this.transitions.add(e);
            }
            return this;
        }

        public final void setTransitions(Collection<Transition> transitions) {
            this.transitions = TransitionListCopier.copy(transitions);
        }

        @SafeVarargs
        public final void setTransitions(Transition... transitions) {
            if (this.transitions == null) {
                this.transitions = new ArrayList<>(transitions.length);
            }
            for (Transition e : transitions) {
                this.transitions.add(e);
            }
        }

        public final Collection<NoncurrentVersionTransition> getNoncurrentVersionTransitions() {
            return noncurrentVersionTransitions;
        }

        @Override
        public final Builder noncurrentVersionTransitions(Collection<NoncurrentVersionTransition> noncurrentVersionTransitions) {
            this.noncurrentVersionTransitions = NoncurrentVersionTransitionListCopier.copy(noncurrentVersionTransitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder noncurrentVersionTransitions(NoncurrentVersionTransition... noncurrentVersionTransitions) {
            if (this.noncurrentVersionTransitions == null) {
                this.noncurrentVersionTransitions = new ArrayList<>(noncurrentVersionTransitions.length);
            }
            for (NoncurrentVersionTransition e : noncurrentVersionTransitions) {
                this.noncurrentVersionTransitions.add(e);
            }
            return this;
        }

        public final void setNoncurrentVersionTransitions(Collection<NoncurrentVersionTransition> noncurrentVersionTransitions) {
            this.noncurrentVersionTransitions = NoncurrentVersionTransitionListCopier.copy(noncurrentVersionTransitions);
        }

        @SafeVarargs
        public final void setNoncurrentVersionTransitions(NoncurrentVersionTransition... noncurrentVersionTransitions) {
            if (this.noncurrentVersionTransitions == null) {
                this.noncurrentVersionTransitions = new ArrayList<>(noncurrentVersionTransitions.length);
            }
            for (NoncurrentVersionTransition e : noncurrentVersionTransitions) {
                this.noncurrentVersionTransitions.add(e);
            }
        }

        public final NoncurrentVersionExpiration getNoncurrentVersionExpiration() {
            return noncurrentVersionExpiration;
        }

        @Override
        public final Builder noncurrentVersionExpiration(NoncurrentVersionExpiration noncurrentVersionExpiration) {
            this.noncurrentVersionExpiration = noncurrentVersionExpiration;
            return this;
        }

        public final void setNoncurrentVersionExpiration(NoncurrentVersionExpiration noncurrentVersionExpiration) {
            this.noncurrentVersionExpiration = noncurrentVersionExpiration;
        }

        public final AbortIncompleteMultipartUpload getAbortIncompleteMultipartUpload() {
            return abortIncompleteMultipartUpload;
        }

        @Override
        public final Builder abortIncompleteMultipartUpload(AbortIncompleteMultipartUpload abortIncompleteMultipartUpload) {
            this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
            return this;
        }

        public final void setAbortIncompleteMultipartUpload(AbortIncompleteMultipartUpload abortIncompleteMultipartUpload) {
            this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
        }

        @Override
        public LifecycleRule build() {
            return new LifecycleRule(this);
        }
    }
}
