/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class MetricsConfiguration implements ToCopyableBuilder<MetricsConfiguration.Builder, MetricsConfiguration> {
    private final String id;

    private final MetricsFilter filter;

    private MetricsConfiguration(BuilderImpl builder) {
        this.id = builder.id;
        this.filter = builder.filter;
    }

    /**
     * The ID used to identify the metrics configuration.
     * 
     * @return The ID used to identify the metrics configuration.
     */
    public String id() {
        return id;
    }

    /**
     * Specifies a metrics configuration filter. The metrics configuration will only include objects that meet the
     * filter's criteria. A filter must be a prefix, a tag, or a conjunction (MetricsAndOperator).
     * 
     * @return Specifies a metrics configuration filter. The metrics configuration will only include objects that meet
     *         the filter's criteria. A filter must be a prefix, a tag, or a conjunction (MetricsAndOperator).
     */
    public MetricsFilter filter() {
        return filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((filter() == null) ? 0 : filter().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricsConfiguration)) {
            return false;
        }
        MetricsConfiguration other = (MetricsConfiguration) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.filter() == null ^ this.filter() == null) {
            return false;
        }
        if (other.filter() != null && !other.filter().equals(this.filter())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (filter() != null) {
            sb.append("Filter: ").append(filter()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, MetricsConfiguration> {
        /**
         * The ID used to identify the metrics configuration.
         * 
         * @param id
         *        The ID used to identify the metrics configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Specifies a metrics configuration filter. The metrics configuration will only include objects that meet the
         * filter's criteria. A filter must be a prefix, a tag, or a conjunction (MetricsAndOperator).
         * 
         * @param filter
         *        Specifies a metrics configuration filter. The metrics configuration will only include objects that
         *        meet the filter's criteria. A filter must be a prefix, a tag, or a conjunction (MetricsAndOperator).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(MetricsFilter filter);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private MetricsFilter filter;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricsConfiguration model) {
            setId(model.id);
            setFilter(model.filter);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final MetricsFilter getFilter() {
            return filter;
        }

        @Override
        public final Builder filter(MetricsFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(MetricsFilter filter) {
            this.filter = filter;
        }

        @Override
        public MetricsConfiguration build() {
            return new MetricsConfiguration(this);
        }
    }
}
