/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;

@Generated("software.amazon.awssdk:codegen")
final class ObjectListCopier {
    static List<S3Object> copy(Collection<S3Object> objectListParam) {
        if (objectListParam == null) {
            return null;
        }
        List<S3Object> objectListParamCopy = new ArrayList<>(objectListParam.size());
        for (S3Object e : objectListParam) {
            objectListParamCopy.add(e);
        }
        return objectListParamCopy;
    }
}
