/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutBucketTaggingRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutBucketTaggingRequest.Builder, PutBucketTaggingRequest> {
    private final String bucket;

    private final String contentMD5;

    private final Tagging tagging;

    private PutBucketTaggingRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.tagging = builder.tagging;
    }

    /**
     *
     * @return
     */
    public String bucket() {
        return bucket;
    }

    /**
     *
     * @return
     */
    public String contentMD5() {
        return contentMD5;
    }

    /**
     *
     * @return
     */
    public Tagging tagging() {
        return tagging;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((contentMD5() == null) ? 0 : contentMD5().hashCode());
        hashCode = 31 * hashCode + ((tagging() == null) ? 0 : tagging().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketTaggingRequest)) {
            return false;
        }
        PutBucketTaggingRequest other = (PutBucketTaggingRequest) obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.contentMD5() == null ^ this.contentMD5() == null) {
            return false;
        }
        if (other.contentMD5() != null && !other.contentMD5().equals(this.contentMD5())) {
            return false;
        }
        if (other.tagging() == null ^ this.tagging() == null) {
            return false;
        }
        if (other.tagging() != null && !other.tagging().equals(this.tagging())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (contentMD5() != null) {
            sb.append("ContentMD5: ").append(contentMD5()).append(",");
        }
        if (tagging() != null) {
            sb.append("Tagging: ").append(tagging()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutBucketTaggingRequest> {
        /**
         *
         * @param bucket
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         *
         * @param contentMD5
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentMD5(String contentMD5);

        /**
         *
         * @param tagging
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagging(Tagging tagging);
    }

    private static final class BuilderImpl implements Builder {
        private String bucket;

        private String contentMD5;

        private Tagging tagging;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketTaggingRequest model) {
            setBucket(model.bucket);
            setContentMD5(model.contentMD5);
            setTagging(model.tagging);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getContentMD5() {
            return contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public final Tagging getTagging() {
            return tagging;
        }

        @Override
        public final Builder tagging(Tagging tagging) {
            this.tagging = tagging;
            return this;
        }

        public final void setTagging(Tagging tagging) {
            this.tagging = tagging;
        }

        @Override
        public PutBucketTaggingRequest build() {
            return new PutBucketTaggingRequest(this);
        }
    }
}
