/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class QueueConfigurationDeprecated implements
        ToCopyableBuilder<QueueConfigurationDeprecated.Builder, QueueConfigurationDeprecated> {
    private final String id;

    private final String event;

    private final List<String> events;

    private final String queue;

    private QueueConfigurationDeprecated(BuilderImpl builder) {
        this.id = builder.id;
        this.event = builder.event;
        this.events = builder.events;
        this.queue = builder.queue;
    }

    /**
     *
     * @return
     */
    public String id() {
        return id;
    }

    /**
     *
     * @return
     * @see Event
     */
    public String event() {
        return event;
    }

    /**
     *
     * @return
     * @see Event
     */
    public List<String> events() {
        return events;
    }

    /**
     *
     * @return
     */
    public String queue() {
        return queue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((event() == null) ? 0 : event().hashCode());
        hashCode = 31 * hashCode + ((events() == null) ? 0 : events().hashCode());
        hashCode = 31 * hashCode + ((queue() == null) ? 0 : queue().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueConfigurationDeprecated)) {
            return false;
        }
        QueueConfigurationDeprecated other = (QueueConfigurationDeprecated) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.event() == null ^ this.event() == null) {
            return false;
        }
        if (other.event() != null && !other.event().equals(this.event())) {
            return false;
        }
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        if (other.events() != null && !other.events().equals(this.events())) {
            return false;
        }
        if (other.queue() == null ^ this.queue() == null) {
            return false;
        }
        if (other.queue() != null && !other.queue().equals(this.queue())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (event() != null) {
            sb.append("Event: ").append(event()).append(",");
        }
        if (events() != null) {
            sb.append("Events: ").append(events()).append(",");
        }
        if (queue() != null) {
            sb.append("Queue: ").append(queue()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, QueueConfigurationDeprecated> {
        /**
         *
         * @param id
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         *
         * @param event
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder event(String event);

        /**
         *
         * @param event
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder event(Event event);

        /**
         *
         * @param events
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder events(Collection<String> events);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setEvents(java.util.Collection)} or {@link #withEvents(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param events
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder events(String... events);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setEvents(java.util.Collection)} or {@link #withEvents(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param events
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder events(Event... events);

        /**
         *
         * @param queue
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queue(String queue);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private String event;

        private List<String> events;

        private String queue;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueConfigurationDeprecated model) {
            setId(model.id);
            setEvent(model.event);
            setEvents(model.events);
            setQueue(model.queue);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getEvent() {
            return event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(Event event) {
            this.event(event.toString());
            return this;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        public final void setEvent(Event event) {
            this.event(event.toString());
        }

        public final Collection<String> getEvents() {
            return events;
        }

        @Override
        public final Builder events(Collection<String> events) {
            this.events = EventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(String... events) {
            if (this.events == null) {
                this.events = new ArrayList<>(events.length);
            }
            for (String e : events) {
                this.events.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Event... events) {
            if (this.events == null) {
                this.events = new ArrayList<String>(events.length);
            }
            for (Event ele : events) {
                this.events.add(ele.toString());
            }
            return this;
        }

        public final void setEvents(Collection<String> events) {
            this.events = EventListCopier.copy(events);
        }

        @SafeVarargs
        public final void setEvents(String... events) {
            if (this.events == null) {
                this.events = new ArrayList<>(events.length);
            }
            for (String e : events) {
                this.events.add(e);
            }
        }

        @SafeVarargs
        public final void setEvents(Event... events) {
            if (this.events == null) {
                this.events = new ArrayList<String>(events.length);
            }
            for (Event ele : events) {
                this.events.add(ele.toString());
            }
        }

        public final String getQueue() {
            return queue;
        }

        @Override
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        @Override
        public QueueConfigurationDeprecated build() {
            return new QueueConfigurationDeprecated(this);
        }
    }
}
