/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RedirectAllRequestsTo implements ToCopyableBuilder<RedirectAllRequestsTo.Builder, RedirectAllRequestsTo> {
    private final String hostName;

    private final String protocol;

    private RedirectAllRequestsTo(BuilderImpl builder) {
        this.hostName = builder.hostName;
        this.protocol = builder.protocol;
    }

    /**
     * Name of the host where requests will be redirected.
     * 
     * @return Name of the host where requests will be redirected.
     */
    public String hostName() {
        return hostName;
    }

    /**
     * Protocol to use (http, https) when redirecting requests. The default is the protocol that is used in the original
     * request.
     * 
     * @return Protocol to use (http, https) when redirecting requests. The default is the protocol that is used in the
     *         original request.
     * @see Protocol
     */
    public String protocol() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((hostName() == null) ? 0 : hostName().hashCode());
        hashCode = 31 * hashCode + ((protocol() == null) ? 0 : protocol().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedirectAllRequestsTo)) {
            return false;
        }
        RedirectAllRequestsTo other = (RedirectAllRequestsTo) obj;
        if (other.hostName() == null ^ this.hostName() == null) {
            return false;
        }
        if (other.hostName() != null && !other.hostName().equals(this.hostName())) {
            return false;
        }
        if (other.protocol() == null ^ this.protocol() == null) {
            return false;
        }
        if (other.protocol() != null && !other.protocol().equals(this.protocol())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (hostName() != null) {
            sb.append("HostName: ").append(hostName()).append(",");
        }
        if (protocol() != null) {
            sb.append("Protocol: ").append(protocol()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RedirectAllRequestsTo> {
        /**
         * Name of the host where requests will be redirected.
         * 
         * @param hostName
         *        Name of the host where requests will be redirected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostName(String hostName);

        /**
         * Protocol to use (http, https) when redirecting requests. The default is the protocol that is used in the
         * original request.
         * 
         * @param protocol
         *        Protocol to use (http, https) when redirecting requests. The default is the protocol that is used in
         *        the original request.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * Protocol to use (http, https) when redirecting requests. The default is the protocol that is used in the
         * original request.
         * 
         * @param protocol
         *        Protocol to use (http, https) when redirecting requests. The default is the protocol that is used in
         *        the original request.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);
    }

    private static final class BuilderImpl implements Builder {
        private String hostName;

        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(RedirectAllRequestsTo model) {
            setHostName(model.hostName);
            setProtocol(model.protocol);
        }

        public final String getHostName() {
            return hostName;
        }

        @Override
        public final Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public final void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final void setProtocol(Protocol protocol) {
            this.protocol(protocol.toString());
        }

        @Override
        public RedirectAllRequestsTo build() {
            return new RedirectAllRequestsTo(this);
        }
    }
}
