/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RestoreRequest implements ToCopyableBuilder<RestoreRequest.Builder, RestoreRequest> {
    private final Integer days;

    private final GlacierJobParameters glacierJobParameters;

    private RestoreRequest(BuilderImpl builder) {
        this.days = builder.days;
        this.glacierJobParameters = builder.glacierJobParameters;
    }

    /**
     * Lifetime of the active copy in days
     * 
     * @return Lifetime of the active copy in days
     */
    public Integer days() {
        return days;
    }

    /**
     * Glacier related prameters pertaining to this job.
     * 
     * @return Glacier related prameters pertaining to this job.
     */
    public GlacierJobParameters glacierJobParameters() {
        return glacierJobParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((days() == null) ? 0 : days().hashCode());
        hashCode = 31 * hashCode + ((glacierJobParameters() == null) ? 0 : glacierJobParameters().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreRequest)) {
            return false;
        }
        RestoreRequest other = (RestoreRequest) obj;
        if (other.days() == null ^ this.days() == null) {
            return false;
        }
        if (other.days() != null && !other.days().equals(this.days())) {
            return false;
        }
        if (other.glacierJobParameters() == null ^ this.glacierJobParameters() == null) {
            return false;
        }
        if (other.glacierJobParameters() != null && !other.glacierJobParameters().equals(this.glacierJobParameters())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (days() != null) {
            sb.append("Days: ").append(days()).append(",");
        }
        if (glacierJobParameters() != null) {
            sb.append("GlacierJobParameters: ").append(glacierJobParameters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RestoreRequest> {
        /**
         * Lifetime of the active copy in days
         * 
         * @param days
         *        Lifetime of the active copy in days
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder days(Integer days);

        /**
         * Glacier related prameters pertaining to this job.
         * 
         * @param glacierJobParameters
         *        Glacier related prameters pertaining to this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glacierJobParameters(GlacierJobParameters glacierJobParameters);
    }

    private static final class BuilderImpl implements Builder {
        private Integer days;

        private GlacierJobParameters glacierJobParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreRequest model) {
            setDays(model.days);
            setGlacierJobParameters(model.glacierJobParameters);
        }

        public final Integer getDays() {
            return days;
        }

        @Override
        public final Builder days(Integer days) {
            this.days = days;
            return this;
        }

        public final void setDays(Integer days) {
            this.days = days;
        }

        public final GlacierJobParameters getGlacierJobParameters() {
            return glacierJobParameters;
        }

        @Override
        public final Builder glacierJobParameters(GlacierJobParameters glacierJobParameters) {
            this.glacierJobParameters = glacierJobParameters;
            return this;
        }

        public final void setGlacierJobParameters(GlacierJobParameters glacierJobParameters) {
            this.glacierJobParameters = glacierJobParameters;
        }

        @Override
        public RestoreRequest build() {
            return new RestoreRequest(this);
        }
    }
}
