/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class Rule implements ToCopyableBuilder<Rule.Builder, Rule> {
    private final LifecycleExpiration expiration;

    private final String id;

    private final String prefix;

    private final String status;

    private final Transition transition;

    private final NoncurrentVersionTransition noncurrentVersionTransition;

    private final NoncurrentVersionExpiration noncurrentVersionExpiration;

    private final AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;

    private Rule(BuilderImpl builder) {
        this.expiration = builder.expiration;
        this.id = builder.id;
        this.prefix = builder.prefix;
        this.status = builder.status;
        this.transition = builder.transition;
        this.noncurrentVersionTransition = builder.noncurrentVersionTransition;
        this.noncurrentVersionExpiration = builder.noncurrentVersionExpiration;
        this.abortIncompleteMultipartUpload = builder.abortIncompleteMultipartUpload;
    }

    /**
     *
     * @return
     */
    public LifecycleExpiration expiration() {
        return expiration;
    }

    /**
     * Unique identifier for the rule. The value cannot be longer than 255 characters.
     * 
     * @return Unique identifier for the rule. The value cannot be longer than 255 characters.
     */
    public String id() {
        return id;
    }

    /**
     * Prefix identifying one or more objects to which the rule applies.
     * 
     * @return Prefix identifying one or more objects to which the rule applies.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
     * 
     * @return If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being
     *         applied.
     * @see ExpirationStatus
     */
    public String status() {
        return status;
    }

    /**
     *
     * @return
     */
    public Transition transition() {
        return transition;
    }

    /**
     *
     * @return
     */
    public NoncurrentVersionTransition noncurrentVersionTransition() {
        return noncurrentVersionTransition;
    }

    /**
     *
     * @return
     */
    public NoncurrentVersionExpiration noncurrentVersionExpiration() {
        return noncurrentVersionExpiration;
    }

    /**
     *
     * @return
     */
    public AbortIncompleteMultipartUpload abortIncompleteMultipartUpload() {
        return abortIncompleteMultipartUpload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((expiration() == null) ? 0 : expiration().hashCode());
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((prefix() == null) ? 0 : prefix().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((transition() == null) ? 0 : transition().hashCode());
        hashCode = 31 * hashCode + ((noncurrentVersionTransition() == null) ? 0 : noncurrentVersionTransition().hashCode());
        hashCode = 31 * hashCode + ((noncurrentVersionExpiration() == null) ? 0 : noncurrentVersionExpiration().hashCode());
        hashCode = 31 * hashCode + ((abortIncompleteMultipartUpload() == null) ? 0 : abortIncompleteMultipartUpload().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule) obj;
        if (other.expiration() == null ^ this.expiration() == null) {
            return false;
        }
        if (other.expiration() != null && !other.expiration().equals(this.expiration())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.transition() == null ^ this.transition() == null) {
            return false;
        }
        if (other.transition() != null && !other.transition().equals(this.transition())) {
            return false;
        }
        if (other.noncurrentVersionTransition() == null ^ this.noncurrentVersionTransition() == null) {
            return false;
        }
        if (other.noncurrentVersionTransition() != null
                && !other.noncurrentVersionTransition().equals(this.noncurrentVersionTransition())) {
            return false;
        }
        if (other.noncurrentVersionExpiration() == null ^ this.noncurrentVersionExpiration() == null) {
            return false;
        }
        if (other.noncurrentVersionExpiration() != null
                && !other.noncurrentVersionExpiration().equals(this.noncurrentVersionExpiration())) {
            return false;
        }
        if (other.abortIncompleteMultipartUpload() == null ^ this.abortIncompleteMultipartUpload() == null) {
            return false;
        }
        if (other.abortIncompleteMultipartUpload() != null
                && !other.abortIncompleteMultipartUpload().equals(this.abortIncompleteMultipartUpload())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (expiration() != null) {
            sb.append("Expiration: ").append(expiration()).append(",");
        }
        if (id() != null) {
            sb.append("ID: ").append(id()).append(",");
        }
        if (prefix() != null) {
            sb.append("Prefix: ").append(prefix()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (transition() != null) {
            sb.append("Transition: ").append(transition()).append(",");
        }
        if (noncurrentVersionTransition() != null) {
            sb.append("NoncurrentVersionTransition: ").append(noncurrentVersionTransition()).append(",");
        }
        if (noncurrentVersionExpiration() != null) {
            sb.append("NoncurrentVersionExpiration: ").append(noncurrentVersionExpiration()).append(",");
        }
        if (abortIncompleteMultipartUpload() != null) {
            sb.append("AbortIncompleteMultipartUpload: ").append(abortIncompleteMultipartUpload()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Rule> {
        /**
         *
         * @param expiration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(LifecycleExpiration expiration);

        /**
         * Unique identifier for the rule. The value cannot be longer than 255 characters.
         * 
         * @param id
         *        Unique identifier for the rule. The value cannot be longer than 255 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Prefix identifying one or more objects to which the rule applies.
         * 
         * @param prefix
         *        Prefix identifying one or more objects to which the rule applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
         * 
         * @param status
         *        If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being
         *        applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpirationStatus
         */
        Builder status(String status);

        /**
         * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
         * 
         * @param status
         *        If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being
         *        applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpirationStatus
         */
        Builder status(ExpirationStatus status);

        /**
         *
         * @param transition
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transition(Transition transition);

        /**
         *
         * @param noncurrentVersionTransition
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noncurrentVersionTransition(NoncurrentVersionTransition noncurrentVersionTransition);

        /**
         *
         * @param noncurrentVersionExpiration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noncurrentVersionExpiration(NoncurrentVersionExpiration noncurrentVersionExpiration);

        /**
         *
         * @param abortIncompleteMultipartUpload
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortIncompleteMultipartUpload(AbortIncompleteMultipartUpload abortIncompleteMultipartUpload);
    }

    private static final class BuilderImpl implements Builder {
        private LifecycleExpiration expiration;

        private String id;

        private String prefix;

        private String status;

        private Transition transition;

        private NoncurrentVersionTransition noncurrentVersionTransition;

        private NoncurrentVersionExpiration noncurrentVersionExpiration;

        private AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            setExpiration(model.expiration);
            setID(model.id);
            setPrefix(model.prefix);
            setStatus(model.status);
            setTransition(model.transition);
            setNoncurrentVersionTransition(model.noncurrentVersionTransition);
            setNoncurrentVersionExpiration(model.noncurrentVersionExpiration);
            setAbortIncompleteMultipartUpload(model.abortIncompleteMultipartUpload);
        }

        public final LifecycleExpiration getExpiration() {
            return expiration;
        }

        @Override
        public final Builder expiration(LifecycleExpiration expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(LifecycleExpiration expiration) {
            this.expiration = expiration;
        }

        public final String getID() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setID(String id) {
            this.id = id;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExpirationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ExpirationStatus status) {
            this.status(status.toString());
        }

        public final Transition getTransition() {
            return transition;
        }

        @Override
        public final Builder transition(Transition transition) {
            this.transition = transition;
            return this;
        }

        public final void setTransition(Transition transition) {
            this.transition = transition;
        }

        public final NoncurrentVersionTransition getNoncurrentVersionTransition() {
            return noncurrentVersionTransition;
        }

        @Override
        public final Builder noncurrentVersionTransition(NoncurrentVersionTransition noncurrentVersionTransition) {
            this.noncurrentVersionTransition = noncurrentVersionTransition;
            return this;
        }

        public final void setNoncurrentVersionTransition(NoncurrentVersionTransition noncurrentVersionTransition) {
            this.noncurrentVersionTransition = noncurrentVersionTransition;
        }

        public final NoncurrentVersionExpiration getNoncurrentVersionExpiration() {
            return noncurrentVersionExpiration;
        }

        @Override
        public final Builder noncurrentVersionExpiration(NoncurrentVersionExpiration noncurrentVersionExpiration) {
            this.noncurrentVersionExpiration = noncurrentVersionExpiration;
            return this;
        }

        public final void setNoncurrentVersionExpiration(NoncurrentVersionExpiration noncurrentVersionExpiration) {
            this.noncurrentVersionExpiration = noncurrentVersionExpiration;
        }

        public final AbortIncompleteMultipartUpload getAbortIncompleteMultipartUpload() {
            return abortIncompleteMultipartUpload;
        }

        @Override
        public final Builder abortIncompleteMultipartUpload(AbortIncompleteMultipartUpload abortIncompleteMultipartUpload) {
            this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
            return this;
        }

        public final void setAbortIncompleteMultipartUpload(AbortIncompleteMultipartUpload abortIncompleteMultipartUpload) {
            this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
        }

        @Override
        public Rule build() {
            return new Rule(this);
        }
    }
}
