/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import java.util.Map;
import java.util.HashMap;

import java.util.Map.Entry;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.runtime.transform.MapEntry;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * HeadObjectResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class HeadObjectResponseUnmarshaller implements Unmarshaller<HeadObjectResponse, StaxUnmarshallerContext> {

    private static class MetadataMapEntryUnmarshaller implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {

        @Override
        public Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;

            MapEntry<String, String> entry = new MapEntry<String, String>();

            while (true) {
                XMLEvent xmlEvent = context.nextEvent();
                if (xmlEvent.isEndDocument())
                    return entry;

                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("value", targetDepth)) {
                        entry.setValue(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                } else if (xmlEvent.isEndElement()) {
                    if (context.getCurrentDepth() < originalDepth)
                        return entry;
                }
            }
        }

        private static MetadataMapEntryUnmarshaller INSTANCE;

        public static MetadataMapEntryUnmarshaller getInstance() {
            if (INSTANCE == null)
                INSTANCE = new MetadataMapEntryUnmarshaller();
            return INSTANCE;
        }

    }

    public HeadObjectResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        HeadObjectResponse.Builder headObjectResponse = HeadObjectResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        if (context.isStartOfDocument()) {
            context.setCurrentHeader("x-amz-delete-marker");
            headObjectResponse.deleteMarker(BooleanUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("accept-ranges");
            headObjectResponse.acceptRanges(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-expiration");
            headObjectResponse.expiration(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-restore");
            headObjectResponse.restore(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("Last-Modified");
            headObjectResponse.lastModified(software.amazon.awssdk.util.DateUtils.parseRfc822Date(context.readText()));

            context.setCurrentHeader("Content-Length");
            headObjectResponse.contentLength(LongUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("ETag");
            headObjectResponse.eTag(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-missing-meta");
            headObjectResponse.missingMeta(IntegerUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-version-id");
            headObjectResponse.versionId(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("Cache-Control");
            headObjectResponse.cacheControl(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("Content-Disposition");
            headObjectResponse.contentDisposition(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("Content-Encoding");
            headObjectResponse.contentEncoding(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("Content-Language");
            headObjectResponse.contentLanguage(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("Content-Type");
            headObjectResponse.contentType(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("Expires");
            headObjectResponse.expires(software.amazon.awssdk.util.DateUtils.parseRfc822Date(context.readText()));

            context.setCurrentHeader("x-amz-website-redirect-location");
            headObjectResponse.websiteRedirectLocation(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-server-side-encryption");
            headObjectResponse.serverSideEncryption(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-server-side-encryption-customer-algorithm");
            headObjectResponse.sseCustomerAlgorithm(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-server-side-encryption-customer-key-MD5");
            headObjectResponse.sseCustomerKeyMD5(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-server-side-encryption-aws-kms-key-id");
            headObjectResponse.ssekmsKeyId(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-storage-class");
            headObjectResponse.storageClass(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-request-charged");
            headObjectResponse.requestCharged(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-replication-status");
            headObjectResponse.replicationStatus(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-mp-parts-count");
            headObjectResponse.partsCount(IntegerUnmarshaller.getInstance().unmarshall(context));

        }

        Map<String, String> metadata = new HashMap<>();
        context.getHeaders().entrySet().stream().filter(e -> e.getKey().startsWith("x-amz-meta-")).forEach(e -> {
            metadata.put(e.getKey().replace("x-amz-meta-", ""), e.getValue());
        });
        headObjectResponse.metadata(metadata);

        return headObjectResponse.build();
    }

    private static HeadObjectResponseUnmarshaller INSTANCE;

    public static HeadObjectResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new HeadObjectResponseUnmarshaller();
        return INSTANCE;
    }
}