/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListBucketMetricsConfigurationsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListBucketMetricsConfigurationsResponseUnmarshaller implements
        Unmarshaller<ListBucketMetricsConfigurationsResponse, StaxUnmarshallerContext> {

    public ListBucketMetricsConfigurationsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListBucketMetricsConfigurationsResponse.Builder listBucketMetricsConfigurationsResponse = ListBucketMetricsConfigurationsResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("IsTruncated", targetDepth)) {
                    listBucketMetricsConfigurationsResponse.isTruncated(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ContinuationToken", targetDepth)) {
                    listBucketMetricsConfigurationsResponse.continuationToken(StringUnmarshaller.getInstance()
                            .unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextContinuationToken", targetDepth)) {
                    listBucketMetricsConfigurationsResponse.nextContinuationToken(StringUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

                if (context.testExpression("MetricsConfiguration", targetDepth)) {
                    listBucketMetricsConfigurationsResponse.metricsConfigurationList(MetricsConfigurationUnmarshaller
                            .getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return listBucketMetricsConfigurationsResponse.build();
    }

    private static ListBucketMetricsConfigurationsResponseUnmarshaller INSTANCE;

    public static ListBucketMetricsConfigurationsResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new ListBucketMetricsConfigurationsResponseUnmarshaller();
        return INSTANCE;
    }
}