/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListMultipartUploadsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListMultipartUploadsResponseUnmarshaller implements
        Unmarshaller<ListMultipartUploadsResponse, StaxUnmarshallerContext> {

    public ListMultipartUploadsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListMultipartUploadsResponse.Builder listMultipartUploadsResponse = ListMultipartUploadsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Bucket", targetDepth)) {
                    listMultipartUploadsResponse.bucket(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("KeyMarker", targetDepth)) {
                    listMultipartUploadsResponse.keyMarker(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("UploadIdMarker", targetDepth)) {
                    listMultipartUploadsResponse.uploadIdMarker(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextKeyMarker", targetDepth)) {
                    listMultipartUploadsResponse.nextKeyMarker(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Prefix", targetDepth)) {
                    listMultipartUploadsResponse.prefix(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Delimiter", targetDepth)) {
                    listMultipartUploadsResponse.delimiter(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextUploadIdMarker", targetDepth)) {
                    listMultipartUploadsResponse.nextUploadIdMarker(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MaxUploads", targetDepth)) {
                    listMultipartUploadsResponse.maxUploads(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("IsTruncated", targetDepth)) {
                    listMultipartUploadsResponse.isTruncated(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Upload", targetDepth)) {
                    listMultipartUploadsResponse.uploads(MultipartUploadUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("CommonPrefixes", targetDepth)) {
                    listMultipartUploadsResponse.commonPrefixes(CommonPrefixUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("EncodingType", targetDepth)) {
                    listMultipartUploadsResponse.encodingType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return listMultipartUploadsResponse.build();
    }

    private static ListMultipartUploadsResponseUnmarshaller INSTANCE;

    public static ListMultipartUploadsResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new ListMultipartUploadsResponseUnmarshaller();
        return INSTANCE;
    }
}