/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import static software.amazon.awssdk.util.StringUtils.UTF8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;

import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;

import software.amazon.awssdk.util.Md5Utils;
import software.amazon.awssdk.util.XmlWriter;

/**
 * PutBucketMetricsConfigurationRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutBucketMetricsConfigurationRequestMarshaller implements
        Marshaller<Request<PutBucketMetricsConfigurationRequest>, PutBucketMetricsConfigurationRequest> {

    public Request<PutBucketMetricsConfigurationRequest> marshall(
            PutBucketMetricsConfigurationRequest putBucketMetricsConfigurationRequest) {

        if (putBucketMetricsConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<PutBucketMetricsConfigurationRequest> request = new DefaultRequest<PutBucketMetricsConfigurationRequest>(
                putBucketMetricsConfigurationRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        String uriResourcePath = "/{Bucket}?metrics";

        uriResourcePath = software.amazon.awssdk.util.UriResourcePathUtils.addStaticQueryParamtersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket",
                putBucketMetricsConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);

        if (putBucketMetricsConfigurationRequest.id() != null) {
            request.addParameter("id", StringUtils.fromString(putBucketMetricsConfigurationRequest.id()));
        }

        try {
            StringWriter stringWriter = null;
            MetricsConfiguration metricsConfiguration = putBucketMetricsConfigurationRequest.metricsConfiguration();
            if (metricsConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("MetricsConfiguration");

                if (metricsConfiguration.id() != null) {
                    xmlWriter.startElement("Id").value(metricsConfiguration.id()).endElement();
                }

                MetricsFilter filter = metricsConfiguration.filter();
                if (filter != null) {
                    xmlWriter.startElement("Filter");

                    if (filter.prefix() != null) {
                        xmlWriter.startElement("Prefix").value(filter.prefix()).endElement();
                    }

                    Tag tag = filter.tag();
                    if (tag != null) {
                        xmlWriter.startElement("Tag");

                        if (tag.key() != null) {
                            xmlWriter.startElement("Key").value(tag.key()).endElement();
                        }

                        if (tag.value() != null) {
                            xmlWriter.startElement("Value").value(tag.value()).endElement();
                        }
                        xmlWriter.endElement();
                    }

                    MetricsAndOperator and = filter.and();
                    if (and != null) {
                        xmlWriter.startElement("And");

                        if (and.prefix() != null) {
                            xmlWriter.startElement("Prefix").value(and.prefix()).endElement();
                        }

                        java.util.List<Tag> metricsAndOperatorTagsList = and.tags();
                        if (metricsAndOperatorTagsList != null) {
                            for (Tag metricsAndOperatorTagsListValue : metricsAndOperatorTagsList) {
                                xmlWriter.startElement("Tag");

                                if (metricsAndOperatorTagsListValue.key() != null) {
                                    xmlWriter.startElement("Key").value(metricsAndOperatorTagsListValue.key()).endElement();
                                }

                                if (metricsAndOperatorTagsListValue.value() != null) {
                                    xmlWriter.startElement("Value").value(metricsAndOperatorTagsListValue.value()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }

            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(UTF8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }

        return request;
    }

}