/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;

import software.amazon.awssdk.util.StringUtils;

/**
 * UploadPartCopyRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UploadPartCopyRequestMarshaller implements Marshaller<Request<UploadPartCopyRequest>, UploadPartCopyRequest> {

    public Request<UploadPartCopyRequest> marshall(UploadPartCopyRequest uploadPartCopyRequest) {

        if (uploadPartCopyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<UploadPartCopyRequest> request = new DefaultRequest<UploadPartCopyRequest>(uploadPartCopyRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        if (uploadPartCopyRequest.copySource() != null) {
            request.addHeader("x-amz-copy-source", StringUtils.fromString(uploadPartCopyRequest.copySource()));
        }

        if (uploadPartCopyRequest.copySourceIfMatch() != null) {
            request.addHeader("x-amz-copy-source-if-match", StringUtils.fromString(uploadPartCopyRequest.copySourceIfMatch()));
        }

        if (uploadPartCopyRequest.copySourceIfModifiedSince() != null) {
            request.addHeader("x-amz-copy-source-if-modified-since",
                    StringUtils.fromDate(uploadPartCopyRequest.copySourceIfModifiedSince()));
        }

        if (uploadPartCopyRequest.copySourceIfNoneMatch() != null) {
            request.addHeader("x-amz-copy-source-if-none-match",
                    StringUtils.fromString(uploadPartCopyRequest.copySourceIfNoneMatch()));
        }

        if (uploadPartCopyRequest.copySourceIfUnmodifiedSince() != null) {
            request.addHeader("x-amz-copy-source-if-unmodified-since",
                    StringUtils.fromDate(uploadPartCopyRequest.copySourceIfUnmodifiedSince()));
        }

        if (uploadPartCopyRequest.copySourceRange() != null) {
            request.addHeader("x-amz-copy-source-range", StringUtils.fromString(uploadPartCopyRequest.copySourceRange()));
        }

        if (uploadPartCopyRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm",
                    StringUtils.fromString(uploadPartCopyRequest.sseCustomerAlgorithm()));
        }

        if (uploadPartCopyRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key",
                    StringUtils.fromString(uploadPartCopyRequest.sseCustomerKey()));
        }

        if (uploadPartCopyRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5",
                    StringUtils.fromString(uploadPartCopyRequest.sseCustomerKeyMD5()));
        }

        if (uploadPartCopyRequest.copySourceSSECustomerAlgorithm() != null) {
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-algorithm",
                    StringUtils.fromString(uploadPartCopyRequest.copySourceSSECustomerAlgorithm()));
        }

        if (uploadPartCopyRequest.copySourceSSECustomerKey() != null) {
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-key",
                    StringUtils.fromString(uploadPartCopyRequest.copySourceSSECustomerKey()));
        }

        if (uploadPartCopyRequest.copySourceSSECustomerKeyMD5() != null) {
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-key-MD5",
                    StringUtils.fromString(uploadPartCopyRequest.copySourceSSECustomerKeyMD5()));
        }

        if (uploadPartCopyRequest.requestPayer() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString(uploadPartCopyRequest.requestPayer()));
        }

        String uriResourcePath = "/{Bucket}/{Key+}";

        uriResourcePath = software.amazon.awssdk.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket",
                uploadPartCopyRequest.bucket());
        uriResourcePath = software.amazon.awssdk.runtime.transform.PathMarshallers.GREEDY.marshall(uriResourcePath, "Key",
                uploadPartCopyRequest.key());
        request.setResourcePath(uriResourcePath);

        if (uploadPartCopyRequest.partNumber() != null) {
            request.addParameter("partNumber", StringUtils.fromInteger(uploadPartCopyRequest.partNumber()));
        }

        if (uploadPartCopyRequest.uploadId() != null) {
            request.addParameter("uploadId", StringUtils.fromString(uploadPartCopyRequest.uploadId()));
        }

        return request;
    }

}