/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.services.s3.model.InventoryFormat;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InventoryS3BucketDestination
implements ToCopyableBuilder<Builder, InventoryS3BucketDestination> {
    private final String accountId;
    private final String bucket;
    private final String format;
    private final String prefix;

    private InventoryS3BucketDestination(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.bucket = builder.bucket;
        this.format = builder.format;
        this.prefix = builder.prefix;
    }

    public String accountId() {
        return this.accountId;
    }

    public String bucket() {
        return this.bucket;
    }

    public String format() {
        return this.format;
    }

    public String prefix() {
        return this.prefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountId() == null ? 0 : this.accountId().hashCode());
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.format() == null ? 0 : this.format().hashCode());
        hashCode = 31 * hashCode + (this.prefix() == null ? 0 : this.prefix().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryS3BucketDestination)) {
            return false;
        }
        InventoryS3BucketDestination other = (InventoryS3BucketDestination)obj;
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.format() == null ^ this.format() == null) {
            return false;
        }
        if (other.format() != null && !other.format().equals(this.format())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        return other.prefix() == null || other.prefix().equals(this.prefix());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.format() != null) {
            sb.append("Format: ").append(this.format()).append(",");
        }
        if (this.prefix() != null) {
            sb.append("Prefix: ").append(this.prefix()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String bucket;
        private String format;
        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryS3BucketDestination model) {
            this.setAccountId(model.accountId);
            this.setBucket(model.bucket);
            this.setFormat(model.format);
            this.setPrefix(model.prefix);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(InventoryFormat format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final void setFormat(InventoryFormat format) {
            this.format(format.toString());
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public InventoryS3BucketDestination build() {
            return new InventoryS3BucketDestination(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InventoryS3BucketDestination> {
        public Builder accountId(String var1);

        public Builder bucket(String var1);

        public Builder format(String var1);

        public Builder format(InventoryFormat var1);

        public Builder prefix(String var1);
    }
}

