/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.s3.model.RequestPaymentConfiguration;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutBucketRequestPaymentRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutBucketRequestPaymentRequest> {
    private final String bucket;
    private final String contentMD5;
    private final RequestPaymentConfiguration requestPaymentConfiguration;

    private PutBucketRequestPaymentRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.requestPaymentConfiguration = builder.requestPaymentConfiguration;
    }

    public String bucket() {
        return this.bucket;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    public RequestPaymentConfiguration requestPaymentConfiguration() {
        return this.requestPaymentConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.contentMD5() == null ? 0 : this.contentMD5().hashCode());
        hashCode = 31 * hashCode + (this.requestPaymentConfiguration() == null ? 0 : this.requestPaymentConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketRequestPaymentRequest)) {
            return false;
        }
        PutBucketRequestPaymentRequest other = (PutBucketRequestPaymentRequest)((Object)obj);
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.contentMD5() == null ^ this.contentMD5() == null) {
            return false;
        }
        if (other.contentMD5() != null && !other.contentMD5().equals(this.contentMD5())) {
            return false;
        }
        if (other.requestPaymentConfiguration() == null ^ this.requestPaymentConfiguration() == null) {
            return false;
        }
        return other.requestPaymentConfiguration() == null || other.requestPaymentConfiguration().equals(this.requestPaymentConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.contentMD5() != null) {
            sb.append("ContentMD5: ").append(this.contentMD5()).append(",");
        }
        if (this.requestPaymentConfiguration() != null) {
            sb.append("RequestPaymentConfiguration: ").append(this.requestPaymentConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String contentMD5;
        private RequestPaymentConfiguration requestPaymentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketRequestPaymentRequest model) {
            this.setBucket(model.bucket);
            this.setContentMD5(model.contentMD5);
            this.setRequestPaymentConfiguration(model.requestPaymentConfiguration);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getContentMD5() {
            return this.contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public final RequestPaymentConfiguration getRequestPaymentConfiguration() {
            return this.requestPaymentConfiguration;
        }

        @Override
        public final Builder requestPaymentConfiguration(RequestPaymentConfiguration requestPaymentConfiguration) {
            this.requestPaymentConfiguration = requestPaymentConfiguration;
            return this;
        }

        public final void setRequestPaymentConfiguration(RequestPaymentConfiguration requestPaymentConfiguration) {
            this.requestPaymentConfiguration = requestPaymentConfiguration;
        }

        public PutBucketRequestPaymentRequest build() {
            return new PutBucketRequestPaymentRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutBucketRequestPaymentRequest> {
        public Builder bucket(String var1);

        public Builder contentMD5(String var1);

        public Builder requestPaymentConfiguration(RequestPaymentConfiguration var1);
    }
}

