/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.s3.model.ReplicationRule;
import software.amazon.awssdk.services.s3.model.ReplicationRulesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReplicationConfiguration
implements ToCopyableBuilder<Builder, ReplicationConfiguration> {
    private final String role;
    private final List<ReplicationRule> rules;

    private ReplicationConfiguration(BuilderImpl builder) {
        this.role = builder.role;
        this.rules = builder.rules;
    }

    public String role() {
        return this.role;
    }

    public List<ReplicationRule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.role() == null ? 0 : this.role().hashCode());
        hashCode = 31 * hashCode + (this.rules() == null ? 0 : this.rules().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationConfiguration)) {
            return false;
        }
        ReplicationConfiguration other = (ReplicationConfiguration)obj;
        if (other.role() == null ^ this.role() == null) {
            return false;
        }
        if (other.role() != null && !other.role().equals(this.role())) {
            return false;
        }
        if (other.rules() == null ^ this.rules() == null) {
            return false;
        }
        return other.rules() == null || other.rules().equals(this.rules());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.role() != null) {
            sb.append("Role: ").append(this.role()).append(",");
        }
        if (this.rules() != null) {
            sb.append("Rules: ").append(this.rules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String role;
        private List<ReplicationRule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationConfiguration model) {
            this.setRole(model.role);
            this.setRules(model.rules);
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final Collection<ReplicationRule> getRules() {
            return this.rules;
        }

        @Override
        public final Builder rules(Collection<ReplicationRule> rules) {
            this.rules = ReplicationRulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(ReplicationRule ... rules) {
            if (this.rules == null) {
                this.rules = new ArrayList<ReplicationRule>(rules.length);
            }
            for (ReplicationRule e : rules) {
                this.rules.add(e);
            }
            return this;
        }

        public final void setRules(Collection<ReplicationRule> rules) {
            this.rules = ReplicationRulesCopier.copy(rules);
        }

        @SafeVarargs
        public final void setRules(ReplicationRule ... rules) {
            if (this.rules == null) {
                this.rules = new ArrayList<ReplicationRule>(rules.length);
            }
            for (ReplicationRule e : rules) {
                this.rules.add(e);
            }
        }

        public ReplicationConfiguration build() {
            return new ReplicationConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReplicationConfiguration> {
        public Builder role(String var1);

        public Builder rules(Collection<ReplicationRule> var1);

        public Builder rules(ReplicationRule ... var1);
    }
}

