/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.services.s3.model.AnalyticsExportDestination;
import software.amazon.awssdk.services.s3.model.StorageClassAnalysisSchemaVersion;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StorageClassAnalysisDataExport
implements ToCopyableBuilder<Builder, StorageClassAnalysisDataExport> {
    private final String outputSchemaVersion;
    private final AnalyticsExportDestination destination;

    private StorageClassAnalysisDataExport(BuilderImpl builder) {
        this.outputSchemaVersion = builder.outputSchemaVersion;
        this.destination = builder.destination;
    }

    public String outputSchemaVersion() {
        return this.outputSchemaVersion;
    }

    public AnalyticsExportDestination destination() {
        return this.destination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.outputSchemaVersion() == null ? 0 : this.outputSchemaVersion().hashCode());
        hashCode = 31 * hashCode + (this.destination() == null ? 0 : this.destination().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageClassAnalysisDataExport)) {
            return false;
        }
        StorageClassAnalysisDataExport other = (StorageClassAnalysisDataExport)obj;
        if (other.outputSchemaVersion() == null ^ this.outputSchemaVersion() == null) {
            return false;
        }
        if (other.outputSchemaVersion() != null && !other.outputSchemaVersion().equals(this.outputSchemaVersion())) {
            return false;
        }
        if (other.destination() == null ^ this.destination() == null) {
            return false;
        }
        return other.destination() == null || other.destination().equals(this.destination());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.outputSchemaVersion() != null) {
            sb.append("OutputSchemaVersion: ").append(this.outputSchemaVersion()).append(",");
        }
        if (this.destination() != null) {
            sb.append("Destination: ").append(this.destination()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String outputSchemaVersion;
        private AnalyticsExportDestination destination;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageClassAnalysisDataExport model) {
            this.setOutputSchemaVersion(model.outputSchemaVersion);
            this.setDestination(model.destination);
        }

        public final String getOutputSchemaVersion() {
            return this.outputSchemaVersion;
        }

        @Override
        public final Builder outputSchemaVersion(String outputSchemaVersion) {
            this.outputSchemaVersion = outputSchemaVersion;
            return this;
        }

        @Override
        public final Builder outputSchemaVersion(StorageClassAnalysisSchemaVersion outputSchemaVersion) {
            this.outputSchemaVersion(outputSchemaVersion.toString());
            return this;
        }

        public final void setOutputSchemaVersion(String outputSchemaVersion) {
            this.outputSchemaVersion = outputSchemaVersion;
        }

        public final void setOutputSchemaVersion(StorageClassAnalysisSchemaVersion outputSchemaVersion) {
            this.outputSchemaVersion(outputSchemaVersion.toString());
        }

        public final AnalyticsExportDestination getDestination() {
            return this.destination;
        }

        @Override
        public final Builder destination(AnalyticsExportDestination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(AnalyticsExportDestination destination) {
            this.destination = destination;
        }

        public StorageClassAnalysisDataExport build() {
            return new StorageClassAnalysisDataExport(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StorageClassAnalysisDataExport> {
        public Builder outputSchemaVersion(String var1);

        public Builder outputSchemaVersion(StorageClassAnalysisSchemaVersion var1);

        public Builder destination(AnalyticsExportDestination var1);
    }
}

