/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.s3.model.Event;
import software.amazon.awssdk.services.s3.model.EventListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TopicConfigurationDeprecated
implements ToCopyableBuilder<Builder, TopicConfigurationDeprecated> {
    private final String id;
    private final List<String> events;
    private final String event;
    private final String topic;

    private TopicConfigurationDeprecated(BuilderImpl builder) {
        this.id = builder.id;
        this.events = builder.events;
        this.event = builder.event;
        this.topic = builder.topic;
    }

    public String id() {
        return this.id;
    }

    public List<String> events() {
        return this.events;
    }

    public String event() {
        return this.event;
    }

    public String topic() {
        return this.topic;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.events() == null ? 0 : this.events().hashCode());
        hashCode = 31 * hashCode + (this.event() == null ? 0 : this.event().hashCode());
        hashCode = 31 * hashCode + (this.topic() == null ? 0 : this.topic().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicConfigurationDeprecated)) {
            return false;
        }
        TopicConfigurationDeprecated other = (TopicConfigurationDeprecated)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        if (other.events() != null && !other.events().equals(this.events())) {
            return false;
        }
        if (other.event() == null ^ this.event() == null) {
            return false;
        }
        if (other.event() != null && !other.event().equals(this.event())) {
            return false;
        }
        if (other.topic() == null ^ this.topic() == null) {
            return false;
        }
        return other.topic() == null || other.topic().equals(this.topic());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.events() != null) {
            sb.append("Events: ").append(this.events()).append(",");
        }
        if (this.event() != null) {
            sb.append("Event: ").append(this.event()).append(",");
        }
        if (this.topic() != null) {
            sb.append("Topic: ").append(this.topic()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private List<String> events;
        private String event;
        private String topic;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicConfigurationDeprecated model) {
            this.setId(model.id);
            this.setEvents(model.events);
            this.setEvent(model.event);
            this.setTopic(model.topic);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<String> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Collection<String> events) {
            this.events = EventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(String ... events) {
            if (this.events == null) {
                this.events = new ArrayList<String>(events.length);
            }
            for (String e : events) {
                this.events.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Event ... events) {
            if (this.events == null) {
                this.events = new ArrayList<String>(events.length);
            }
            for (Event ele : events) {
                this.events.add(ele.toString());
            }
            return this;
        }

        public final void setEvents(Collection<String> events) {
            this.events = EventListCopier.copy(events);
        }

        @SafeVarargs
        public final void setEvents(String ... events) {
            if (this.events == null) {
                this.events = new ArrayList<String>(events.length);
            }
            for (String e : events) {
                this.events.add(e);
            }
        }

        @SafeVarargs
        public final void setEvents(Event ... events) {
            if (this.events == null) {
                this.events = new ArrayList<String>(events.length);
            }
            for (Event ele : events) {
                this.events.add(ele.toString());
            }
        }

        public final String getEvent() {
            return this.event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(Event event) {
            this.event(event.toString());
            return this;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        public final void setEvent(Event event) {
            this.event(event.toString());
        }

        public final String getTopic() {
            return this.topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        public TopicConfigurationDeprecated build() {
            return new TopicConfigurationDeprecated(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TopicConfigurationDeprecated> {
        public Builder id(String var1);

        public Builder events(Collection<String> var1);

        public Builder events(String ... var1);

        public Builder events(Event ... var1);

        public Builder event(String var1);

        public Builder event(Event var1);

        public Builder topic(String var1);
    }
}

