/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationRequest;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class GetBucketAnalyticsConfigurationRequestMarshaller
implements Marshaller<Request<GetBucketAnalyticsConfigurationRequest>, GetBucketAnalyticsConfigurationRequest> {
    public Request<GetBucketAnalyticsConfigurationRequest> marshall(GetBucketAnalyticsConfigurationRequest getBucketAnalyticsConfigurationRequest) {
        if (getBucketAnalyticsConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getBucketAnalyticsConfigurationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}?analytics";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", getBucketAnalyticsConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (getBucketAnalyticsConfigurationRequest.id() != null) {
            request.addParameter("id", StringUtils.fromString((String)getBucketAnalyticsConfigurationRequest.id()));
        }
        return request;
    }
}

