/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.LifecycleRule;
import software.amazon.awssdk.services.s3.transform.AbortIncompleteMultipartUploadUnmarshaller;
import software.amazon.awssdk.services.s3.transform.LifecycleExpirationUnmarshaller;
import software.amazon.awssdk.services.s3.transform.LifecycleRuleFilterUnmarshaller;
import software.amazon.awssdk.services.s3.transform.NoncurrentVersionExpirationUnmarshaller;
import software.amazon.awssdk.services.s3.transform.NoncurrentVersionTransitionUnmarshaller;
import software.amazon.awssdk.services.s3.transform.TransitionUnmarshaller;

public class LifecycleRuleUnmarshaller
implements Unmarshaller<LifecycleRule, StaxUnmarshallerContext> {
    private static LifecycleRuleUnmarshaller INSTANCE;

    public LifecycleRule unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        LifecycleRule.Builder lifecycleRule = LifecycleRule.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Expiration", targetDepth)) {
                    lifecycleRule.expiration(LifecycleExpirationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ID", targetDepth)) {
                    lifecycleRule.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Prefix", targetDepth)) {
                    lifecycleRule.prefix(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Filter", targetDepth)) {
                    lifecycleRule.filter(LifecycleRuleFilterUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    lifecycleRule.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Transition", targetDepth)) {
                    lifecycleRule.transitions(TransitionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NoncurrentVersionTransition", targetDepth)) {
                    lifecycleRule.noncurrentVersionTransitions(NoncurrentVersionTransitionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NoncurrentVersionExpiration", targetDepth)) {
                    lifecycleRule.noncurrentVersionExpiration(NoncurrentVersionExpirationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("AbortIncompleteMultipartUpload", targetDepth)) continue;
                lifecycleRule.abortIncompleteMultipartUpload(AbortIncompleteMultipartUploadUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (LifecycleRule)lifecycleRule.build();
    }

    public static LifecycleRuleUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LifecycleRuleUnmarshaller();
        }
        return INSTANCE;
    }
}

